/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFileSystemItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.HeaderValue;
import org.jetbrains.lang.manifest.psi.HeaderValuePart;
import org.jetbrains.osgi.project.BundleManifest;
import org.jetbrains.osgi.project.BundleManifestCache;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.i18n.OsmorcBundle;
import org.osmorc.inspection.AbstractOsgiVisitor;
import org.osmorc.manifest.lang.psi.Clause;
import org.osmorc.util.OsgiPsiUtil;

public class WrongImportPackageInspection
extends AbstractOsgiVisitor {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(OsmorcFacet facet, final ProblemsHolder holder, boolean isOnTheFly) {
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                if (OsgiPsiUtil.isHeader(element, "Import-Package")) {
                    block0: for (HeaderValue value : ((Header)element).getHeaderValues()) {
                        PsiDirectory[] directories;
                        HeaderValuePart valuePart;
                        if (!(value instanceof Clause) || (valuePart = ((Clause)value).getValue()) == null) continue;
                        String packageName = valuePart.getUnwrappedText();
                        if (packageName.endsWith(".*")) {
                            packageName = packageName.substring(0, packageName.length() - 2);
                        }
                        if (StringUtil.isEmptyOrSpaces((String)packageName) || (directories = OsgiPsiUtil.resolvePackage(element, packageName)).length == 0) continue;
                        for (PsiDirectory directory : directories) {
                            BundleManifest manifest = BundleManifestCache.getInstance(element.getProject()).getManifest((PsiFileSystemItem)directory);
                            if (manifest != null && manifest.getExportedPackage(packageName) != null) continue block0;
                        }
                        String message = OsmorcBundle.message("WrongImportPackageInspection.message", new Object[0]);
                        TextRange range = valuePart.getHighlightingRange().shiftRight(-valuePart.getTextOffset());
                        holder.registerProblem((PsiElement)valuePart, range, message, new LocalQuickFix[0]);
                    }
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/inspection/WrongImportPackageInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }
}

