/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.manifest.lang.header;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiPackageReference;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.lang.manifest.ManifestBundle;
import org.jetbrains.lang.manifest.header.HeaderParser;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.HeaderValue;
import org.jetbrains.lang.manifest.psi.HeaderValuePart;
import org.osmorc.manifest.lang.header.OsgiHeaderParser;
import org.osmorc.manifest.lang.psi.Clause;
import org.osmorc.manifest.resolve.reference.providers.ManifestPackageReferenceSet;
import org.osmorc.util.OsgiPsiUtil;

public class BasePackageParser
extends OsgiHeaderParser {
    public static final HeaderParser INSTANCE = new BasePackageParser();

    @NotNull
    public PsiReference[] getReferences(@NotNull HeaderValuePart headerValuePart) {
        if (headerValuePart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerValuePart", "org/osmorc/manifest/lang/header/BasePackageParser", "getReferences"));
        }
        if (headerValuePart.getParent() instanceof Clause) {
            PsiReference[] psiReferenceArray = BasePackageParser.getPackageReferences((PsiElement)headerValuePart);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/manifest/lang/header/BasePackageParser", "getReferences"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/manifest/lang/header/BasePackageParser", "getReferences"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    protected static PsiReference[] getPackageReferences(PsiElement psiElement) {
        int size;
        String packageName = psiElement.getText();
        if (StringUtil.isEmptyOrSpaces((String)packageName)) {
            return PsiReference.EMPTY_ARRAY;
        }
        int offset = 0;
        if (packageName.charAt(0) == '!') {
            packageName = packageName.substring(1);
            offset = 1;
        }
        if (packageName.charAt(size = packageName.length() - 1) == '?') {
            packageName = packageName.substring(0, size);
        }
        ManifestPackageReferenceSet referenceSet = new ManifestPackageReferenceSet(packageName, psiElement, offset);
        return (PsiReference[])referenceSet.getReferences().toArray(new PsiPackageReference[referenceSet.getReferences().size()]);
    }

    public boolean annotate(@NotNull Header header, @NotNull AnnotationHolder holder) {
        if (header == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "org/osmorc/manifest/lang/header/BasePackageParser", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/osmorc/manifest/lang/header/BasePackageParser", "annotate"));
        }
        boolean annotated = false;
        for (HeaderValue value : header.getHeaderValues()) {
            HeaderValuePart valuePart;
            if (!(value instanceof Clause) || (valuePart = ((Clause)value).getValue()) == null) continue;
            String packageName = valuePart.getUnwrappedText();
            if (packageName.endsWith(".*")) {
                packageName = packageName.substring(0, packageName.length() - 2);
            }
            if (StringUtil.isEmptyOrSpaces((String)packageName)) {
                holder.createErrorAnnotation(valuePart.getHighlightingRange(), ManifestBundle.message((String)"header.reference.invalid", (Object[])new Object[0]));
                annotated = true;
                continue;
            }
            PsiDirectory[] directories = OsgiPsiUtil.resolvePackage((PsiElement)header, packageName);
            if (directories.length != 0) continue;
            holder.createErrorAnnotation(valuePart.getHighlightingRange(), JavaErrorMessages.message((String)"cannot.resolve.package", (Object[])new Object[]{packageName}));
            annotated = true;
        }
        return annotated;
    }

    @Nullable
    public Object getConvertedValue(@NotNull Header header) {
        if (header == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "org/osmorc/manifest/lang/header/BasePackageParser", "getConvertedValue"));
        }
        List headerValues = header.getHeaderValues();
        if (!headerValues.isEmpty()) {
            ArrayList packages = ContainerUtil.newArrayListWithCapacity((int)headerValues.size());
            for (HeaderValue headerValue : headerValues) {
                HeaderValuePart valuePart = ((Clause)headerValue).getValue();
                if (valuePart == null) continue;
                String packageName = valuePart.getText().replaceAll("\\s+", "");
                packages.add(packageName);
            }
            return packages;
        }
        return null;
    }
}

