/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestFileTypeFactory;

public class ManifestEditor
extends EditorTextField
implements Disposable {
    private final MyDocumentAdapter listener;

    public ManifestEditor(@NotNull Project project, final String text) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/osmorc/settings/ManifestEditor", "<init>"));
        }
        super("", project, (FileType)ManifestFileTypeFactory.MANIFEST);
        this.listener = new MyDocumentAdapter();
        this.addDocumentListener((DocumentListener)this.listener);
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ManifestEditor.this.setText(text);
            }
        });
    }

    protected EditorEx createEditor() {
        EditorEx editor = super.createEditor();
        editor.setVerticalScrollbarVisible(true);
        editor.setHorizontalScrollbarVisible(true);
        return editor;
    }

    protected boolean isOneLineMode() {
        return false;
    }

    public void dispose() {
        this.removeDocumentListener((DocumentListener)this.listener);
    }

    private class MyDocumentAdapter
    extends DocumentAdapter {
        private MyDocumentAdapter() {
        }

        public void documentChanged(DocumentEvent e) {
            ManifestEditor.this.firePropertyChange("text", null, null);
        }
    }
}

