/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.groovy.resolve.noncode;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.groovy.GrCucumberCommonClassNames;
import org.jetbrains.plugins.cucumber.groovy.GrCucumberUtil;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class CustomWorldContributor
extends NonCodeMembersContributor {
    public void processDynamicElements(@NotNull PsiType qualifierType, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        GrClosableBlock closureContainer;
        if (qualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "org/jetbrains/plugins/cucumber/groovy/resolve/noncode/CustomWorldContributor", "processDynamicElements"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/cucumber/groovy/resolve/noncode/CustomWorldContributor", "processDynamicElements"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/cucumber/groovy/resolve/noncode/CustomWorldContributor", "processDynamicElements"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/cucumber/groovy/resolve/noncode/CustomWorldContributor", "processDynamicElements"));
        }
        if (place instanceof GrReferenceExpression && ((GrReferenceExpression)place).getQualifier() == null && qualifierType.equalsToText("groovy.lang.Closure") && (closureContainer = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)place, GrClosableBlock.class, (boolean)true, (Class[])new Class[]{GrMember.class})) != null) {
            PsiElement parent = closureContainer.getParent();
            if (parent instanceof GrArgumentList && CustomWorldContributor.isLastArg((GrArgumentList)parent, closureContainer)) {
                parent = parent.getParent();
            }
            if (parent instanceof GrMethodCall && (GrCucumberUtil.isStepDefinition(parent) || GrCucumberUtil.isHook((GrMethodCall)parent))) {
                CustomWorldContributor.doProcessDynamicMethods(processor, place, state, parent.getContainingFile());
            }
        }
    }

    private static void doProcessDynamicMethods(@NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state, PsiFile stepFile) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/cucumber/groovy/resolve/noncode/CustomWorldContributor", "doProcessDynamicMethods"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/cucumber/groovy/resolve/noncode/CustomWorldContributor", "doProcessDynamicMethods"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/cucumber/groovy/resolve/noncode/CustomWorldContributor", "doProcessDynamicMethods"));
        }
        if (stepFile instanceof GroovyFile) {
            PsiType worldType = CustomWorldContributor.getWorldType((GroovyFile)stepFile);
            if (worldType != null) {
                ResolveUtil.processAllDeclarations((PsiType)worldType, (PsiScopeProcessor)processor, (ResolveState)state, (PsiElement)place);
            } else {
                PsiFile[] files;
                GlobalSearchScope scope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)stepFile.getResolveScope(), (FileType[])GroovyFileType.getGroovyEnabledFileTypes());
                for (PsiFile file : files = CacheManager.SERVICE.getInstance((Project)place.getProject()).getFilesWithWord("World", (short)1, scope, true)) {
                    PsiType type;
                    if (!(file instanceof GroovyFile) || (type = CustomWorldContributor.getWorldType((GroovyFile)file)) == null || ResolveUtil.processAllDeclarations((PsiType)type, (PsiScopeProcessor)processor, (ResolveState)state, (PsiElement)place)) continue;
                    return;
                }
            }
        }
    }

    @Nullable
    private static PsiType getWorldType(final @NotNull GroovyFile stepFile) {
        if (stepFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stepFile", "org/jetbrains/plugins/cucumber/groovy/resolve/noncode/CustomWorldContributor", "getWorldType"));
        }
        return (PsiType)CachedValuesManager.getCachedValue((PsiElement)stepFile, (CachedValueProvider)new CachedValueProvider<PsiType>(){

            @Nullable
            public CachedValueProvider.Result<PsiType> compute() {
                for (GrStatement statement : stepFile.getStatements()) {
                    if (!(statement instanceof GrMethodCall) || !CustomWorldContributor.isWorldDeclaration((GrMethodCall)statement)) continue;
                    GrClosableBlock closure = CustomWorldContributor.getClosureArg((GrMethodCall)statement);
                    return CachedValueProvider.Result.create((Object)(closure == null ? null : closure.getReturnType()), (Object[])new Object[]{stepFile});
                }
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{stepFile});
            }
        });
    }

    @Nullable
    private static GrClosableBlock getClosureArg(@NotNull GrMethodCall methodCall) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "org/jetbrains/plugins/cucumber/groovy/resolve/noncode/CustomWorldContributor", "getClosureArg"));
        }
        GrClosableBlock[] closures = methodCall.getClosureArguments();
        if (closures.length == 1) {
            return closures[0];
        }
        if (closures.length > 1) {
            return null;
        }
        Object[] args = methodCall.getExpressionArguments();
        if (args.length == 0) {
            return null;
        }
        GrExpression last = (GrExpression)DefaultGroovyMethods.last((Object[])args);
        if (last instanceof GrClosableBlock) {
            return (GrClosableBlock)last;
        }
        return null;
    }

    private static boolean isWorldDeclaration(@NotNull GrMethodCall methodCall) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "org/jetbrains/plugins/cucumber/groovy/resolve/noncode/CustomWorldContributor", "isWorldDeclaration"));
        }
        GrExpression invoked = methodCall.getInvokedExpression();
        if (invoked instanceof GrReferenceExpression) {
            PsiMethod method = methodCall.resolveMethod();
            PsiClass clazz = method == null ? null : method.getContainingClass();
            String qname = clazz == null ? null : clazz.getQualifiedName();
            return method != null && "World".equals(method.getName()) && GrCucumberCommonClassNames.isHookClassName(qname);
        }
        return false;
    }

    private static boolean isLastArg(@NotNull GrArgumentList list, @NotNull GrClosableBlock block) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/plugins/cucumber/groovy/resolve/noncode/CustomWorldContributor", "isLastArg"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/plugins/cucumber/groovy/resolve/noncode/CustomWorldContributor", "isLastArg"));
        }
        GrExpression[] exprs = list.getExpressionArguments();
        return exprs.length > 0 && exprs[exprs.length - 1] == block;
    }
}

