/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.comment;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSElementPredicate;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NotNull;

public class JSChangeToCStyleCommentIntention
extends JSIntention {
    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        EndOfLineCommentPredicate endOfLineCommentPredicate = new EndOfLineCommentPredicate();
        if (endOfLineCommentPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/comment/JSChangeToCStyleCommentIntention", "getElementPredicate"));
        }
        return endOfLineCommentPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiComment lastElementToDelete;
        PsiElement prevComment;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/comment/JSChangeToCStyleCommentIntention", "processIntention"));
        }
        PsiComment firstComment = (PsiComment)element;
        while (JSChangeToCStyleCommentIntention.isEndOfLineComment(prevComment = JSElementFactory.getNonWhiteSpaceSibling((PsiElement)firstComment, false))) {
            assert (prevComment != null);
            firstComment = (PsiComment)prevComment;
        }
        StringBuilder buffer = new StringBuilder(JSChangeToCStyleCommentIntention.getCommentContents(firstComment));
        PsiComment nextComment = firstComment;
        while (true) {
            lastElementToDelete = nextComment;
            if (!JSChangeToCStyleCommentIntention.isEndOfLineComment((PsiElement)(nextComment = JSElementFactory.getNonWhiteSpaceSibling((PsiElement)nextComment, true)))) break;
            assert (nextComment != null);
            PsiElement prevSibling = nextComment.getPrevSibling();
            assert (prevSibling != null);
            buffer.append(prevSibling.getText()).append(JSChangeToCStyleCommentIntention.getCommentContents(nextComment));
        }
        String text = StringUtil.replace((String)buffer.toString(), (String)"*/", (String)"* /");
        String newCommentString = text.indexOf(10) >= 0 ? "/*\n" + text + "\n*/" : "/*" + text + "*/";
        JSElementFactory.addElementBefore((PsiElement)firstComment, newCommentString);
        JSElementFactory.removeRange((PsiElement)firstComment, (PsiElement)lastElementToDelete);
    }

    private static boolean isEndOfLineComment(PsiElement element) {
        if (!(element instanceof PsiComment)) {
            return false;
        }
        PsiComment comment = (PsiComment)element;
        IElementType tokenType = comment.getTokenType();
        return JSTokenTypes.END_OF_LINE_COMMENT.equals(tokenType);
    }

    private static String getCommentContents(PsiComment comment) {
        return comment.getText().substring(2);
    }

    private static class EndOfLineCommentPredicate
    implements JSElementPredicate {
        private EndOfLineCommentPredicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/comment/JSChangeToCStyleCommentIntention$EndOfLineCommentPredicate", "satisfiedBy"));
            }
            if (!(element instanceof PsiComment)) {
                return false;
            }
            IElementType type = ((PsiComment)element).getTokenType();
            return JSTokenTypes.END_OF_LINE_COMMENT.equals(type);
        }
    }
}

