/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.initialization;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.Iterator;
import org.intellij.idea.lang.javascript.intention.JSElementPredicate;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.ErrorUtil;
import org.intellij.idea.lang.javascript.psiutil.FindReferenceUtil;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NotNull;

public class JSMergeDeclarationAndInitializationIntention
extends JSIntention {
    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        Predicate predicate = new Predicate();
        if (predicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/initialization/JSMergeDeclarationAndInitializationIntention", "getElementPredicate"));
        }
        return predicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/initialization/JSMergeDeclarationAndInitializationIntention", "processIntention"));
        }
        assert (element instanceof JSVarStatement);
        JSVarStatement varStatement = (JSVarStatement)element;
        ASTNode node = varStatement.getNode();
        ASTNode varModifier = node.findChildByType(JSTokenTypes.VAR_MODIFIERS);
        String varStatementKeyword = varModifier == null ? "var " : varModifier.getText() + " ";
        StringBuilder declarationBuffer = new StringBuilder();
        boolean ecma = JSUtils.getDialect((PsiFile)element.getContainingFile()) == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        for (JSVariable variable : varStatement.getVariables()) {
            String type;
            String string = type = ecma ? variable.getTypeString() : null;
            if (variable.hasInitializer()) {
                declarationBuffer.append(declarationBuffer.length() == 0 ? varStatementKeyword : ", ").append(variable.getName()).append(type != null ? ":" + type : "").append(" = ").append(variable.getInitializer().getText());
                continue;
            }
            Iterator<PsiElement> referenceIterator = FindReferenceUtil.getReferencesAfter(variable, variable.getTextRange().getEndOffset()).iterator();
            JSReferenceExpression firstReference = (JSReferenceExpression)(referenceIterator.hasNext() ? referenceIterator.next() : null);
            if (firstReference == null || !(firstReference.getParent() instanceof JSDefinitionExpression)) continue;
            JSExpressionStatement assignmentStatement = (JSExpressionStatement)firstReference.getParent().getParent().getParent();
            JSElementFactory.replaceStatement((JSStatement)assignmentStatement, varStatementKeyword + firstReference.getReferencedName() + (type != null ? ":" + type : "") + "=" + ((JSAssignmentExpression)firstReference.getParent().getParent()).getROperand().getText() + JSCodeStyleSettings.getSemicolon((PsiFile)element.getContainingFile()));
        }
        if (declarationBuffer.length() == 0) {
            JSElementFactory.removeElement((PsiElement)varStatement);
        } else {
            declarationBuffer.append(';');
            JSElementFactory.replaceStatement((JSStatement)varStatement, declarationBuffer.toString());
        }
    }

    private static class Predicate
    implements JSElementPredicate {
        private Predicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/initialization/JSMergeDeclarationAndInitializationIntention$Predicate", "satisfiedBy"));
            }
            if (!(element instanceof JSVarStatement)) {
                return false;
            }
            JSVarStatement varStatement = (JSVarStatement)element;
            if (ErrorUtil.containsError((PsiElement)varStatement)) {
                return false;
            }
            for (JSVariable variable : varStatement.getVariables()) {
                Iterator<PsiElement> referenceIterator;
                JSReferenceExpression firstReference;
                if (variable.hasInitializer() || (firstReference = (JSReferenceExpression)((referenceIterator = FindReferenceUtil.getReferencesAfter(variable, variable.getTextRange().getEndOffset()).iterator()).hasNext() ? referenceIterator.next() : null)) == null || !(firstReference.getParent() instanceof JSDefinitionExpression) || !(firstReference.getParent().getParent() instanceof JSAssignmentExpression) || !(firstReference.getParent().getParent().getParent() instanceof JSExpressionStatement)) continue;
                return true;
            }
            return false;
        }
    }
}

