/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.initialization;

import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.inspections.JSDeclarationsAtScopeStartInspection;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.intellij.idea.lang.javascript.intention.JSElementPredicate;
import org.intellij.idea.lang.javascript.intention.initialization.JSSplitDeclarationAndInitializationIntention;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NotNull;

public class JSSplitDeclarationAndMoveToScopeStartIntention
extends JSSplitDeclarationAndInitializationIntention {
    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        final JSElementPredicate superPredicate = super.getElementPredicate();
        JSElementPredicate jSElementPredicate = new JSElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/initialization/JSSplitDeclarationAndMoveToScopeStartIntention$1", "satisfiedBy"));
                }
                return superPredicate.satisfiedBy(element) && JSDeclarationsAtScopeStartInspection.findContainingFunctionFirstStatement((PsiElement)element) != element;
            }
        };
        if (jSElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/initialization/JSSplitDeclarationAndMoveToScopeStartIntention", "getElementPredicate"));
        }
        return jSElementPredicate;
    }

    @Override
    protected void doReplacement(String declarations, List<String> initializations, JSVarStatement oldVarStatement) {
        PsiFile containingFile = oldVarStatement.getContainingFile();
        Project project = containingFile.getProject();
        JSLanguageDialect dialect = JSUtils.getDialect((PsiFile)containingFile);
        JSStatement newStatement = (JSStatement)JSChangeUtil.createStatementFromText((Project)project, (String)declarations, (JSLanguageDialect)dialect).getPsi();
        JSStatement newStatementAnchor = JSDeclarationsAtScopeStartInspection.findContainingFunctionFirstStatement((PsiElement)oldVarStatement);
        if (newStatementAnchor == null) {
            newStatementAnchor = oldVarStatement;
        }
        newStatementAnchor.getParent().addBefore((PsiElement)newStatement, (PsiElement)newStatementAnchor);
        JSStatement assignmentStatement = null;
        boolean first = true;
        for (String initialization : initializations) {
            if (first) {
                first = false;
                assignmentStatement = JSElementFactory.replaceStatement((JSStatement)oldVarStatement, initialization);
                continue;
            }
            assignmentStatement = assignmentStatement.addStatementAfter((JSStatement)JSChangeUtil.createStatementFromText((Project)project, (String)initialization, (JSLanguageDialect)dialect).getPsi());
        }
    }
}

