/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.loop;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSElementPredicate;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.EquivalenceChecker;
import org.intellij.idea.lang.javascript.psiutil.ErrorUtil;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSMergeParallelForInLoopsIntention
extends JSIntention {
    @NonNls
    private static final String FOR_IN_PREFIX = "for (";
    @NonNls
    private static final String FOR_IN_COLLECTION_PREFIX = " in ";

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        MergeParallelForInLoopsPredicate mergeParallelForInLoopsPredicate = new MergeParallelForInLoopsPredicate();
        if (mergeParallelForInLoopsPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/loop/JSMergeParallelForInLoopsIntention", "getElementPredicate"));
        }
        return mergeParallelForInLoopsPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/loop/JSMergeParallelForInLoopsIntention", "processIntention"));
        }
        PsiElement nextElement = JSElementFactory.getNonWhiteSpaceSibling(element, true);
        assert (nextElement != null);
        JSForInStatement firstStatement = (JSForInStatement)element;
        JSForInStatement secondStatement = (JSForInStatement)nextElement;
        StringBuilder statementBuffer = new StringBuilder();
        this.mergeForInStatements(statementBuffer, firstStatement, secondStatement);
        JSElementFactory.replaceStatement((JSStatement)firstStatement, statementBuffer.toString());
        JSElementFactory.removeElement((PsiElement)secondStatement);
    }

    private void mergeForInStatements(StringBuilder statementBuffer, JSForInStatement firstStatement, JSForInStatement secondStatement) {
        JSExpression variableExpression = JSMergeParallelForInLoopsIntention.getVariableExpression(firstStatement);
        JSVarStatement declaration = firstStatement.getDeclarationStatement();
        JSExpression collectionExpression = JSMergeParallelForInLoopsIntention.getCollectionExpression(firstStatement);
        JSStatement firstBody = firstStatement.getBody();
        JSStatement secondBody = secondStatement.getBody();
        statementBuffer.append(FOR_IN_PREFIX).append(declaration == null ? variableExpression.getText() : declaration.getText()).append(FOR_IN_COLLECTION_PREFIX).append(collectionExpression.getText()).append(')');
        ControlFlowUtils.appendStatementsInSequence((StringBuilder)statementBuffer, (JSStatement)firstBody, (JSStatement)secondBody);
    }

    private static JSExpression getCollectionExpression(JSForInStatement forInStatement) {
        boolean inPassed = false;
        for (ASTNode child = (statementNode = forInStatement.getNode()) == null ? null : statementNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == JSTokenTypes.IN_KEYWORD) {
                inPassed = true;
            }
            if (!inPassed || !JSElementTypes.EXPRESSIONS.contains(child.getElementType())) continue;
            return (JSExpression)child.getPsi();
        }
        return null;
    }

    private static JSExpression getVariableExpression(JSForInStatement forInStatement) {
        ASTNode child;
        ASTNode statementNode = forInStatement.getNode();
        ASTNode aSTNode = child = statementNode == null ? null : statementNode.getFirstChildNode();
        while (child != null) {
            if (child.getElementType() == JSTokenTypes.IN_KEYWORD) {
                return null;
            }
            if (JSElementTypes.EXPRESSIONS.contains(child.getElementType())) {
                return (JSExpression)child.getPsi();
            }
            child = child.getTreeNext();
        }
        return null;
    }

    private static class MergeParallelForInLoopsPredicate
    implements JSElementPredicate {
        private MergeParallelForInLoopsPredicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/loop/JSMergeParallelForInLoopsIntention$MergeParallelForInLoopsPredicate", "satisfiedBy"));
            }
            if (!(element instanceof JSForInStatement) || ErrorUtil.containsError(element)) {
                return false;
            }
            PsiElement nextStatement = JSElementFactory.getNonWhiteSpaceSibling(element, true);
            if (!(nextStatement instanceof JSForInStatement) || ErrorUtil.containsError(nextStatement)) {
                return false;
            }
            return MergeParallelForInLoopsPredicate.forInStatementsCanBeMerged((JSForInStatement)element, (JSForInStatement)nextStatement);
        }

        public static boolean forInStatementsCanBeMerged(JSForInStatement statement1, JSForInStatement statement2) {
            JSExpression secondCollection;
            JSVarStatement secondDeclaration;
            JSExpression secondVarExpression;
            JSExpression firstVarExpression = JSMergeParallelForInLoopsIntention.getVariableExpression(statement1);
            if (!EquivalenceChecker.expressionsAreEquivalent(firstVarExpression, secondVarExpression = JSMergeParallelForInLoopsIntention.getVariableExpression(statement2))) {
                return false;
            }
            JSVarStatement firstDeclaration = statement1.getDeclarationStatement();
            if (!EquivalenceChecker.statementsAreEquivalent((JSStatement)firstDeclaration, (JSStatement)(secondDeclaration = statement2.getDeclarationStatement()))) {
                return false;
            }
            JSExpression firstCollection = JSMergeParallelForInLoopsIntention.getCollectionExpression(statement1);
            if (!EquivalenceChecker.expressionsAreEquivalent(firstCollection, secondCollection = JSMergeParallelForInLoopsIntention.getCollectionExpression(statement2))) {
                return false;
            }
            JSStatement firstBody = statement1.getBody();
            JSStatement secondBody = statement2.getBody();
            return firstBody == null || secondBody == null || ControlFlowUtils.canBeMerged((JSStatement)firstBody, (JSStatement)secondBody);
        }
    }
}

