/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.number;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSElementPredicate;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.intention.number.ShiftUtils;
import org.intellij.idea.lang.javascript.psiutil.BinaryOperatorUtils;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.intellij.idea.lang.javascript.psiutil.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class JSReplaceMultiplyWithShiftIntention
extends JSMutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        IElementType tokenType = ((JSBinaryExpression)element).getOperationSign();
        String operatorString = element instanceof JSAssignmentExpression ? (tokenType.equals(JSTokenTypes.MULTEQ) ? "<<=" : ">>=") : (tokenType.equals(JSTokenTypes.MULT) ? "<<" : ">>");
        return this.getText(BinaryOperatorUtils.getOperatorText(tokenType), operatorString);
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        MultiplyByPowerOfTwoPredicate multiplyByPowerOfTwoPredicate = new MultiplyByPowerOfTwoPredicate();
        if (multiplyByPowerOfTwoPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/number/JSReplaceMultiplyWithShiftIntention", "getElementPredicate"));
        }
        return multiplyByPowerOfTwoPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/number/JSReplaceMultiplyWithShiftIntention", "processIntention"));
        }
        if (element instanceof JSAssignmentExpression) {
            this.replaceMultiplyOrDivideAssignWithShiftAssign((JSAssignmentExpression)element);
        } else {
            this.replaceMultiplyOrDivideWithShift((JSBinaryExpression)element);
        }
    }

    private void replaceMultiplyOrDivideAssignWithShiftAssign(JSAssignmentExpression exp) throws IncorrectOperationException {
        JSExpression lhs = exp.getLOperand();
        JSExpression rhs = exp.getROperand();
        IElementType tokenType = exp.getOperationSign();
        String assignString = tokenType.equals(JSTokenTypes.MULTEQ) ? "<<=" : ">>=";
        String expString = lhs.getText() + assignString + ShiftUtils.getLogBase2(rhs);
        JSElementFactory.replaceExpression((JSExpression)exp, expString);
    }

    private void replaceMultiplyOrDivideWithShift(JSBinaryExpression exp) throws IncorrectOperationException {
        String operatorString;
        JSExpression lhs = exp.getLOperand();
        JSExpression rhs = exp.getROperand();
        IElementType tokenType = exp.getOperationSign();
        String string = operatorString = tokenType.equals(JSTokenTypes.MULT) ? "<<" : ">>";
        if (ShiftUtils.isPowerOfTwo(lhs) && tokenType.equals(JSTokenTypes.MULT)) {
            JSExpression swap = lhs;
            lhs = rhs;
            rhs = swap;
        }
        String lhsText = ParenthesesUtils.getParenthesized(lhs, 7);
        String expString = lhsText + operatorString + ShiftUtils.getLogBase2(rhs);
        JSElement parent = (JSElement)exp.getParent();
        if (parent != null && parent instanceof JSExpression && !(parent instanceof JSParenthesizedExpression) && ParenthesesUtils.getPrecendence((JSExpression)parent) < 7) {
            expString = '(' + expString + ')';
        }
        JSElementFactory.replaceExpression((JSExpression)exp, expString);
    }

    private static class MultiplyByPowerOfTwoPredicate
    implements JSElementPredicate {
        private MultiplyByPowerOfTwoPredicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/number/JSReplaceMultiplyWithShiftIntention$MultiplyByPowerOfTwoPredicate", "satisfiedBy"));
            }
            if (element instanceof JSAssignmentExpression) {
                return MultiplyByPowerOfTwoPredicate.isMultiplyByPowerOfTwo((JSAssignmentExpression)element);
            }
            if (element instanceof JSBinaryExpression) {
                return MultiplyByPowerOfTwoPredicate.isMultiplyByPowerOfTwo((JSBinaryExpression)element);
            }
            return false;
        }

        private static boolean isMultiplyByPowerOfTwo(JSAssignmentExpression expression) {
            IElementType operator = expression.getOperationSign();
            if (operator == null || !operator.equals(JSTokenTypes.MULTEQ) && !operator.equals(JSTokenTypes.DIVEQ)) {
                return false;
            }
            JSExpression rightExpression = expression.getROperand();
            if (rightExpression == null) {
                return false;
            }
            return ShiftUtils.isPowerOfTwo(rightExpression);
        }

        private static boolean isMultiplyByPowerOfTwo(JSBinaryExpression expression) {
            IElementType operator = expression.getOperationSign();
            if (operator == null || !operator.equals(JSTokenTypes.MULT) && !operator.equals(JSTokenTypes.DIV)) {
                return false;
            }
            JSExpression leftOperand = expression.getLOperand();
            JSExpression rightOperand = expression.getROperand();
            if (leftOperand == null || rightOperand == null) {
                return false;
            }
            return ShiftUtils.isPowerOfTwo(leftOperand) || ShiftUtils.isPowerOfTwo(rightOperand);
        }
    }
}

