/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.number;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSElementPredicate;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.intention.number.ShiftUtils;
import org.intellij.idea.lang.javascript.psiutil.BinaryOperatorUtils;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.intellij.idea.lang.javascript.psiutil.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class JSReplaceShiftWithMultiplyIntention
extends JSMutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        IElementType tokenType = ((JSBinaryExpression)element).getOperationSign();
        String operatorString = element instanceof JSAssignmentExpression ? (tokenType.equals(JSTokenTypes.LTLTEQ) ? "*=" : "/=") : (tokenType.equals(JSTokenTypes.LTLT) ? "*" : "/");
        return this.getText(BinaryOperatorUtils.getOperatorText(tokenType), operatorString);
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        ShiftByLiteralPredicate shiftByLiteralPredicate = new ShiftByLiteralPredicate();
        if (shiftByLiteralPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/number/JSReplaceShiftWithMultiplyIntention", "getElementPredicate"));
        }
        return shiftByLiteralPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/number/JSReplaceShiftWithMultiplyIntention", "processIntention"));
        }
        if (element instanceof JSAssignmentExpression) {
            this.replaceShiftAssignWithMultiplyOrDivideAssign((JSAssignmentExpression)element);
        } else {
            assert (element instanceof JSBinaryExpression);
            this.replaceShiftWithMultiplyOrDivide((JSBinaryExpression)element);
        }
    }

    private void replaceShiftAssignWithMultiplyOrDivideAssign(JSAssignmentExpression exp) throws IncorrectOperationException {
        JSExpression lhs = exp.getLOperand();
        JSExpression rhs = exp.getROperand();
        IElementType tokenType = exp.getOperationSign();
        String assignString = tokenType.equals(JSTokenTypes.LTLTEQ) ? "*=" : "/=";
        String expString = lhs.getText() + assignString + ShiftUtils.getExpBase2(rhs);
        JSElementFactory.replaceExpression((JSExpression)exp, expString);
    }

    private void replaceShiftWithMultiplyOrDivide(JSBinaryExpression exp) throws IncorrectOperationException {
        JSExpression lhs = exp.getLOperand();
        JSExpression rhs = exp.getROperand();
        IElementType tokenType = exp.getOperationSign();
        String operatorString = tokenType.equals(JSTokenTypes.LTLT) ? "*" : "/";
        String lhsText = ParenthesesUtils.getParenthesized(lhs, 5);
        String expString = lhsText + operatorString + ShiftUtils.getExpBase2(rhs);
        JSElement parent = (JSElement)exp.getParent();
        if (parent != null && parent instanceof JSExpression && !(parent instanceof JSParenthesizedExpression) && ParenthesesUtils.getPrecendence((JSExpression)parent) < 5) {
            expString = '(' + expString + ')';
        }
        JSElementFactory.replaceExpression((JSExpression)exp, expString);
    }

    private static class ShiftByLiteralPredicate
    implements JSElementPredicate {
        private ShiftByLiteralPredicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/number/JSReplaceShiftWithMultiplyIntention$ShiftByLiteralPredicate", "satisfiedBy"));
            }
            if (element instanceof JSAssignmentExpression) {
                return this.isAssignmentShiftByLiteral((JSAssignmentExpression)element);
            }
            if (element instanceof JSBinaryExpression) {
                return this.isBinaryShiftByLiteral((JSBinaryExpression)element);
            }
            return false;
        }

        private boolean isAssignmentShiftByLiteral(JSAssignmentExpression expression) {
            IElementType tokenType = expression.getOperationSign();
            if (tokenType == null || !tokenType.equals(JSTokenTypes.LTLTEQ) && !tokenType.equals(JSTokenTypes.GTGTEQ)) {
                return false;
            }
            JSExpression rhs = expression.getROperand();
            if (rhs == null) {
                return false;
            }
            return ShiftUtils.isIntLiteral(rhs);
        }

        private boolean isBinaryShiftByLiteral(JSBinaryExpression expression) {
            IElementType tokenType = expression.getOperationSign();
            if (!JSTokenTypes.LTLT.equals(tokenType) && !JSTokenTypes.GTGT.equals(tokenType)) {
                return false;
            }
            return ShiftUtils.isIntLiteral(expression.getROperand());
        }
    }
}

