/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.string;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSElementPredicate;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.intention.string.StringUtil;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSingleToDoubleQuotedStringIntention
extends JSIntention {
    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        SingleToDoubleQuotedStringPredicate singleToDoubleQuotedStringPredicate = new SingleToDoubleQuotedStringPredicate();
        if (singleToDoubleQuotedStringPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/string/JSSingleToDoubleQuotedStringIntention", "getElementPredicate"));
        }
        return singleToDoubleQuotedStringPredicate;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/idea/lang/javascript/intention/string/JSSingleToDoubleQuotedStringIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/string/JSSingleToDoubleQuotedStringIntention", "invoke"));
        }
        if (JSElementFactory.isFileReadOnly(project, element.getContainingFile())) {
            return;
        }
        PsiElement matchingElement = this.findMatchingElement(element);
        if (matchingElement == null) {
            return;
        }
        editor = InjectedLanguageUtil.getTopLevelEditor((Editor)editor);
        TextRange range = matchingElement.getTextRange();
        editor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)StringUtil.changeQuotes(matchingElement.getText()));
    }

    @Override
    @Nullable
    protected PsiElement findMatchingElement(@Nullable PsiElement element) {
        PsiLanguageInjectionHost host;
        JSLiteralExpression parent;
        if (element == null) {
            return null;
        }
        if (!(element instanceof JSLiteralExpression) && (parent = (JSLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSLiteralExpression.class)) != null && StringUtil.isSingleQuoteStringLiteral(element)) {
            element = parent;
        }
        return super.findMatchingElement((PsiElement)((host = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectionHost(element)) != null ? host : element));
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/string/JSSingleToDoubleQuotedStringIntention", "processIntention"));
        }
        throw new IncorrectOperationException("Method should not be called");
    }

    public static class SingleToDoubleQuotedStringPredicate
    implements JSElementPredicate {
        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/string/JSSingleToDoubleQuotedStringIntention$SingleToDoubleQuotedStringPredicate", "satisfiedBy"));
            }
            return (element instanceof JSLiteralExpression || element.getNode().getElementType() == JSTokenTypes.STRING_LITERAL) && StringUtil.isSingleQuoteStringLiteral(element);
        }
    }
}

