/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.dataSource;

import com.intellij.database.dataSource.DataSource;
import com.intellij.database.dataSource.DataSourceProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.ServerInstance;
import com.intellij.javaee.oss.server.JavaeeServerExtension;
import com.intellij.javaee.oss.server.JavaeeServerInstance;
import com.intellij.javaee.weblogic.agent.WebLogicAgentExtension;
import com.intellij.javaee.weblogic.agent.dataSource.WeblogicDataSourceDescriptor;
import com.intellij.javaee.weblogic.runDebug.configuration.WeblogicModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;

public class WeblogicDataSourceProviderImpl
implements DataSourceProvider {
    private static final Logger LOG = Logger.getInstance(WeblogicDataSourceProviderImpl.class);

    public DataSource createNewDataInstance(Project project, String name) {
        return null;
    }

    public List<DataSource> loadDataSourcesFromServer(ServerInstance serverInstance) {
        JavaeeServerInstance javaeeServerInstance;
        WeblogicModel weblogicModel;
        ArrayList<DataSource> result = new ArrayList<DataSource>();
        if (serverInstance != null && (weblogicModel = (WeblogicModel)(javaeeServerInstance = (JavaeeServerInstance)serverInstance).getCommonModel().getServerModel()).isDatasourcesImportSupported()) {
            JavaeeServerExtension serverExtension = javaeeServerInstance.getExtension();
            LOG.assertTrue(serverExtension != null);
            WebLogicAgentExtension agentExtension = (WebLogicAgentExtension)serverExtension.getAgentExtension();
            for (String dataSourceName : agentExtension.getConfiguredDataSourceNames()) {
                WeblogicDataSourceDescriptor descriptor = agentExtension.getDatasourceDescriptor(dataSourceName);
                if (descriptor == null) continue;
                result.add((DataSource)new LocalDataSource(descriptor.getName(), descriptor.getDriverClassname(), descriptor.getUrl(), descriptor.getUsername(), descriptor.getPassword()));
            }
        }
        return result;
    }
}

