/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.ejbc;

import com.intellij.javaee.weblogic.ejbc.AbstractOutputParser;
import com.intellij.javaee.weblogic.ejbc.EjbcError;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;

class AppcOutputParser
extends AbstractOutputParser {
    @NonNls
    private static final String MESSAGE_PATTERN_TEXT = "\\[.*\\]Errors encountered while compiling module '.*':\n\r\n(.*)\n\r\n";
    @NonNls
    private static final String NOTE_PATTERN_TEXT = "Note:.*";
    private static final Pattern MESSAGE_PATTERN = Pattern.compile("\\[.*\\]Errors encountered while compiling module '.*':\n\r\n(.*)\n\r\n", 32);
    private static final Pattern NOTE_PATTERN = Pattern.compile("Note:.*", 32);

    AppcOutputParser() {
    }

    @Override
    public synchronized void parseAvailableOutput() {
        String text = this.myOutput.substring(this.myCurrentPosition);
        Matcher matcher = MESSAGE_PATTERN.matcher(text);
        if (matcher.matches()) {
            this.myCurrentPosition += text.length();
            String message = matcher.group(1);
            this.addMessage(new EjbcError(message, CompilerMessageCategory.ERROR));
        }
        if (NOTE_PATTERN.matcher(text).matches()) {
            this.myCurrentPosition += text.length();
            this.addMessage(new EjbcError(text, CompilerMessageCategory.WARNING));
        }
    }
}

