/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.runDebug.deployment;

import com.intellij.javaee.deployment.DeploymentMethod;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.oss.server.JavaeeDeploymentProvider;
import com.intellij.javaee.weblogic.WeblogicBundle;
import com.intellij.javaee.weblogic.runDebug.deployment.WebLogicDeploymentMethod;
import java.io.File;

public class WeblogicDeploymentProvider
extends JavaeeDeploymentProvider {
    public static final WebLogicDeploymentMethod DEPLOYER = new WebLogicDeploymentMethod(WeblogicBundle.message("deployment.method.name.weblogic.deployer", new Object[0]), true, true){

        @Override
        public String createDeploymentName(DeploymentModel deployment, File source) {
            return JavaeeDeploymentProvider.getDefaultDeploymentName((DeploymentModel)deployment);
        }
    };
    public static final WebLogicDeploymentMethod AUTODEPLOY = new WebLogicDeploymentMethod(WeblogicBundle.message("deployment.method.name.auto.deploy", new Object[0]), true, false){

        @Override
        public String createDeploymentName(DeploymentModel deployment, File source) {
            StringBuilder result = new StringBuilder();
            result.append("_appsdir_");
            result.append(source.getName());
            if (!deployment.getDeploymentSource().isArchive()) {
                result.append("_dir");
            } else {
                int index = result.lastIndexOf(".");
                if (index >= 0) {
                    result.setCharAt(index, '_');
                }
            }
            return result.toString();
        }
    };
    private static final DeploymentMethod[] ourDeploymentMethods = new DeploymentMethod[]{DEPLOYER, AUTODEPLOY};

    public WeblogicDeploymentProvider(boolean supportArchivesOnly) {
        super(supportArchivesOnly);
    }

    public String getHelpId() {
        return "webLogic.deployment";
    }

    public boolean isNeedUndeployOnDisconnect() {
        return true;
    }

    public DeploymentMethod[] getAvailableMethods() {
        return ourDeploymentMethods;
    }

    public boolean isDeployOrderMatter() {
        return true;
    }
}

