/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.css.util;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lang.css.CssLanguageProperties;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssMedia;
import com.intellij.psi.css.CssNamedElement;
import com.intellij.psi.css.CssOperation;
import com.intellij.psi.css.CssParenthesisedExpression;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.CssValueOwner;
import com.intellij.psi.css.descriptor.CssMediaType;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssPsiUtil {
    @NonNls
    private static final String EMPTY_STRING = "";

    private CssPsiUtil() {
    }

    @Nullable
    public static CssDeclaration findDeclaration(@NotNull CssBlock cssBlock, @NotNull String propertyName, boolean searchInShorthand) {
        if (cssBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cssBlock", "com/intellij/css/util/CssPsiUtil", "findDeclaration"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/css/util/CssPsiUtil", "findDeclaration"));
        }
        for (CssDeclaration declaration : cssBlock.getDeclarations()) {
            List<String> propertyNames;
            if (propertyName.equalsIgnoreCase(declaration.getPropertyName())) {
                return declaration;
            }
            if (!searchInShorthand || !declaration.isShorthandProperty() || !(propertyNames = Arrays.asList(declaration.expandShorthandProperty())).contains(propertyName)) continue;
            return declaration;
        }
        return null;
    }

    public static PsiElement findToken(@NotNull CssElement cssElement, @NotNull TokenSet tokenSet) {
        if (cssElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cssElement", "com/intellij/css/util/CssPsiUtil", "findToken"));
        }
        if (tokenSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenSet", "com/intellij/css/util/CssPsiUtil", "findToken"));
        }
        ASTNode childByType = cssElement.getNode().findChildByType(tokenSet);
        if (childByType != null) {
            return childByType.getPsi();
        }
        for (PsiElement element : cssElement.getChildren()) {
            XmlToken token;
            if (!(element instanceof XmlToken ? tokenSet.contains((token = (XmlToken)element).getTokenType()) : element instanceof CssElement && (token = CssPsiUtil.findToken((CssElement)element, tokenSet)) != null)) continue;
            return token;
        }
        return null;
    }

    @NotNull
    public static Set<String> getRulesetTags(@NotNull CssRuleset ruleset) {
        if (ruleset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ruleset", "com/intellij/css/util/CssPsiUtil", "getRulesetTags"));
        }
        Set result = ContainerUtil.set((Object[])new String[0]);
        for (CssSelector selector : ruleset.getSelectors()) {
            CssSimpleSelector lastElement = (CssSimpleSelector)ArrayUtil.getLastElement((Object[])selector.getSimpleSelectors());
            if (lastElement == null) continue;
            result.add(lastElement.getElementName());
        }
        Set set = result;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/css/util/CssPsiUtil", "getRulesetTags"));
        }
        return set;
    }

    public static boolean isInFunction(@Nullable PsiElement element) {
        CssValueOwner termListOwner = (CssValueOwner)PsiTreeUtil.getParentOfType((PsiElement)element, CssValueOwner.class);
        return termListOwner instanceof CssFunction;
    }

    public static TextRange getValueTextRange(@NotNull CssValueOwner valueOwner) {
        if (valueOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueOwner", "com/intellij/css/util/CssPsiUtil", "getValueTextRange"));
        }
        CssTermList termList = valueOwner.getValue();
        return termList != null ? termList.getTextRange() : TextRange.EMPTY_RANGE;
    }

    @Nullable
    public static Language getStylesheetLanguage(@Nullable PsiElement context) {
        if (context == null) {
            return null;
        }
        try {
            Language contextLanguage = context.getLanguage();
            if (!contextLanguage.isKindOf((Language)CSSLanguage.INSTANCE)) {
                return null;
            }
            PsiFile file = context.getContainingFile();
            if (file instanceof CssFile) {
                return file.getLanguage();
            }
            PsiElement stylesheet = PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssStylesheet.class});
            return stylesheet != null ? stylesheet.getLanguage() : contextLanguage;
        }
        catch (PsiInvalidElementAccessException e) {
            return null;
        }
    }

    @NotNull
    public static String getDeclarationsTerminatorFromContext(@Nullable PsiElement context) {
        CssLanguageProperties languageProperties = CssPsiUtil.getLanguagePropertiesFromContext(context);
        String string = languageProperties != null ? languageProperties.getDeclarationsTerminator() : ";";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/css/util/CssPsiUtil", "getDeclarationsTerminatorFromContext"));
        }
        return string;
    }

    public static boolean isIndentBasedCssLanguage(@Nullable PsiElement context) {
        CssLanguageProperties languageProperties = CssPsiUtil.getLanguagePropertiesFromContext(context);
        return languageProperties != null && languageProperties.isIndentBased();
    }

    @Nullable
    private static CssLanguageProperties getLanguagePropertiesFromContext(@Nullable PsiElement context) {
        Language stylesheetLanguage = CssPsiUtil.getStylesheetLanguage(context);
        if (stylesheetLanguage instanceof CssLanguageProperties) {
            return (CssLanguageProperties)stylesheetLanguage;
        }
        return null;
    }

    public static PsiElement getFirstDeepestTerm(@Nullable PsiElement element) {
        if (element instanceof CssTermList) {
            PsiElement term = PsiTreeUtil.getNonStrictParentOfType((PsiElement)PsiTreeUtil.getDeepestFirst((PsiElement)element), (Class[])new Class[]{CssTerm.class});
            if (term != null) {
                PsiElement parent = term.getParent();
                while (parent instanceof CssOperation) {
                    term = parent;
                    parent = term.getParent();
                }
            }
            return term;
        }
        if (element instanceof CssParenthesisedExpression) {
            return element.getFirstChild();
        }
        return element;
    }

    public static PsiElement getLastDeepestTerm(@Nullable PsiElement element) {
        if (element instanceof CssTermList) {
            PsiElement term = PsiTreeUtil.getNonStrictParentOfType((PsiElement)PsiTreeUtil.getDeepestLast((PsiElement)element), (Class[])new Class[]{CssTerm.class});
            if (term != null) {
                PsiElement parent = term.getParent();
                while (parent instanceof CssOperation) {
                    term = parent;
                    parent = term.getParent();
                }
            }
            return term;
        }
        return element;
    }

    @NotNull
    public static String getTokenText(@Nullable PsiElement element) {
        String string = element == null ? EMPTY_STRING : element.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/css/util/CssPsiUtil", "getTokenText"));
        }
        return string;
    }

    public static PsiElement replaceToken(@NotNull PsiElement token, String value) throws IncorrectOperationException {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/css/util/CssPsiUtil", "replaceToken"));
        }
        return ElementManipulators.getManipulator((PsiElement)token).handleContentChange(token, new TextRange(0, token.getTextLength()), value);
    }

    public static int hashCodeForElement(@Nullable PsiElement element) {
        if (element == null || element instanceof PsiWhiteSpace || element instanceof PsiComment) {
            return 0;
        }
        return new CssHashingVisitor().calculate(element);
    }

    @NotNull
    public static Set<CssMediaType> getAllowedMediaTypesInContext(@Nullable PsiElement context) {
        CssMedia media = (CssMedia)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssMedia.class});
        if (media != null) {
            Set<CssMediaType> set = media.getMediaTypes();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/css/util/CssPsiUtil", "getAllowedMediaTypesInContext"));
            }
            return set;
        }
        HtmlTag htmlTag = (HtmlTag)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{HtmlTag.class});
        if (htmlTag != null && "style".equals(htmlTag.getName())) {
            CssMedia customMedia;
            String attributeValue = htmlTag.getAttributeValue("media");
            if (StringUtil.isNotEmpty((String)attributeValue) && (customMedia = CssElementFactory.getInstance(context.getProject()).createMedia(attributeValue, (FileType)CssFileType.INSTANCE)) != null) {
                Set<CssMediaType> set = customMedia.getMediaTypes();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/css/util/CssPsiUtil", "getAllowedMediaTypesInContext"));
                }
                return set;
            }
            HashSet hashSet = ContainerUtil.newHashSet((Object[])new CssMediaType[]{CssMediaType.ALL});
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/css/util/CssPsiUtil", "getAllowedMediaTypesInContext"));
            }
            return hashSet;
        }
        HashSet hashSet = ContainerUtil.newHashSet((Iterable)ContainerUtil.newHashSet((Object[])new CssMediaType[]{CssMediaType.SCREEN}));
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/css/util/CssPsiUtil", "getAllowedMediaTypesInContext"));
        }
        return hashSet;
    }

    private static class CssHashingVisitor
    extends CssElementVisitor {
        private int myResult = 0;

        private CssHashingVisitor() {
        }

        public int calculate(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/css/util/CssPsiUtil$CssHashingVisitor", "calculate"));
            }
            this.myResult = 0;
            element.accept((PsiElementVisitor)this);
            return this.myResult;
        }

        @Override
        public void visitCssUri(CssUri uri) {
            this.myResult += 31 * uri.getNode().getElementType().hashCode() + 31 * uri.getValue().hashCode();
        }

        @Override
        public void visitCssString(CssString _string) {
            this.myResult += 31 * _string.getNode().getElementType().hashCode() + 31 * _string.getText().hashCode();
        }

        @Override
        public void visitCssTerm(CssTerm _term) {
            this.myResult += 31 * _term.getTermType().hashCode();
            super.visitCssElement(_term);
        }

        @Override
        public void visitCssDeclaration(CssDeclaration declaration) {
            this.myResult += declaration.equalityHashCode();
        }

        @Override
        public void visitCssElement(CssElement element) {
            if (element instanceof CssValueOwner) {
                String name;
                CssTermList value = ((CssValueOwner)element).getValue();
                if (value != null) {
                    value.accept((PsiElementVisitor)this);
                }
                if (element instanceof CssNamedElement && (name = ((CssNamedElement)element).getName()) != null) {
                    this.myResult += 31 * name.toLowerCase(Locale.US).hashCode();
                }
                return;
            }
            super.visitCssElement(element);
        }

        public void visitElement(PsiElement element) {
            if (!(element instanceof PsiComment) && !(element instanceof PsiWhiteSpace)) {
                this.myResult += 31 * element.getNode().getElementType().hashCode();
                if (element.getChildren().length == 0) {
                    this.myResult += 31 * element.getText().toLowerCase(Locale.US).hashCode();
                } else {
                    element.acceptChildren((PsiElementVisitor)this);
                }
            }
            super.visitElement(element);
        }
    }
}

