/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.psi.css.CssSelectorSuffix;
import org.jetbrains.annotations.NotNull;

public interface CssAttribute
extends CssSelectorSuffix {
    public boolean isMatch(@NotNull String var1, @NotNull String var2);

    @NotNull
    public OperatorType getOperatorType();

    @NotNull
    public String getValue();

    public static enum OperatorType {
        NONE(""),
        EQUALS("="),
        CONTAINS_WORD("~="),
        STARTS_WITH_BEFORE_DASH("|="),
        STARTS_WITH("^="),
        ENDS_WITH("$="),
        CONTAINS("*="),
        JQUERY_NOT_EQUALS("!=");

        private final String myPresentation;

        private OperatorType(String presentation) {
            this.myPresentation = presentation;
        }

        public String getPresentation() {
            return this.myPresentation;
        }

        public static OperatorType fromString(@NotNull String presentation) {
            if (presentation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/psi/css/CssAttribute$OperatorType", "fromString"));
            }
            for (OperatorType type : OperatorType.values()) {
                if (!presentation.equals(type.myPresentation)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown operator type: " + presentation);
        }
    }
}

