/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.descriptor;

import com.intellij.psi.PsiElement;
import com.intellij.psi.css.descriptor.BrowserVersion;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssCompositeElementDescriptor
implements CssElementDescriptor {
    @NotNull
    private final Collection<? extends CssElementDescriptor> myDescriptors;
    @NotNull
    private final CssElementDescriptor myDescriptorFromLatestSpec;

    public static CssElementDescriptor create(@NotNull Collection<CssElementDescriptor> descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/psi/css/descriptor/CssCompositeElementDescriptor", "create"));
        }
        if (descriptors.isEmpty()) {
            return null;
        }
        if (descriptors.size() == 1) {
            return (CssElementDescriptor)ContainerUtil.getFirstItem(descriptors);
        }
        return new CssCompositeElementDescriptor(descriptors);
    }

    public CssCompositeElementDescriptor(@NotNull Collection<? extends CssElementDescriptor> descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/psi/css/descriptor/CssCompositeElementDescriptor", "<init>"));
        }
        assert (descriptors.size() > 0);
        this.myDescriptors = descriptors;
        CssElementDescriptor descriptorFromLatestSpec = CssDescriptorsUtil.getDescriptorFromLatestSpec(descriptors);
        assert (descriptorFromLatestSpec != null);
        this.myDescriptorFromLatestSpec = descriptorFromLatestSpec;
    }

    @Override
    @NotNull
    public CssElementDescriptor.CssVersion getCssVersion() {
        CssElementDescriptor.CssVersion result = CssElementDescriptor.CssVersion.UNKNOWN;
        for (CssElementDescriptor cssElementDescriptor : this.myDescriptors) {
            CssElementDescriptor.CssVersion version = cssElementDescriptor.getCssVersion();
            if (result != CssElementDescriptor.CssVersion.UNKNOWN && result.value() <= version.value()) continue;
            result = version;
        }
        CssElementDescriptor.CssVersion cssVersion = result;
        if (cssVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/CssCompositeElementDescriptor", "getCssVersion"));
        }
        return cssVersion;
    }

    @Override
    @NotNull
    public BrowserVersion[] getBrowsers() {
        TreeSet browsers = ContainerUtilRt.newTreeSet(BrowserVersion.COMPARATOR);
        for (CssElementDescriptor cssElementDescriptor : this.myDescriptors) {
            BrowserVersion[] descriptorBrowsers = cssElementDescriptor.getBrowsers();
            if (descriptorBrowsers.length == 0) {
                if (BrowserVersion.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/CssCompositeElementDescriptor", "getBrowsers"));
                }
                return BrowserVersion.EMPTY_ARRAY;
            }
            Collections.addAll(browsers, descriptorBrowsers);
        }
        BrowserVersion[] browserVersionArray = browsers.toArray(new BrowserVersion[browsers.size()]);
        if (browserVersionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/CssCompositeElementDescriptor", "getBrowsers"));
        }
        return browserVersionArray;
    }

    @Override
    public boolean isAllowedInContextType(@NotNull CssContextType contextType) {
        if (contextType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextType", "com/intellij/psi/css/descriptor/CssCompositeElementDescriptor", "isAllowedInContextType"));
        }
        for (CssElementDescriptor cssElementDescriptor : this.myDescriptors) {
            if (!cssElementDescriptor.isAllowedInContextType(contextType)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String getId() {
        String string = this.myDescriptorFromLatestSpec.getId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/CssCompositeElementDescriptor", "getId"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.myDescriptorFromLatestSpec.getPresentableName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/CssCompositeElementDescriptor", "getPresentableName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = this.myDescriptorFromLatestSpec.getPresentableName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/CssCompositeElementDescriptor", "getDescription"));
        }
        return string;
    }

    @Override
    @Nullable
    public String getDocumentationString(@Nullable PsiElement context) {
        return this.myDescriptorFromLatestSpec.getDocumentationString(context);
    }

    @Override
    @NotNull
    public String getElementTypeName() {
        String string = this.myDescriptorFromLatestSpec.getElementTypeName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/CssCompositeElementDescriptor", "getElementTypeName"));
        }
        return string;
    }

    @Override
    @Nullable
    public String getSpecificationUrl() {
        return this.myDescriptorFromLatestSpec.getSpecificationUrl();
    }

    @Override
    @NotNull
    public CssContextType[] getAllowedContextTypes() {
        TreeSet contextTypes = ContainerUtilRt.newTreeSet(CssContextType.COMPARATOR);
        for (CssElementDescriptor cssElementDescriptor : this.myDescriptors) {
            Collections.addAll(contextTypes, cssElementDescriptor.getAllowedContextTypes());
        }
        CssContextType[] cssContextTypeArray = contextTypes.toArray(new CssContextType[contextTypes.size()]);
        if (cssContextTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/CssCompositeElementDescriptor", "getAllowedContextTypes"));
        }
        return cssContextTypeArray;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return this.myDescriptorFromLatestSpec.getIcon();
    }

    @NotNull
    public CssElementDescriptor getDescriptorFromLatestSpec() {
        CssElementDescriptor cssElementDescriptor = this.myDescriptorFromLatestSpec;
        if (cssElementDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/CssCompositeElementDescriptor", "getDescriptorFromLatestSpec"));
        }
        return cssElementDescriptor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CssCompositeElementDescriptor)) {
            return false;
        }
        CssCompositeElementDescriptor that = (CssCompositeElementDescriptor)o;
        return this.myDescriptors.equals(that.myDescriptors);
    }

    public int hashCode() {
        return this.myDescriptors.hashCode();
    }
}

