/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.descriptor.value;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssValueMatchData {
    private final boolean myMatched;
    private final CssValueDescriptor myDescriptor;
    private List<PsiElement> myMatchedTerms;
    private final List<CssValueMatchData> myChildren;

    public CssValueMatchData(@NotNull CssValueDescriptor descriptor, boolean matched, @NotNull List<CssValueMatchData> children) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/descriptor/value/CssValueMatchData", "<init>"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/psi/css/descriptor/value/CssValueMatchData", "<init>"));
        }
        this.myMatchedTerms = ContainerUtil.newArrayList();
        this.myDescriptor = descriptor;
        this.myMatched = matched;
        this.myChildren = ContainerUtil.filter(children, (Condition)Condition.NOT_NULL);
    }

    public CssValueMatchData(@NotNull CssValueDescriptor descriptor, boolean matched) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/descriptor/value/CssValueMatchData", "<init>"));
        }
        this(descriptor, matched, Collections.emptyList());
    }

    public static CssValueMatchData fail(@NotNull CssValueDescriptor descriptor, @NotNull List<CssValueMatchData> childrenMatchData) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/descriptor/value/CssValueMatchData", "fail"));
        }
        if (childrenMatchData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childrenMatchData", "com/intellij/psi/css/descriptor/value/CssValueMatchData", "fail"));
        }
        return new CssValueMatchData(descriptor, false, childrenMatchData);
    }

    public static CssValueMatchData fail(@NotNull CssValueDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/descriptor/value/CssValueMatchData", "fail"));
        }
        return CssValueMatchData.fail(descriptor, Collections.<CssValueMatchData>emptyList());
    }

    public static CssValueMatchData success(@NotNull CssValueDescriptor descriptor, @NotNull List<CssValueMatchData> childrenMatchData) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/descriptor/value/CssValueMatchData", "success"));
        }
        if (childrenMatchData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childrenMatchData", "com/intellij/psi/css/descriptor/value/CssValueMatchData", "success"));
        }
        return new CssValueMatchData(descriptor, true, childrenMatchData);
    }

    public static CssValueMatchData success(@NotNull CssValueDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/descriptor/value/CssValueMatchData", "success"));
        }
        return CssValueMatchData.success(descriptor, Collections.<CssValueMatchData>emptyList());
    }

    public void addMatchedElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/descriptor/value/CssValueMatchData", "addMatchedElement"));
        }
        this.myMatchedTerms.add(element);
    }

    @Nullable
    public PsiElement getFirstMatchedElement() {
        PsiElement item = (PsiElement)ContainerUtil.getFirstItem(this.myMatchedTerms);
        if (item == null) {
            for (CssValueMatchData child : this.myChildren) {
                PsiElement childCandidate = child.getFirstMatchedElement();
                if (childCandidate == null || item != null && childCandidate.getTextRange().getEndOffset() <= item.getTextRange().getEndOffset()) continue;
                item = childCandidate;
            }
        }
        return item;
    }

    @Nullable
    public PsiElement getLastMatchedElement() {
        PsiElement item = (PsiElement)ContainerUtil.getLastItem(this.myMatchedTerms);
        if (item == null) {
            for (CssValueMatchData child : this.myChildren) {
                PsiElement childCandidate = child.getLastMatchedElement();
                if (childCandidate == null || item != null && childCandidate.getTextRange().getEndOffset() <= item.getTextRange().getEndOffset()) continue;
                item = childCandidate;
            }
        }
        return item;
    }

    @NotNull
    public CssValueDescriptor getDescriptor() {
        CssValueDescriptor cssValueDescriptor = this.myDescriptor;
        if (cssValueDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/value/CssValueMatchData", "getDescriptor"));
        }
        return cssValueDescriptor;
    }

    @Nullable
    public CssValueDescriptor findDeepestDescriptorForElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/descriptor/value/CssValueMatchData", "findDeepestDescriptorForElement"));
        }
        for (CssValueMatchData child : this.myChildren) {
            CssValueDescriptor childDescriptor = child.findDeepestDescriptorForElement(element);
            if (childDescriptor == null) continue;
            return childDescriptor;
        }
        if (this.myMatchedTerms.contains(element)) {
            return this.myDescriptor;
        }
        return null;
    }

    @Nullable
    public CssValueMatchData findDeepestNotMatchedData() {
        if (this.myMatched) {
            return null;
        }
        CssValueMatchData result = this;
        for (CssValueMatchData child : this.myChildren) {
            CssValueMatchData notMatchedChild = child.findDeepestNotMatchedData();
            if (notMatchedChild == null) continue;
            return notMatchedChild;
        }
        return result;
    }

    public boolean isMatched() {
        return this.myMatched;
    }
}

