/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.console;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionHelper;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.play.console.PlayConfigurable;
import com.intellij.play.console.PlayConfiguration;
import com.intellij.play.console.PlayConsoleRunner;
import com.intellij.play.utils.PlayBundle;
import com.intellij.play.utils.PlayUtils;
import icons.PlayIcons;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunPlayConsoleAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent event) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(event.getDataContext());
        assert (project != null);
        try {
            UsageTrigger.trigger((String)"Play!.RunPlayConsoleAction");
            Pair<String, String> paths = RunPlayConsoleAction.detectOrChooseHomePath(project);
            if (paths != null) {
                String home = (String)paths.first;
                String path = (String)paths.second;
                if (!StringUtil.isEmptyOrSpaces((String)home) && !StringUtil.isEmptyOrSpaces((String)path)) {
                    PlayConsoleRunner runner = new PlayConsoleRunner(project, home, path);
                    runner.showConsoleInRunToolwindow();
                }
            }
        }
        catch (ExecutionException ex) {
            ExecutionHelper.showErrors((Project)project, Arrays.asList(new Exception[]{ex}), (String)PlayBundle.message("playframework", new Object[0]), null);
        }
    }

    @Nullable
    private static String getWorkingDir(@NotNull Project project) throws ExecutionException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/play/console/RunPlayConsoleAction", "getWorkingDir"));
        }
        return project.getBaseDir().getPath();
    }

    @Nullable
    private static Module getWorkingModule(@Nullable Module module, Project project) throws ExecutionException {
        if (module == null) {
            Module[] modules = ModuleManager.getInstance((Project)project).getModules();
            if (modules.length > 1) {
                List chosenModules = new ChooseModulesDialog(project, Arrays.asList(modules), "Choose Module", PlayBundle.message("choose.playframework.module", new Object[0])).showAndGetResult();
                if (chosenModules.isEmpty()) {
                    return null;
                }
                modules = chosenModules.toArray(new Module[chosenModules.size()]);
            }
            if (modules.length == 0) {
                throw new ExecutionException("Project has no modules");
            }
            module = modules[0];
        }
        return module;
    }

    @Nullable
    private static Pair<String, String> detectOrChooseHomePath(Project project) throws ExecutionException {
        PlayConfiguration playConfiguration = PlayConfiguration.getConfiguration();
        PlayConfigurable playConfigurable = new PlayConfigurable(project);
        RunPlayConsoleAction.initConfiguration(project, playConfiguration);
        Boolean showOnRun = playConfiguration.myShowOnRun;
        if (showOnRun == null || showOnRun.booleanValue()) {
            if (!ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)playConfigurable)) {
                return null;
            }
            if (RunPlayConsoleAction.checkPaths(project)) {
                return Pair.create((Object)playConfiguration.myPlayHome, (Object)playConfiguration.myPath);
            }
        }
        while (StringUtil.isEmptyOrSpaces((String)playConfiguration.myPlayHome) || StringUtil.isEmptyOrSpaces((String)playConfiguration.myPath) || RunPlayConsoleAction.checkHome(playConfiguration.myPlayHome) != null || RunPlayConsoleAction.checkDir(playConfiguration.myPath) != null) {
            if (!ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)playConfigurable)) {
                return null;
            }
            if (!RunPlayConsoleAction.checkPaths(project)) continue;
            break;
        }
        return Pair.create((Object)playConfiguration.myPlayHome, (Object)playConfiguration.myPath);
    }

    private static void initConfiguration(Project project, PlayConfiguration playConfiguration) {
        if (playConfiguration.myShowOnRun == null) {
            playConfiguration.myShowOnRun = true;
        }
        if (playConfiguration.myPlayHome == null) {
            playConfiguration.myPlayHome = System.getenv("PLAY_HOME");
        }
        if (playConfiguration.myPath == null) {
            playConfiguration.myPath = project.getBaseDir().getPath();
        }
    }

    private static boolean checkPaths(Project project) {
        PlayConfiguration playConfiguration = PlayConfiguration.getConfiguration();
        String playHome = playConfiguration.myPlayHome;
        String path = playConfiguration.myPath;
        if (StringUtil.isEmptyOrSpaces((String)playHome)) {
            Messages.showErrorDialog((Project)project, (String)PlayBundle.message("choose.valid.home.message", new Object[0]), (String)PlayBundle.message("choose.home.title", new Object[0]));
            return false;
        }
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            Messages.showErrorDialog((Project)project, (String)PlayBundle.message("choose.valid.working.dir", new Object[0]), (String)PlayBundle.message("choose.workdir.title", new Object[0]));
            return false;
        }
        String errorMessage = RunPlayConsoleAction.checkHome(playHome);
        String pathMessage = RunPlayConsoleAction.checkDir(path);
        if (errorMessage == null && pathMessage == null) {
            return true;
        }
        if (errorMessage != null) {
            Messages.showErrorDialog((Project)project, (String)errorMessage, (String)PlayBundle.message("invalid.home.path", new Object[0]));
        } else {
            Messages.showErrorDialog((Project)project, (String)pathMessage, (String)PlayBundle.message("invalid.workdir.path", new Object[0]));
        }
        return false;
    }

    @Nullable
    private static String checkHome(String homePath) {
        String message = RunPlayConsoleAction.checkDir(homePath);
        if (message != null) {
            return message;
        }
        String exePath = PlayConsoleRunner.getExePath(homePath);
        if (!new File(exePath).exists()) {
            return exePath + " does not exist";
        }
        return null;
    }

    @Nullable
    private static String checkDir(String homePath) {
        File file = new File(homePath);
        if (!file.exists()) {
            return "Directory " + homePath + " does not exist";
        }
        if (!file.isDirectory()) {
            return homePath + " is not a directory";
        }
        return null;
    }

    public void update(AnActionEvent e) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        e.getPresentation().setVisible(project != null && PlayUtils.isPlayInstalled(project));
        e.getPresentation().setIcon(PlayIcons.Play);
    }
}

