/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSPropertyNameReference;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.jetbrains.javascript.debugger.ExpressionInfoFactory;
import com.jetbrains.javascript.debugger.NameMapper;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.ValueModifierUtil;

public class JSDebuggerSupportUtils {
    @Nullable
    public static ExpressionInfo getExpressionAtOffset(@NotNull Project project, @NotNull Document document, int offset) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/JSDebuggerSupportUtils", "getExpressionAtOffset"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/javascript/JSDebuggerSupportUtils", "getExpressionAtOffset"));
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        return file == null ? null : JSDebuggerSupportUtils.getExpressionAtOffset(document, file, offset);
    }

    @Nullable
    public static ExpressionInfo getExpressionAtOffset(@NotNull Document document, @NotNull PsiFile file, int offset) {
        PsiElement element;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/javascript/JSDebuggerSupportUtils", "getExpressionAtOffset"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/JSDebuggerSupportUtils", "getExpressionAtOffset"));
        }
        int injectionOffsetCorrection = 0;
        PsiReference ref = file.findReferenceAt(offset);
        if (ref == null) {
            PsiElement at = file.findElementAt(offset);
            TextRange rangeForNamedElement = JSDebuggerSupportUtils.getRangeForNamedElement(at, 0);
            if (rangeForNamedElement != null) {
                return new ExpressionInfo(rangeForNamedElement);
            }
            PsiLanguageInjectionHost psiLanguageInjectionHost = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)at, PsiLanguageInjectionHost.class);
            if (psiLanguageInjectionHost != null) {
                int valueOffset = ElementManipulators.getValueTextRange((PsiElement)psiLanguageInjectionHost).getStartOffset();
                MyInjectedPsiVisitor visitor = new MyInjectedPsiVisitor(offset);
                InjectedLanguageUtil.enumerate((PsiElement)psiLanguageInjectionHost, (PsiLanguageInjectionHost.InjectedPsiVisitor)visitor);
                ref = visitor.result;
                if (ref == null) {
                    rangeForNamedElement = JSDebuggerSupportUtils.getRangeForNamedElement(visitor.elementInInjected, visitor.injectedOffset - valueOffset);
                    if (rangeForNamedElement != null) {
                        return new ExpressionInfo(rangeForNamedElement);
                    }
                } else {
                    injectionOffsetCorrection = visitor.injectedOffset - valueOffset;
                }
            }
            if (ref == null) {
                return null;
            }
        }
        if ((element = ref.getElement()) instanceof JSProperty) {
            return JSDebuggerSupportUtils.getEvaluationInfoForPropertyReference((JSProperty)element, document, null, injectionOffsetCorrection);
        }
        return new ExpressionInfo(element.getTextRange().shiftRight(injectionOffsetCorrection));
    }

    @Nullable
    private static ExpressionInfo getEvaluationInfoForPropertyReference(@NotNull JSProperty property, @NotNull Document document, @Nullable ExpressionInfoFactory expressionInfoFactory, int injectionOffsetCorrection) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/javascript/JSDebuggerSupportUtils", "getEvaluationInfoForPropertyReference"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/javascript/JSDebuggerSupportUtils", "getEvaluationInfoForPropertyReference"));
        }
        PsiElement name = property.getNameIdentifier();
        if (name == null) {
            return null;
        }
        ArrayList<String> expression = new ArrayList<String>();
        ArrayList<String> displayName = new ArrayList<String>();
        NameMapper nameMapper = null;
        boolean nameMapperComputed = expressionInfoFactory == null;
        JSProperty parent = property;
        do {
            VirtualFile file;
            if (parent instanceof JSProperty || parent instanceof JSVariable) {
                PsiElement identifier = ((JSNamedElement)parent).getNameIdentifier();
                if (identifier == null) {
                    return null;
                }
                if (!nameMapperComputed) {
                    nameMapperComputed = true;
                    file = parent.getContainingFile().getVirtualFile();
                    if (file != null) {
                        nameMapper = expressionInfoFactory.createNameMapper(file, document);
                    }
                }
                JSDebuggerSupportUtils.appendName(expression, identifier, nameMapper);
                displayName.add(identifier.getText());
                if (!(parent instanceof JSVariable)) continue;
                return JSDebuggerSupportUtils.createInfo(name, expression, displayName, injectionOffsetCorrection);
            }
            if (!(parent instanceof JSAssignmentExpression)) continue;
            JSExpression operand = ((JSAssignmentExpression)parent).getLOperand();
            if (operand == null) {
                return null;
            }
            if (!nameMapperComputed && (file = parent.getContainingFile().getVirtualFile()) != null) {
                nameMapper = expressionInfoFactory.createNameMapper(file, document);
            }
            JSDebuggerSupportUtils.appendName(expression, (PsiElement)operand, nameMapper);
            displayName.add(operand.getText());
            return JSDebuggerSupportUtils.createInfo(name, expression, displayName, injectionOffsetCorrection);
        } while (!JSDebuggerSupportUtils.isStopElement((PsiElement)(parent = parent.getParent())));
        return null;
    }

    @NotNull
    private static ExpressionInfo createInfo(@NotNull PsiElement name, @NotNull List<String> expression, @NotNull List<String> displayName, int injectionOffsetCorrection) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/JSDebuggerSupportUtils", "createInfo"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/javascript/JSDebuggerSupportUtils", "createInfo"));
        }
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/javascript/JSDebuggerSupportUtils", "createInfo"));
        }
        String expressionText = ValueModifierUtil.INSTANCE.propertyNamesToString(expression, true);
        String displayText = expression.equals(displayName) ? expressionText : ValueModifierUtil.INSTANCE.propertyNamesToString(displayName, true);
        ExpressionInfo expressionInfo = new ExpressionInfo(name.getTextRange().shiftRight(injectionOffsetCorrection), expressionText, displayText);
        if (expressionInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSDebuggerSupportUtils", "createInfo"));
        }
        return expressionInfo;
    }

    @Nullable
    private static TextRange getRangeForNamedElement(@Nullable PsiElement element, int offset) {
        PsiElement identifier;
        PsiElement parent;
        PsiElement psiElement = parent = element == null ? null : element.getParent();
        if (parent instanceof JSNamedElement && (identifier = ((JSNamedElement)parent).getNameIdentifier()) != null) {
            return identifier.getTextRange().shiftRight(offset);
        }
        return null;
    }

    private static void appendName(@NotNull List<String> names, @NotNull PsiElement element, @Nullable NameMapper nameMapper) {
        String rawName;
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/javascript/JSDebuggerSupportUtils", "appendName"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/JSDebuggerSupportUtils", "appendName"));
        }
        if (nameMapper != null && (rawName = nameMapper.map(element)) != null) {
            names.add(rawName);
            return;
        }
        names.add(element.getText());
    }

    @Nullable
    public static PsiElement resolve(@NotNull JSReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/javascript/JSDebuggerSupportUtils", "resolve"));
        }
        ResolveResult[] results = referenceExpression.multiResolve(false);
        return results.length == 0 ? null : results[0].getElement();
    }

    @Nullable
    public static ExpressionInfo getEvaluationInfo(@NotNull PsiElement elementAtOffset, @NotNull Document document, @NotNull ExpressionInfoFactory expressionInfoFactory) {
        PsiElement identifier;
        if (elementAtOffset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementAtOffset", "com/intellij/javascript/JSDebuggerSupportUtils", "getEvaluationInfo"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/javascript/JSDebuggerSupportUtils", "getEvaluationInfo"));
        }
        if (expressionInfoFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionInfoFactory", "com/intellij/javascript/JSDebuggerSupportUtils", "getEvaluationInfo"));
        }
        PsiElement parent = elementAtOffset;
        do {
            if (parent instanceof JSReferenceExpression) {
                PsiElement target = JSDebuggerSupportUtils.resolve((JSReferenceExpression)parent);
                if (target instanceof JSVariable && ((JSVariable)target).isLocal() || target instanceof JSParameter || target instanceof JSProperty) {
                    return expressionInfoFactory.create(parent, document);
                }
                return new ExpressionInfo(parent.getTextRange());
            }
            if (parent instanceof JSPropertyNameReference) {
                return JSDebuggerSupportUtils.getEvaluationInfoForPropertyReference(((JSPropertyNameReference)parent).getElement(), document, expressionInfoFactory, 0);
            }
            if (!(parent instanceof JSProperty)) continue;
            return JSDebuggerSupportUtils.getEvaluationInfoForPropertyReference((JSProperty)parent, document, expressionInfoFactory, 0);
        } while (!JSDebuggerSupportUtils.isStopElement(parent = parent.getParent()));
        parent = elementAtOffset.getParent();
        if (parent instanceof JSNamedElement && (identifier = ((JSNamedElement)parent).getNameIdentifier()) != null) {
            return expressionInfoFactory.create(identifier, document);
        }
        return null;
    }

    private static boolean isStopElement(@Nullable PsiElement element) {
        return element == null || element instanceof JSFunctionExpression || element instanceof JSArgumentList || element instanceof JSBlockStatement;
    }

    private static class MyInjectedPsiVisitor
    implements PsiLanguageInjectionHost.InjectedPsiVisitor {
        private final int offset;
        private PsiReference result;
        private PsiElement elementInInjected;
        private int injectedOffset;

        public MyInjectedPsiVisitor(int offset) {
            this.offset = offset;
        }

        public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
            if (injectedPsi == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/javascript/JSDebuggerSupportUtils$MyInjectedPsiVisitor", "visit"));
            }
            if (places == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "com/intellij/javascript/JSDebuggerSupportUtils$MyInjectedPsiVisitor", "visit"));
            }
            int injectedStart = InjectedLanguageUtil.getInjectedStart(places);
            int offsetInInjected = this.offset - injectedStart;
            this.result = injectedPsi.findReferenceAt(offsetInInjected);
            this.elementInInjected = injectedPsi.findElementAt(offsetInInjected);
            this.injectedOffset = injectedStart;
        }
    }
}

