/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.MutableLookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<JSArgumentList, JSFunctionWithSubstitutor, JSExpression> {
    private static final Set<Class> ourArgumentListAllowedParentClassesSet = new HashSet<Class>(Arrays.asList(JSCallExpression.class));
    private static final Set<? extends Class> ourStopSearch = Collections.singleton(JSFunction.class);

    public boolean couldShowInLookup() {
        return true;
    }

    @NotNull
    public Set<? extends Class> getArgListStopSearchClasses() {
        Set<? extends Class> set = ourStopSearch;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSParameterInfoHandler", "getArgListStopSearchClasses"));
        }
        return set;
    }

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        if (!(item instanceof MutableLookupElement)) {
            return null;
        }
        Object o = item.getObject();
        if (o instanceof JSFunctionItem) {
            ArrayList<JSFunctionWithSubstitutor> lookupItems = new ArrayList<JSFunctionWithSubstitutor>();
            ArrayList<JSFunctionWithSubstitutor> lookupItemsWithoutTypes = new ArrayList<JSFunctionWithSubstitutor>();
            LinkedHashSet<String> availableSignatures = new LinkedHashSet<String>();
            if (o instanceof JSFunction) {
                for (PsiElement el : DefinitionsScopedSearch.search((PsiElement)((JSFunction)o))) {
                    if (!(el instanceof JSFunction)) continue;
                    JSParameterInfoHandler.doAddSignature(lookupItemsWithoutTypes, availableSignatures, (JSFunctionItem)((JSFunction)el), null);
                }
            }
            lookupItems.add(new JSFunctionWithSubstitutor((JSFunctionItem)o, null));
            lookupItems.addAll(lookupItemsWithoutTypes);
            return ArrayUtil.toObjectArray(lookupItems);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private static void doAddSignature(@NotNull List<JSFunctionWithSubstitutor> lookupItems, @NotNull Set<String> availableSignatures, @NotNull JSFunctionItem functionItem, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (lookupItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookupItems", "com/intellij/javascript/JSParameterInfoHandler", "doAddSignature"));
        }
        if (availableSignatures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "availableSignatures", "com/intellij/javascript/JSParameterInfoHandler", "doAddSignature"));
        }
        if (functionItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionItem", "com/intellij/javascript/JSParameterInfoHandler", "doAddSignature"));
        }
        String typedSignature = JSParameterInfoHandler.buildSignature((JSFunctionItem)functionItem, (boolean)false, (int)-1, (JSTypeSubstitutor)typeSubstitutor).text;
        String untypedSignature = JSParameterInfoHandler.buildSignature((JSFunctionItem)functionItem, (boolean)true, (int)-1, (JSTypeSubstitutor)typeSubstitutor).text;
        if (!typedSignature.equals(untypedSignature)) {
            availableSignatures.add(untypedSignature);
        }
        if (!availableSignatures.contains(typedSignature)) {
            lookupItems.add(new JSFunctionWithSubstitutor(functionItem, typeSubstitutor));
            availableSignatures.add(typedSignature);
        }
    }

    public Object[] getParametersForDocumentation(JSFunctionWithSubstitutor p, ParameterInfoContext context) {
        return p.myFunctionItem.getParameters();
    }

    public JSArgumentList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSParameterInfoHandler", "findElementForParameterInfo"));
        }
        JSArgumentList argList = JSParameterInfoHandler.findArgumentList(context.getFile(), context.getOffset());
        if (argList != null) {
            return JSParameterInfoHandler.fillSignaturesForArgumentList(context, argList);
        }
        return null;
    }

    @Nullable
    public static JSArgumentList findArgumentList(PsiFile file, int offset) {
        JSCallExpression callExpression;
        JSArgumentList argList = (JSArgumentList)ParameterInfoUtils.findParentOfTypeWithStopElements((PsiFile)file, (int)offset, JSArgumentList.class, (Class[])new Class[]{JSStatement.class});
        if (argList == null && (callExpression = (JSCallExpression)ParameterInfoUtils.findParentOfTypeWithStopElements((PsiFile)file, (int)offset, JSCallExpression.class, (Class[])new Class[]{JSStatement.class})) != null) {
            argList = callExpression.getArgumentList();
        }
        return argList;
    }

    @Nullable
    private static JSArgumentList fillSignaturesForArgumentList(CreateParameterInfoContext context, @NotNull JSArgumentList argList) {
        PsiElement clazz;
        if (argList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argList", "com/intellij/javascript/JSParameterInfoHandler", "fillSignaturesForArgumentList"));
        }
        PsiElement psiElement = argList.getParent();
        if (!(psiElement instanceof JSCallExpression)) {
            return null;
        }
        JSCallExpression parent = (JSCallExpression)psiElement;
        JSExpression methodExpression = JSUtils.unparenthesize(parent.getMethodExpression());
        if (methodExpression instanceof JSReferenceExpression) {
            ResolveResult[] resolveResults = ((JSReferenceExpression)methodExpression).multiResolve(true);
            if (resolveResults.length > 0) {
                JSNamespace namespace;
                JSType qualifierType;
                ArrayList<JSFunctionWithSubstitutor> items = new ArrayList<JSFunctionWithSubstitutor>(resolveResults.length);
                ArrayList itemsWithoutTypes = new ArrayList(resolveResults.length);
                LinkedHashSet<String> availableSignatures = new LinkedHashSet<String>();
                JSExpression qualifier = ((JSReferenceExpression)methodExpression).getQualifier();
                JSTypeSubstitutor typeSubstitutor = null;
                if (qualifier != null && (qualifierType = JSResolveUtil.getExpressionJSType(qualifier)) != null && (namespace = JSTypeUtils.getNamespaceMatchingType(qualifierType, true, false)) != null) {
                    typeSubstitutor = (JSTypeSubstitutor)namespace.getUserData(JSNamespace.GENERIC_ARGUMENTS_KEY);
                }
                for (ResolveResult r : resolveResults) {
                    PsiElement element = r.getElement();
                    if (element == null) continue;
                    JSFunctionItem functionItem = JSPsiImplUtils.calculatePossibleFunctionCarefully(element, (PsiElement)methodExpression);
                    if (functionItem == null) {
                        JSType functionType;
                        JSType jsType = JSTypeUtils.getTypeOfElement(element);
                        if ((jsType = JSTypeUtils.getValuableType(jsType)) != null && (functionType = (JSType)ContainerUtil.getFirstItem(JSTypeUtils.getFunctionType(jsType, parent instanceof JSNewExpression))) != null) {
                            PsiElement sourceElement = jsType.getSource().getSourceElement();
                            if (sourceElement instanceof JSFunctionItem) {
                                functionItem = (JSFunctionItem)sourceElement;
                            } else {
                                PsiElement functionSourceElement;
                                DialectOptionHolder holder = DialectDetector.dialectOfElement(element);
                                if (holder != null && !holder.isECMA4 && (functionSourceElement = functionType.getSource().getSourceElement()) instanceof JSFunctionItem) {
                                    functionItem = (JSFunctionItem)functionSourceElement;
                                }
                            }
                        }
                    }
                    if (functionItem == null) continue;
                    boolean hasType = false;
                    for (JSParameterItem p : functionItem.getParameters()) {
                        if (p.getType() == null) continue;
                        hasType = true;
                        break;
                    }
                    JSParameterInfoHandler.doAddSignature(hasType ? items : itemsWithoutTypes, availableSignatures, functionItem, typeSubstitutor);
                }
                items.addAll(itemsWithoutTypes);
                context.setItemsToShow(ArrayUtil.toObjectArray(items));
                return argList;
            }
        } else if (methodExpression instanceof JSSuperExpression && (clazz = methodExpression.getReference().resolve()) instanceof JSFunction) {
            context.setItemsToShow(new Object[]{new JSFunctionWithSubstitutor((JSFunctionItem)((JSFunction)clazz), null)});
            return argList;
        }
        return null;
    }

    public void showParameterInfo(@NotNull JSArgumentList element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/JSParameterInfoHandler", "showParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSParameterInfoHandler", "showParameterInfo"));
        }
        context.showHint((PsiElement)element, element.getTextOffset(), (ParameterInfoHandler)this);
    }

    public JSArgumentList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSParameterInfoHandler", "findElementForUpdatingParameterInfo"));
        }
        return JSParameterInfoHandler.findArgumentList(context.getFile(), context.getOffset());
    }

    public void updateParameterInfo(@NotNull JSArgumentList parameterOwner, @NotNull UpdateParameterInfoContext context) {
        if (parameterOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterOwner", "com/intellij/javascript/JSParameterInfoHandler", "updateParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSParameterInfoHandler", "updateParameterInfo"));
        }
        if (context.getParameterOwner() != parameterOwner) {
            context.removeHint();
            return;
        }
        int currentParameterIndex = ParameterInfoUtils.getCurrentParameterIndex((ASTNode)parameterOwner.getNode(), (int)context.getOffset(), (IElementType)JSTokenTypes.COMMA);
        context.setCurrentParameter(currentParameterIndex);
    }

    @NotNull
    public String getParameterCloseChars() {
        if (",){" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSParameterInfoHandler", "getParameterCloseChars"));
        }
        return ",){";
    }

    public boolean tracksParameterIndex() {
        return true;
    }

    public void updateUI(JSFunctionWithSubstitutor pair, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/JSParameterInfoHandler", "updateUI"));
        }
        JSFunctionItem p = pair.myFunctionItem;
        if (!p.isValid()) {
            return;
        }
        JSParameterItem[] params = p.getParameters();
        int currentParameterIndex = context.getCurrentParameterIndex() >= 0 ? context.getCurrentParameterIndex() : params.length;
        JSParameterItem parameter = currentParameterIndex < params.length ? params[currentParameterIndex] : null;
        SignatureInfo signatureInfo = JSParameterInfoHandler.buildSignature(p, false, currentParameterIndex, pair.myTypeSubstitutor);
        String name = signatureInfo.text;
        String currentParameterSignature = parameter != null ? JSParameterInfoHandler.getSignatureForParameter(parameter, pair.myTypeSubstitutor) : null;
        int highlightStart = parameter != null ? signatureInfo.selectedParameterStart : 0;
        int highlightEnd = parameter != null ? highlightStart + currentParameterSignature.length() : 0;
        context.setupUIComponentPresentation(name, highlightStart, highlightEnd, false, false, false, context.getDefaultParameterColor());
    }

    @NotNull
    private static SignatureInfo buildSignature(@NotNull JSFunctionItem function, boolean skipType, int selectedParameterIndex, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/javascript/JSParameterInfoHandler", "buildSignature"));
        }
        JSParameterItem[] params = function.getParameters();
        SignatureInfo info = new SignatureInfo();
        if (params.length > 0) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < params.length; ++i) {
                if (result.length() > 0) {
                    result.append(", ");
                }
                if (selectedParameterIndex == i) {
                    info.selectedParameterStart = result.toString().length();
                }
                result.append(JSParameterInfoHandler.getSignatureForParameter(params[i], skipType, typeSubstitutor));
            }
            if (function.isReferencesArguments()) {
                result.append(", ...");
            }
            info.text = result.toString();
        } else {
            String signature = function.isReferencesArguments() ? "..." : CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]);
            info.text = signature;
        }
        SignatureInfo signatureInfo = info;
        if (signatureInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSParameterInfoHandler", "buildSignature"));
        }
        return signatureInfo;
    }

    private static String getSignatureForParameter(JSParameterItem p, boolean skipType, @Nullable JSTypeSubstitutor typeSubstitutor) {
        DialectOptionHolder holder;
        JSParameterTypeDecorator decorator = p.getTypeDecorator();
        JSType type = p.getTypeIncludingOverridden();
        if (type != null) {
            type = JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)typeSubstitutor);
        }
        String initializerText = p instanceof JSParameter ? ((JSParameter)p).getLiteralOrReferenceInitializerText() : null;
        DialectOptionHolder dialectOptionHolder = holder = p instanceof PsiElement ? DialectDetector.dialectOfElement((PsiElement)p) : null;
        if (!skipType && type != null) {
            String result;
            boolean ecmal4;
            String s = type.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
            boolean bl = ecmal4 = holder != null && holder.isECMA4;
            if (ecmal4) {
                result = p.isRest() ? "... " + p.getName() : p.getName() + ":" + JSLookupUtilImpl.getShortName(s);
            } else {
                if (p.isOptional() && initializerText == null) {
                    s = s + ", optional";
                }
                if (p.isRest()) {
                    s = "..." + s;
                }
                result = "[" + s + "] " + p.getName();
            }
            if (initializerText != null) {
                result = result + " = " + initializerText;
            }
            return result;
        }
        String res = p.getName();
        if (p.isRest()) {
            res = "... " + res;
        }
        if (p.isOptional() && decorator.isExplicitlyDeclared()) {
            res = "[optional] " + res;
        }
        if (initializerText != null) {
            res = res + " = " + initializerText;
        }
        return res;
    }

    public static String getSignatureForParameter(JSParameterItem p) {
        return JSParameterInfoHandler.getSignatureForParameter(p, null);
    }

    public static String getSignatureForParameter(JSParameterItem p, @Nullable JSTypeSubstitutor typeSubstitutor) {
        return JSParameterInfoHandler.getSignatureForParameter(p, false, typeSubstitutor);
    }

    @NotNull
    public JSExpression[] getActualParameters(@NotNull JSArgumentList jsArgumentList) {
        if (jsArgumentList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsArgumentList", "com/intellij/javascript/JSParameterInfoHandler", "getActualParameters"));
        }
        JSExpression[] jSExpressionArray = jsArgumentList.getArguments();
        if (jSExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSParameterInfoHandler", "getActualParameters"));
        }
        return jSExpressionArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        IElementType iElementType = JSTokenTypes.COMMA;
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSParameterInfoHandler", "getActualParameterDelimiterType"));
        }
        return iElementType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        IElementType iElementType = JSTokenTypes.RBRACE;
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSParameterInfoHandler", "getActualParametersRBraceType"));
        }
        return iElementType;
    }

    @NotNull
    public Set<Class> getArgumentListAllowedParentClasses() {
        Set<Class> set = ourArgumentListAllowedParentClassesSet;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSParameterInfoHandler", "getArgumentListAllowedParentClasses"));
        }
        return set;
    }

    @NotNull
    public Class<JSArgumentList> getArgumentListClass() {
        if (JSArgumentList.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JSParameterInfoHandler", "getArgumentListClass"));
        }
        return JSArgumentList.class;
    }

    public static class JSFunctionWithSubstitutor {
        @NotNull
        public final JSFunctionItem myFunctionItem;
        @Nullable
        public final JSTypeSubstitutor myTypeSubstitutor;

        public JSFunctionWithSubstitutor(@NotNull JSFunctionItem item, @Nullable JSTypeSubstitutor substitutor) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/javascript/JSParameterInfoHandler$JSFunctionWithSubstitutor", "<init>"));
            }
            this.myFunctionItem = item;
            this.myTypeSubstitutor = substitutor;
        }
    }

    private static class SignatureInfo {
        String text;
        int selectedParameterStart = -1;

        private SignatureInfo() {
        }
    }
}

