/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public class BaseNodeJSFilter
implements Filter,
DumbAware {
    private static final Pattern[] BASIC_PATTERNS = new Pattern[]{Pattern.compile("^\\s*at\\s+(.*):(\\d*):(\\d*)$"), Pattern.compile("^\\s*at.*\\((.*):(\\d*):(\\d*)\\)$")};
    protected static final Pattern[] ALL_PATTERNS = (Pattern[])ArrayUtil.mergeArrays((Object[])BASIC_PATTERNS, (Object[])new Pattern[]{Pattern.compile("^\\s*at.+?\\(.+?\\((.*):(\\d*):(\\d*)\\)\\)$"), Pattern.compile("^(.*):(\\d+):(\\d+)(?:\\s.*)?$"), Pattern.compile("^(.*):(\\d+)(?:\\s.*)?$")});
    private final Project myProject;
    private final boolean myUseOnlyBasicPatterns;

    public BaseNodeJSFilter(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/BaseNodeJSFilter", "<init>"));
        }
        this(project, false);
    }

    public BaseNodeJSFilter(@NotNull Project project, boolean useOnlyBasicPatterns) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/BaseNodeJSFilter", "<init>"));
        }
        this.myProject = project;
        this.myUseOnlyBasicPatterns = useOnlyBasicPatterns;
    }

    protected Pattern[] getPatterns() {
        return this.myUseOnlyBasicPatterns ? BASIC_PATTERNS : ALL_PATTERNS;
    }

    @Nullable
    private Matcher findMatcher(String line) {
        Pattern[] patterns;
        for (Pattern pattern : patterns = this.getPatterns()) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            return matcher;
        }
        return null;
    }

    public Filter.Result applyFilter(String outLine, int entireLength) {
        Matcher matcher = this.findMatcher(outLine);
        if (matcher != null) {
            String fileName = matcher.group(1);
            VirtualFile file = LocalFileFinder.findFile((String)fileName);
            if (file == null) {
                file = this.findVirtualFile(fileName);
            }
            if (file != null) {
                int line = Integer.parseInt(matcher.group(2)) - 1;
                boolean hasColumnInfo = matcher.groupCount() >= 3;
                int column = hasColumnInfo ? Integer.parseInt(matcher.group(3)) - 1 : 0;
                int start = matcher.start(1);
                int end = matcher.end(matcher.groupCount());
                return new Filter.Result(entireLength - outLine.length() + start, entireLength - outLine.length() + end, (HyperlinkInfo)new OpenFileHyperlinkInfo(this.myProject, file, line, column));
            }
        }
        return null;
    }

    protected VirtualFile findVirtualFile(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/javascript/nodejs/BaseNodeJSFilter", "findVirtualFile"));
        }
        return null;
    }
}

