/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.execution.filters.FileHyperlinkParsedData;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public class NodeConsoleAdditionalFilter
implements Filter,
DumbAware {
    private static final Logger LOG = Logger.getInstance(NodeConsoleAdditionalFilter.class);
    private static final Pattern PATTERN = Pattern.compile("^(?:>> )?([/\\w].*?):(\\d+)(:\\d+)?(?:\\s|$)");
    private final Project myProject;

    public NodeConsoleAdditionalFilter(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/NodeConsoleAdditionalFilter", "<init>"));
        }
        this.myProject = project;
    }

    @Nullable
    public Filter.Result applyFilter(String line, int entireLength) {
        FileHyperlinkParsedData data;
        try {
            data = NodeConsoleAdditionalFilter.parse(line);
        }
        catch (RuntimeException e) {
            LOG.error("Failed to process '" + line + "'", (Throwable)e);
            return null;
        }
        if (data == null) {
            return null;
        }
        VirtualFile file = LocalFileFinder.findFile((String)FileUtil.toSystemIndependentName((String)data.getFilePath()));
        if (file == null) {
            return null;
        }
        boolean grayedHyperlink = JSLibraryUtil.isProbableLibraryFile(file);
        int startOffset = entireLength - line.length();
        return new Filter.Result(startOffset + data.getHyperlinkStartOffset(), startOffset + data.getHyperlinkEndOffset(), (HyperlinkInfo)new OpenFileHyperlinkInfo(this.myProject, file, data.getDocumentLine(), data.getDocumentColumn()), grayedHyperlink);
    }

    @Nullable
    public static FileHyperlinkParsedData parse(@NotNull String line) {
        int documentLine;
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/javascript/nodejs/NodeConsoleAdditionalFilter", "parse"));
        }
        FileHyperlinkParsedData data = NodeConsoleAdditionalFilter.parseFirefoxLikeLink(line);
        if (data != null) {
            return data;
        }
        Matcher matcher = PATTERN.matcher(line);
        if (!matcher.find()) {
            return null;
        }
        String filePath = matcher.group(1);
        try {
            documentLine = Integer.parseInt(matcher.group(2)) - 1;
        }
        catch (NumberFormatException e) {
            return null;
        }
        int documentColumn = NodeConsoleAdditionalFilter.getDocumentColumn(matcher);
        if (documentColumn < -1) {
            return null;
        }
        int hyperlinkEnd = matcher.end(matcher.groupCount());
        hyperlinkEnd = Math.max(hyperlinkEnd, matcher.end(matcher.groupCount() - 1));
        return new FileHyperlinkParsedData(filePath, documentLine, documentColumn, matcher.start(1), hyperlinkEnd);
    }

    private static int getDocumentColumn(@NotNull Matcher matcher) {
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/javascript/nodejs/NodeConsoleAdditionalFilter", "getDocumentColumn"));
        }
        if (matcher.groupCount() < 3) {
            return -1;
        }
        String columnStr = matcher.group(3);
        if (columnStr == null) {
            return -1;
        }
        if (columnStr.startsWith(":")) {
            columnStr = columnStr.substring(1);
        }
        return StringUtil.parseInt((String)columnStr, (int)-1) - 1;
    }

    @Nullable
    private static FileHyperlinkParsedData parseFirefoxLikeLink(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/javascript/nodejs/NodeConsoleAdditionalFilter", "parseFirefoxLikeLink"));
        }
        int startIndex = line.indexOf("@(");
        while (startIndex >= 0) {
            FileHyperlinkParsedData result = NodeConsoleAdditionalFilter.parseFirefoxLikeLinkAt(line, startIndex + 2);
            if (result != null) {
                return result;
            }
            startIndex = line.indexOf("@(", startIndex + 2);
        }
        return null;
    }

    @Nullable
    private static FileHyperlinkParsedData parseFirefoxLikeLinkAt(@NotNull String line, int pathStartInd) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/javascript/nodejs/NodeConsoleAdditionalFilter", "parseFirefoxLikeLinkAt"));
        }
        int length = line.length();
        int pathEndInd = line.indexOf(58, pathStartInd);
        if (pathEndInd > 0 && pathEndInd - pathStartInd > 3) {
            int lineStartInd;
            int lineEndInd;
            for (lineEndInd = lineStartInd = pathEndInd + 1; lineEndInd < length && Character.isDigit(line.charAt(lineEndInd)); ++lineEndInd) {
            }
            if (lineStartInd == lineEndInd) {
                return null;
            }
            int documentColumn = -1;
            int closeParenInd = lineEndInd;
            if (lineEndInd < length && line.charAt(lineEndInd) == ':') {
                int columnStartInd;
                int columnEndInd;
                for (columnEndInd = columnStartInd = lineEndInd + 1; columnEndInd < length && Character.isDigit(line.charAt(columnEndInd)); ++columnEndInd) {
                }
                if (columnStartInd == columnEndInd) {
                    return null;
                }
                documentColumn = StringUtil.parseInt((String)line.substring(columnStartInd, columnEndInd), (int)-1) - 1;
                closeParenInd = columnEndInd;
            }
            if (closeParenInd < length && line.charAt(closeParenInd) == ')') {
                int documentLine = StringUtil.parseInt((String)line.substring(lineStartInd, lineEndInd), (int)-1) - 1;
                return new FileHyperlinkParsedData(line.substring(pathStartInd, pathEndInd), documentLine, documentColumn, pathStartInd, closeParenInd);
            }
        }
        return null;
    }
}

