/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.javascript.nodejs.BaseNodeJSFilter;
import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class NodeJSFilter
extends BaseNodeJSFilter {
    private final NodeJsCoreLibraryManager myCoreLibraryManager;

    public NodeJSFilter(Project project) {
        this(project, false);
    }

    public NodeJSFilter(Project project, boolean useOnlyBasicPatterns) {
        super(project, useOnlyBasicPatterns);
        this.myCoreLibraryManager = NodeJsCoreLibraryManager.getInstance(project);
    }

    @Override
    protected VirtualFile findVirtualFile(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/javascript/nodejs/NodeJSFilter", "findVirtualFile"));
        }
        String nameWithoutExtension = FileUtilRt.getNameWithoutExtension((String)fileName);
        return this.myCoreLibraryManager.findCoreModuleFileByName(nameWithoutExtension);
    }
}

