/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.javascript.nodejs.NodeDetectionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RequestsMerger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="NodeLocalInterpreterManager", storages={@Storage(file="$APP_CONFIG$/other.xml", roamingType=RoamingType.DISABLED)})
public class NodeLocalVersionsManager
implements PersistentStateComponent<Element> {
    private static final String TAG_NODE_INTERPRETER = "node-interpreter";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_LAST_MODIFIED_TIMESTAMP = "last-modified";
    private static final long UPDATE_INTERVAL = TimeUnit.SECONDS.toMillis(20L);
    public static final Comparator<Pair<String, VersionData>> BY_VERSIONS_COMPARATOR = new Comparator<Pair<String, VersionData>>(){

        @Override
        public int compare(Pair<String, VersionData> o1, Pair<String, VersionData> o2) {
            return ((VersionData)o2.getSecond()).getVer().compareTo(((VersionData)o1.getSecond()).getVer());
        }
    };
    @NonNls
    public static final String UNKNOWN_VERSION = "(unknown version)";
    private final Map<String, VersionData> myVersionsMap;
    private List<Pair<String, VersionData>> myVersionsList;
    private final RequestsMerger myRequestsMerger;
    private long myLastUpdateTs = 0L;
    private final Object myLock = new Object();
    private final List<Runnable> myWaitingListeners;

    public static NodeLocalVersionsManager getInstance() {
        return (NodeLocalVersionsManager)ServiceManager.getService(NodeLocalVersionsManager.class);
    }

    public NodeLocalVersionsManager() {
        this.myVersionsMap = new HashMap<String, VersionData>();
        this.myWaitingListeners = new ArrayList<Runnable>();
        Runnable refresher = new Runnable(){

            @Override
            public void run() {
                NodeLocalVersionsManager.this.refresh();
            }
        };
        this.myRequestsMerger = new RequestsMerger(refresher, (Consumer)new Consumer<Runnable>(){

            public void consume(Runnable runnable) {
                ApplicationManager.getApplication().executeOnPooledThread(runnable);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Element getState() {
        HashMap map;
        Object object = this.myLock;
        synchronized (object) {
            map = ContainerUtil.newHashMap(this.myVersionsMap);
        }
        if (map.isEmpty()) {
            return null;
        }
        Element rootElement = new Element("node-interpreters");
        for (Map.Entry entry : map.entrySet()) {
            Element interpreterElement = new Element(TAG_NODE_INTERPRETER);
            interpreterElement.setAttribute(ATTR_PATH, (String)entry.getKey());
            VersionData versionData = (VersionData)entry.getValue();
            SemVer semver = versionData.getVer();
            if (semver != null && !semver.getRawVersion().equals(UNKNOWN_VERSION)) {
                interpreterElement.setAttribute(ATTR_VERSION, semver.getRawVersion());
                interpreterElement.setAttribute(ATTR_LAST_MODIFIED_TIMESTAMP, String.valueOf(versionData.getModificationTime()));
            }
            rootElement.addContent(interpreterElement);
        }
        return rootElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(Element state) {
        Map<String, VersionData> map = NodeLocalVersionsManager.readXml(state);
        Object object = this.myLock;
        synchronized (object) {
            this.myVersionsMap.clear();
            this.myVersionsMap.putAll(map);
        }
        this.asyncUpdate();
    }

    @NotNull
    private static Map<String, VersionData> readXml(@Nullable Element state) {
        if (state == null) {
            Map<String, VersionData> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeLocalVersionsManager", "readXml"));
            }
            return map;
        }
        HashMap map = ContainerUtil.newHashMap();
        List children = state.getChildren(TAG_NODE_INTERPRETER);
        for (Element child : children) {
            String path = child.getAttributeValue(ATTR_PATH);
            if (!StringUtil.isNotEmpty((String)path)) continue;
            SemVer semVer = SemVer.parseFromText((String)StringUtil.notNullize((String)child.getAttributeValue(ATTR_VERSION)));
            if (semVer == null) {
                semVer = NodeLocalVersionsManager.fakeVersion();
            }
            long lastModified = NodeLocalVersionsManager.parseLong(child.getAttributeValue(ATTR_LAST_MODIFIED_TIMESTAMP));
            map.put(path, new VersionData(semVer, lastModified));
        }
        HashMap hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeLocalVersionsManager", "readXml"));
        }
        return hashMap;
    }

    private static long parseLong(@Nullable String str) {
        if (StringUtil.isNotEmpty((String)str)) {
            try {
                return Long.parseLong(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        HashMap<String, VersionData> map;
        Object object;
        long lastUpdate;
        ArrayList<Runnable> list;
        Object object2 = this.myLock;
        synchronized (object2) {
            list = new ArrayList<Runnable>(this.myWaitingListeners);
            this.myWaitingListeners.clear();
        }
        Iterator iterator = this.myLock;
        synchronized (iterator) {
            lastUpdate = this.myLastUpdateTs;
        }
        if (System.currentTimeMillis() > lastUpdate + UPDATE_INTERVAL) {
            object = this.myLock;
            synchronized (object) {
                map = new HashMap<String, VersionData>(this.myVersionsMap);
            }
            this.refreshByMap(map);
        } else {
            map = null;
            object = this.myLock;
            synchronized (object) {
                for (Map.Entry<String, VersionData> entry : this.myVersionsMap.entrySet()) {
                    if (entry.getValue().getModificationTime() != 0L) continue;
                    map = new HashMap<String, VersionData>(this.myVersionsMap);
                    break;
                }
            }
            if (map != null) {
                this.refreshByMap(map);
            }
        }
        for (Runnable runnable : list) {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshByMap(Map<String, VersionData> map) {
        HashMap<String, VersionData> refreshed = new HashMap<String, VersionData>();
        for (Map.Entry<String, VersionData> entry : map.entrySet()) {
            VersionData newVersion = NodeLocalVersionsManager.getVersionData(new File(entry.getKey()), entry.getValue());
            if (newVersion == null) continue;
            refreshed.put(entry.getKey(), newVersion);
        }
        List<File> files = NodeDetectionUtil.listAllPossibleNodeInterpreters(false);
        for (File file : files) {
            String key;
            VersionData newVersion = NodeLocalVersionsManager.getVersionData(file, map.get(key = FileUtil.toSystemIndependentName((String)file.getPath())));
            if (newVersion == null) continue;
            refreshed.put(key, newVersion);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myVersionsMap.clear();
            this.myVersionsMap.putAll(refreshed);
            this.recalculateVersionsList();
            this.myLastUpdateTs = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInterpreterPath(@NotNull String interpreterPath) {
        if (interpreterPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterPath", "com/intellij/javascript/nodejs/NodeLocalVersionsManager", "addInterpreterPath"));
        }
        if (StringUtil.isEmptyOrSpaces((String)(interpreterPath = FileUtil.toSystemIndependentName((String)interpreterPath)))) {
            return;
        }
        File interpreterFile = new File(interpreterPath);
        if (interpreterFile.isAbsolute() && interpreterFile.isFile()) {
            boolean added = false;
            Object object = this.myLock;
            synchronized (object) {
                if (!this.myVersionsMap.containsKey(interpreterPath)) {
                    this.myVersionsMap.put(interpreterPath, new VersionData(NodeLocalVersionsManager.fakeVersion(), 0L));
                    added = true;
                }
            }
            if (added) {
                this.asyncUpdate();
            }
        }
    }

    @Nullable
    private static VersionData getVersionData(File path, @Nullable VersionData oldValue) {
        long modified = path.lastModified();
        if (oldValue != null && modified > 0L && modified == oldValue.getModificationTime()) {
            return oldValue;
        }
        SemVer version = NodeDetectionUtil.fetchInterpreterVersion(path.getPath());
        if (version == null) {
            return null;
        }
        return new VersionData(version, modified);
    }

    @NotNull
    private static SemVer fakeVersion() {
        SemVer semVer = new SemVer(UNKNOWN_VERSION, 0, 0, 0);
        if (semVer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeLocalVersionsManager", "fakeVersion"));
        }
        return semVer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculateVersionsList() {
        Object object = this.myLock;
        synchronized (object) {
            this.myVersionsList = ContainerUtil.newArrayListWithCapacity((int)this.myVersionsMap.size());
            for (Map.Entry<String, VersionData> entry : this.myVersionsMap.entrySet()) {
                this.myVersionsList.add((Pair<String, VersionData>)Pair.create((Object)entry.getKey(), (Object)entry.getValue()));
            }
            Collections.sort(this.myVersionsList, BY_VERSIONS_COMPARATOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SemVer getVersion(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/nodejs/NodeLocalVersionsManager", "getVersion"));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.asyncUpdate();
            VersionData data = this.myVersionsMap.get(FileUtil.toSystemIndependentName((String)file.getPath()));
            return data == null ? null : data.getVer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SemVer getVersion(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTR_PATH, "com/intellij/javascript/nodejs/NodeLocalVersionsManager", "getVersion"));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.asyncUpdate();
            VersionData data = this.myVersionsMap.get(FileUtil.toSystemIndependentName((String)path));
            return data == null ? null : data.getVer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SemVer tryGetVersion(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTR_PATH, "com/intellij/javascript/nodejs/NodeLocalVersionsManager", "tryGetVersion"));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myRequestsMerger.request();
            VersionData data = this.myVersionsMap.get(FileUtil.toSystemIndependentName((String)path));
            return data == null ? null : data.getVer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<Pair<String, VersionData>> getVersions() {
        Object object = this.myLock;
        // MONITORENTER : object
        this.asyncUpdate();
        List<Object> list = this.myVersionsList == null ? Collections.emptyList() : Collections.unmodifiableList(this.myVersionsList);
        // MONITOREXIT : object
        if (list != null) return list;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeLocalVersionsManager", "getVersions"));
    }

    private void asyncUpdate() {
        this.myRequestsMerger.request();
    }

    public static class VersionData {
        private final SemVer myVer;
        private final long myModificationTime;

        public VersionData(SemVer ver, long modificationTime) {
            this.myVer = ver;
            this.myModificationTime = modificationTime;
        }

        public SemVer getVer() {
            return this.myVer;
        }

        public long getModificationTime() {
            return this.myModificationTime;
        }
    }
}

