/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.javascript.nodejs.NodeDetectionUtil;
import com.intellij.javascript.nodejs.NodeLocalVersionsManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import java.awt.FontMetrics;
import java.io.File;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeUIUtil {
    public static final String NODE_INTERPRETER_LABEL = "Node interpreter:";
    public static final String NODE_INTERPRETER_LABEL_WITH_MNEMONIC = "&Node interpreter:";
    public static final String NODE_INTERPRETER_LABEL_WITH_MNEMONIC_ESC = "\u001bNode interpreter:";

    private NodeUIUtil() {
    }

    @NotNull
    public static TextFieldWithHistoryWithBrowseButton createNodeInterpreterTextField(@Nullable Project project) {
        TextFieldWithHistoryWithBrowseButton historyWithBrowseButton = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)"Select Node.js interpreter", (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor(), null);
        TextFieldWithHistory fieldWithHistory = (TextFieldWithHistory)historyWithBrowseButton.getChildComponent();
        NodeUIUtil.addHistoryOnEveryExpansion(fieldWithHistory);
        NodeVersionsListCellRenderer popupListCellRenderer = new NodeVersionsListCellRenderer(fieldWithHistory);
        fieldWithHistory.setRenderer((ListCellRenderer)new DelegatingCellRenderer(fieldWithHistory.getRenderer(), (ListCellRenderer)((Object)popupListCellRenderer)));
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = historyWithBrowseButton;
        if (textFieldWithHistoryWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeUIUtil", "createNodeInterpreterTextField"));
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    private static void addHistoryOnEveryExpansion(final @NotNull TextFieldWithHistory textFieldWithHistory) {
        if (textFieldWithHistory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textFieldWithHistory", "com/intellij/javascript/nodejs/NodeUIUtil", "addHistoryOnEveryExpansion"));
        }
        textFieldWithHistory.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                List<File> newFiles = NodeDetectionUtil.listAllPossibleNodeInterpreters();
                List history = ContainerUtil.map(newFiles, (Function)new Function<File, String>(){

                    public String fun(File file) {
                        return file.getAbsolutePath();
                    }
                });
                SwingHelper.setHistory((TextFieldWithHistory)textFieldWithHistory, (List)ContainerUtil.notNullize((List)history), (boolean)true);
            }
        });
    }

    private static class NodeVersionsListCellRenderer
    extends ColoredListCellRenderer<String> {
        private final TextFieldWithHistory myHistory;
        private int myHistoryPreferredSize;
        private Integer myMaxTextWidth;
        private FontMetrics myMetrics;
        private final NodeLocalVersionsManager myVersionsManager;

        private NodeVersionsListCellRenderer(@NotNull TextFieldWithHistory history) {
            if (history == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "history", "com/intellij/javascript/nodejs/NodeUIUtil$NodeVersionsListCellRenderer", "<init>"));
            }
            this.myHistoryPreferredSize = -1;
            this.myVersionsManager = NodeLocalVersionsManager.getInstance();
            this.myHistory = history;
        }

        protected void customizeCellRenderer(JList list, String value, int index, boolean selected, boolean hasFocus) {
            if (index == 0 || this.myMetrics == null) {
                this.calculateMaxWidth();
            }
            if (value != null) {
                this.append(value, SimpleTextAttributes.REGULAR_ATTRIBUTES, 0, 2);
                String versionText = this.versionText(value);
                if (versionText != null) {
                    int versionWidth = this.myMetrics.stringWidth("  " + versionText);
                    int versionEnd = Math.max(versionWidth + this.myMaxTextWidth, this.myHistory.getTextEditor().getWidth());
                    this.append(versionText, SimpleTextAttributes.GRAY_ATTRIBUTES, versionEnd, 4);
                    this.updatePopupWidth(versionEnd + JBUI.scale((int)6));
                }
            }
        }

        private void updatePopupWidth(int popupWidth) {
            if (this.myHistoryPreferredSize < popupWidth && this.myHistory.getSize().width < popupWidth) {
                this.myHistoryPreferredSize = popupWidth;
                SwingHelper.setPreferredWidth((Component)this.myHistory, (int)popupWidth);
            }
        }

        @Nullable
        private String versionText(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javascript/nodejs/NodeUIUtil$NodeVersionsListCellRenderer", "versionText"));
            }
            SemVer version = this.myVersionsManager.getVersion(path);
            return version != null ? version.getRawVersion() : null;
        }

        private void calculateMaxWidth() {
            this.myMetrics = this.getFontMetrics(this.getFont());
            int max = 0;
            for (String line : this.myHistory.getHistory()) {
                max = Math.max(max, this.myMetrics.stringWidth(line));
            }
            this.myMaxTextWidth = max;
        }
    }

    private static class DelegatingCellRenderer
    implements ListCellRenderer {
        private final ListCellRenderer myOriginalCellRenderer;
        private final ListCellRenderer myPopupCellRenderer;

        public DelegatingCellRenderer(@NotNull ListCellRenderer originalCellRenderer, @NotNull ListCellRenderer popupCellRenderer) {
            if (originalCellRenderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalCellRenderer", "com/intellij/javascript/nodejs/NodeUIUtil$DelegatingCellRenderer", "<init>"));
            }
            if (popupCellRenderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupCellRenderer", "com/intellij/javascript/nodejs/NodeUIUtil$DelegatingCellRenderer", "<init>"));
            }
            this.myOriginalCellRenderer = originalCellRenderer;
            this.myPopupCellRenderer = popupCellRenderer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ListCellRenderer cellRenderer = index == -1 ? this.myOriginalCellRenderer : this.myPopupCellRenderer;
            return cellRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }
}

