/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequireFileQuotesCache {
    private static final boolean DEFAULT_SINGLE_QUOTE = true;
    public static final Key<CachedValue<Boolean>> FILE_QUOTES = Key.create((String)"Javascript.quotes.used.in.file");
    private static final RequireFileQuotesCache ourInstance = new RequireFileQuotesCache();

    public static RequireFileQuotesCache getInstance() {
        return ourInstance;
    }

    public boolean isSingleQuotes(final @NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/nodejs/RequireFileQuotesCache", "isSingleQuotes"));
        }
        Project project = file.getProject();
        return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)file, FILE_QUOTES, (CachedValueProvider)new CachedValueProvider<Boolean>(){

            @Nullable
            public CachedValueProvider.Result<Boolean> compute() {
                return new CachedValueProvider.Result((Object)RequireFileQuotesCache.calculateForFile(file), new Object[]{file});
            }
        }, false);
    }

    private static boolean calculateForFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/javascript/nodejs/RequireFileQuotesCache", "calculateForFile"));
        }
        if (!psiFile.isValid()) {
            return true;
        }
        final boolean[] value = new boolean[]{true};
        PsiTreeUtil.processElements((PsiElement)psiFile, (PsiElementProcessor)new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/nodejs/RequireFileQuotesCache$2", "execute"));
                }
                if (element instanceof JSCallExpression) {
                    JSExpression method = ((JSCallExpression)element).getMethodExpression();
                    JSExpression[] arguments = ((JSCallExpression)element).getArguments();
                    if (method instanceof JSReferenceExpression && ("require".equals(((JSReferenceExpression)method).getReferenceName()) || "define".equals(((JSReferenceExpression)method).getReferenceName())) && ((JSReferenceExpression)method).getQualifier() == null) {
                        for (JSExpression argument : arguments) {
                            if (argument instanceof JSArrayLiteralExpression) {
                                JSExpression[] arrayExpressions;
                                for (JSExpression expression : arrayExpressions = ((JSArrayLiteralExpression)argument).getExpressions()) {
                                    if (!(expression instanceof JSLiteralExpression) || !this.quoteFound(expression.getText())) continue;
                                    return false;
                                }
                                continue;
                            }
                            if (!(argument instanceof JSLiteralExpression) || !this.quoteFound(argument.getText())) continue;
                            return false;
                        }
                    }
                }
                return true;
            }

            private boolean quoteFound(String text) {
                if ((text = text.trim()).startsWith("\"") || text.startsWith("'")) {
                    value[0] = !text.startsWith("\"");
                    return true;
                }
                return false;
            }
        });
        return value[0];
    }
}

