/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.stream.JsonReader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsCoreModulesCatalog {
    private static final Logger LOG;
    private static final String FILE_NAME = "node-core-modules-catalog.json";
    public static final NodeJsCoreModulesCatalog INSTANCE;
    private final Set<String> myPublicAllCoreModules;
    private final Set<String> myPublicExcludedCoreModules;
    private final Set<String> myPrivateIncludedCoreModules;

    public NodeJsCoreModulesCatalog(@NotNull List<String> publicAllCoreModules, @NotNull List<String> publicExcludedCoreModules, @NotNull List<String> privateIncludedCoreModules) {
        if (publicAllCoreModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "publicAllCoreModules", "com/intellij/javascript/nodejs/library/NodeJsCoreModulesCatalog", "<init>"));
        }
        if (publicExcludedCoreModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "publicExcludedCoreModules", "com/intellij/javascript/nodejs/library/NodeJsCoreModulesCatalog", "<init>"));
        }
        if (privateIncludedCoreModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "privateIncludedCoreModules", "com/intellij/javascript/nodejs/library/NodeJsCoreModulesCatalog", "<init>"));
        }
        this.myPublicAllCoreModules = ImmutableSet.copyOf(publicAllCoreModules);
        this.myPublicExcludedCoreModules = ImmutableSet.copyOf(publicExcludedCoreModules);
        this.myPrivateIncludedCoreModules = ImmutableSet.copyOf(privateIncludedCoreModules);
    }

    @NotNull
    public ImmutableList<String> getPublicCoreModules() {
        ImmutableList immutableList = ImmutableList.copyOf(this.myPublicAllCoreModules);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeJsCoreModulesCatalog", "getPublicCoreModules"));
        }
        return immutableList;
    }

    public boolean isPublicCoreModule(@Nullable String name) {
        return this.myPublicAllCoreModules.contains(name);
    }

    public boolean isIncludedCoreModule(String name) {
        if (this.myPublicAllCoreModules.contains(name) && !this.myPublicExcludedCoreModules.contains(name)) {
            return true;
        }
        return this.myPrivateIncludedCoreModules.contains(name);
    }

    public boolean isPublicExcludedCoreModule(String name) {
        return this.myPublicExcludedCoreModules.contains(name);
    }

    public boolean isPrivateIncludedCoreModule(String name) {
        return this.myPrivateIncludedCoreModules.contains(name);
    }

    @Nullable
    private static NodeJsCoreModulesCatalog parse() throws IOException {
        InputStream stream = NodeJsCoreModulesCatalog.class.getResourceAsStream(FILE_NAME);
        try {
            if (stream == null) {
                throw new IOException("NodeJS plugin installation is possibly broken. Cannot find node-core-modules-catalog.json");
            }
            NodeJsCoreModulesCatalog nodeJsCoreModulesCatalog = NodeJsCoreModulesCatalog.doParse(stream);
            return nodeJsCoreModulesCatalog;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOG.error("Failed to close stream", (Throwable)e);
                }
            }
        }
    }

    @NotNull
    private static NodeJsCoreModulesCatalog doParse(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/javascript/nodejs/library/NodeJsCoreModulesCatalog", "doParse"));
        }
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(stream, CharsetToolkit.UTF8_CHARSET));
        reader.beginObject();
        List publicAllNames = Collections.emptyList();
        List publicExcludedNames = Collections.emptyList();
        List privateIncludedNames = Collections.emptyList();
        while (reader.hasNext()) {
            String type = reader.nextName();
            if ("public-all".equals(type)) {
                publicAllNames = JsonUtil.nextStringList((JsonReader)reader);
                continue;
            }
            if ("public-excluded".equals(type)) {
                publicExcludedNames = JsonUtil.nextStringList((JsonReader)reader);
                continue;
            }
            if (!"private-included".equals(type)) continue;
            privateIncludedNames = JsonUtil.nextStringList((JsonReader)reader);
        }
        reader.endObject();
        NodeJsCoreModulesCatalog nodeJsCoreModulesCatalog = new NodeJsCoreModulesCatalog(publicAllNames, publicExcludedNames, privateIncludedNames);
        if (nodeJsCoreModulesCatalog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeJsCoreModulesCatalog", "doParse"));
        }
        return nodeJsCoreModulesCatalog;
    }

    static {
        NodeJsCoreModulesCatalog catalog;
        LOG = Logger.getInstance(NodeJsCoreModulesCatalog.class);
        try {
            catalog = NodeJsCoreModulesCatalog.parse();
        }
        catch (IOException e) {
            LOG.error("Failed to list core modules", (Throwable)e);
            List<String> empty = Collections.emptyList();
            catalog = new NodeJsCoreModulesCatalog(empty, empty, empty);
        }
        INSTANCE = catalog;
    }
}

