/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.actionscript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.actionscript.parsing.ActionScriptParser;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.psi.tree.IElementType;

public class ActionScriptExpressionParser
extends ExpressionParser<ActionScriptParser> {
    protected ActionScriptExpressionParser(ActionScriptParser parser) {
        super(parser);
    }

    @Override
    protected boolean isPropertyStart(IElementType elementType) {
        return JSKeywordSets.AS_IDENTIFIER_TOKENS_SET.contains(elementType) || elementType == JSTokenTypes.STRING_LITERAL || elementType == JSTokenTypes.NUMERIC_LITERAL || elementType == JSTokenTypes.LPAR;
    }

    @Override
    public boolean isPropertyNameStart(IElementType elementType) {
        return JSKeywordSets.PROPERTY_NAMES.contains(elementType);
    }

    @Override
    protected boolean isFunctionPropertyStart() {
        return false;
    }

    @Override
    protected boolean parsePropertyNoMarker(PsiBuilder.Marker property) {
        if (this.builder.getTokenType() == JSTokenTypes.LPAR) {
            this.parseParenthesizedExpression();
            this.parsePropertyInitializer();
            property.done(JSStubElementTypes.PROPERTY);
            property.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
            return true;
        }
        return super.parsePropertyNoMarker(property);
    }

    @Override
    protected boolean isReferenceQualifierSeparator(IElementType tokenType) {
        return tokenType == JSTokenTypes.DOT || tokenType == JSTokenTypes.COLON_COLON || tokenType == JSTokenTypes.DOT_DOT;
    }

    @Override
    public boolean proceedWithNamespaceReference(PsiBuilder.Marker identifier, boolean expressionContext) {
        if (this.builder.getTokenType() == JSTokenTypes.COLON_COLON) {
            this.builder.advanceLexer();
            identifier.done(JSElementTypes.E4X_NAMESPACE_REFERENCE);
            IElementType tokenType = this.builder.getTokenType();
            if (tokenType != JSTokenTypes.ANY_IDENTIFIER && !this.isIdentifierToken(tokenType)) {
                if (!expressionContext || tokenType != JSTokenTypes.LBRACKET) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.name", (Object[])new Object[0]));
                }
            } else {
                this.builder.advanceLexer();
            }
            return true;
        }
        identifier.drop();
        return false;
    }
}

