/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ecmascript6.completion.ES6ImportSpecifierCompletionProvider;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ES6ExportSpecifierCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/ecmascript6/completion/ES6ExportSpecifierCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/ecmascript6/completion/ES6ExportSpecifierCompletionProvider", "addCompletions"));
        }
        PsiElement parent = parameters.getPosition().getParent();
        assert (parent instanceof ES6ExportSpecifier);
        result.addAllElements(ES6ExportSpecifierCompletionProvider.getVariants((ES6ExportSpecifier)parent));
    }

    @NotNull
    public static Iterable<LookupElement> getVariants(@NotNull ES6ExportSpecifier exportSpecifier) {
        if (exportSpecifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exportSpecifier", "com/intellij/lang/ecmascript6/completion/ES6ExportSpecifierCompletionProvider", "getVariants"));
        }
        SinkResolveProcessor<CompletionResultSink> processor = new SinkResolveProcessor<CompletionResultSink>(new CompletionResultSink((PsiElement)exportSpecifier));
        processor.setTypeContext(true);
        processor.setLocalResolve(true);
        ES6ImportExportDeclaration declaration = exportSpecifier.getDeclaration();
        if (declaration != null && declaration.getFromClause() != null) {
            processor.getAccessibilityProcessingHandler().setAcceptOnlyExportedSymbols();
        }
        ES6PsiUtil.processSpecifier((ES6ImportExportSpecifier)exportSpecifier, processor, (PsiElement)exportSpecifier.getContainingFile());
        List<PsiElement> elements = processor.getResults();
        if (ContainerUtil.isEmpty(elements)) {
            List<LookupElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/completion/ES6ExportSpecifierCompletionProvider", "getVariants"));
            }
            return list;
        }
        List<LookupElement> list = ES6ImportSpecifierCompletionProvider.buildResult(elements);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/completion/ES6ExportSpecifierCompletionProvider", "getVariants"));
        }
        return list;
    }
}

