/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.completion.JSReferenceCompletionContributor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSPropertyNameReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class ES6PropertyCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        PsiReference parentReference;
        Object[] parentReferences;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/ecmascript6/completion/ES6PropertyCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/ecmascript6/completion/ES6PropertyCompletionProvider", "addCompletions"));
        }
        PsiElement parent = parameters.getPosition().getParent();
        assert (parent instanceof JSReferenceExpression);
        JSReferenceExpression referenceExpression = (JSReferenceExpression)parent;
        PsiElement grandParent = referenceExpression.getParent();
        assert (grandParent instanceof ES6Property);
        PsiElement firstElement = grandParent.getNode().getFirstChildNode().getPsi();
        if (firstElement.isEquivalentTo((PsiElement)referenceExpression) && (parentReferences = grandParent.getReferences()).length > 0 && (parentReference = (PsiReference)ArrayUtil.getFirstElement((Object[])parentReferences)) instanceof JSPropertyNameReference) {
            result.addAllElements(JSReferenceCompletionContributor.getPropertyNameReferenceVariants((JSPropertyNameReference)parentReference));
        }
    }
}

