/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.index;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.text.CharArrayUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ES6FileIncludeProvider
extends FileIncludeProvider {
    @NotNull
    public String getId() {
        String string = JavaScriptSupportLoader.ECMA_SCRIPT_6.getID();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/index/ES6FileIncludeProvider", "getId"));
        }
        return string;
    }

    public boolean acceptFile(VirtualFile file) {
        return file.getFileType() == JavaScriptFileType.INSTANCE;
    }

    public void registerFileTypesUsedForIndexing(@NotNull Consumer<FileType> fileTypeSink) {
        if (fileTypeSink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeSink", "com/intellij/lang/ecmascript6/index/ES6FileIncludeProvider", "registerFileTypesUsedForIndexing"));
        }
        fileTypeSink.consume((Object)JavaScriptFileType.INSTANCE);
    }

    @NotNull
    public FileIncludeInfo[] getIncludeInfos(FileContent content) {
        PsiFile file = content.getPsiFile();
        if (DialectDetector.dialectOfFile(file) != DialectOptionHolder.ECMA_6) {
            if (FileIncludeInfo.EMPTY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/index/ES6FileIncludeProvider", "getIncludeInfos"));
            }
            return FileIncludeInfo.EMPTY;
        }
        CharSequence text = content.getContentAsText();
        int start = CharArrayUtil.indexOf((CharSequence)text, (CharSequence)"from", (int)0);
        boolean hasFrom = false;
        while (start != -1) {
            if (start > 0 && Character.isWhitespace(text.charAt(start - 1)) && start < text.length() - "from".length() - 1 && Character.isWhitespace(text.charAt(start + "from".length()))) {
                hasFrom = true;
                break;
            }
            start = CharArrayUtil.indexOf((CharSequence)text, (CharSequence)"from", (int)(start + 1));
        }
        if (!hasFrom) {
            if (FileIncludeInfo.EMPTY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/index/ES6FileIncludeProvider", "getIncludeInfos"));
            }
            return FileIncludeInfo.EMPTY;
        }
        SmartList result = new SmartList();
        for (PsiElement topLevelElement = file.getFirstChild(); topLevelElement != null; topLevelElement = topLevelElement.getNextSibling()) {
            ASTNode literalNode;
            ES6FromClause fromClause;
            ES6FromClause eS6FromClause = fromClause = topLevelElement instanceof ES6ImportExportDeclaration ? ((ES6ImportExportDeclaration)topLevelElement).getFromClause() : null;
            if (fromClause == null || (literalNode = fromClause.getNode().findChildByType(JSTokenTypes.STRING_LITERALS)) == null) continue;
            String filePath = StringUtil.unquoteString((String)literalNode.getText()) + ".js";
            result.add(new FileIncludeInfo(FileUtil.toSystemIndependentName((String)filePath)));
        }
        FileIncludeInfo[] fileIncludeInfoArray = result.isEmpty() ? FileIncludeInfo.EMPTY : (FileIncludeInfo[])ArrayUtil.toObjectArray((Collection)result, FileIncludeInfo.class);
        if (fileIncludeInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/index/ES6FileIncludeProvider", "getIncludeInfos"));
        }
        return fileIncludeInfoArray;
    }
}

