/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.psi.tree.IElementType;

public class ES6PsiTypeParser<P extends ES6Parser>
extends JSPsiTypeParser<P> {
    protected ES6PsiTypeParser(P parser) {
        super(parser);
    }

    @Override
    public boolean tryParseType() {
        if (this.builder.getTokenType() == JSTokenTypes.COLON) {
            this.builder.advanceLexer();
            return this.parseType();
        }
        return false;
    }

    @Override
    public boolean parseType() {
        boolean result;
        IElementType type = this.builder.getTokenType();
        if (type == JSTokenTypes.LBRACE) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            result = true;
            boolean first = true;
            while (this.builder.getTokenType() != JSTokenTypes.RBRACE) {
                if (this.builder.eof()) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.missing.rbrace", (Object[])new Object[0]));
                    result = false;
                    break;
                }
                if (!first) {
                    ES6PsiTypeParser.checkMatches(this.builder, JSTokenTypes.COMMA, "javascript.parser.message.expected.comma.or.rbrace");
                }
                this.parseTypeMember();
                first = false;
            }
            if (result) {
                this.builder.advanceLexer();
            }
            marker.done(ES6ElementTypes.OBJECT_TYPE);
        } else if (type == JSTokenTypes.VOID_KEYWORD || type == JSTokenTypes.ANY_KEYWORD || type == JSTokenTypes.SYMBOL_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            marker.done(ES6ElementTypes.SINGLE_TYPE);
            result = true;
        } else if (this.isIdentifierToken(type)) {
            PsiBuilder.Marker marker = this.builder.mark();
            result = ((ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).parseQualifiedTypeName();
            marker.done(ES6ElementTypes.SINGLE_TYPE);
        } else {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.typename", (Object[])new Object[0]));
            result = false;
        }
        return result;
    }

    private boolean parseTypeMember() {
        boolean result;
        PsiBuilder.Marker typeMember = this.builder.mark();
        IElementType firstToken = this.builder.getTokenType();
        if (JSKeywordSets.PROPERTY_NAMES.contains(firstToken)) {
            this.builder.advanceLexer();
            result = this.tryParseType();
            typeMember.done(ES6ElementTypes.PROPERTY_SIGNATURE);
        } else {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.type.member", (Object[])new Object[0]));
            this.builder.advanceLexer();
            typeMember.drop();
            result = false;
        }
        return result;
    }
}

