/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.parsing.ES6ExpressionParser;
import com.intellij.lang.ecmascript6.parsing.ES6FunctionParser;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class ES6StatementParser<P extends ES6Parser<?, ?, ?, ?>>
extends StatementParser<P> {
    public ES6StatementParser(P parser) {
        super(parser);
    }

    @Override
    protected void parseClassMember() {
        PsiBuilder.Marker classMember = this.builder.mark();
        int classMemberOffset = this.builder.getCurrentOffset();
        if (this.builder.getTokenType() == JSTokenTypes.SEMICOLON) {
            classMember.drop();
            this.parseEmptyStatement();
            return;
        }
        if (this.builder.getTokenType() == JSTokenTypes.CONST_KEYWORD) {
            this.parseVarStatementNoMarker(false, classMember);
            return;
        }
        boolean lexerAdvanced = false;
        PsiBuilder.Marker attrList = this.builder.mark();
        ((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).tryParseES7Decorators();
        if ((this.builder.getTokenType() == JSTokenTypes.PRIVATE_KEYWORD || this.builder.getTokenType() == JSTokenTypes.PUBLIC_KEYWORD) && ES6StatementParser.isAttributeListPartOrMethodNameStart(this.builder.lookAhead(1))) {
            this.builder.advanceLexer();
            lexerAdvanced = true;
        }
        if (this.builder.getTokenType() == JSTokenTypes.STATIC_KEYWORD && ES6StatementParser.isAttributeListPartOrMethodNameStart(this.builder.lookAhead(1))) {
            this.builder.advanceLexer();
            lexerAdvanced = true;
        }
        boolean isGenerator = false;
        if (this.builder.getTokenType() == JSTokenTypes.MULT && ES6StatementParser.isAttributeListPartOrMethodNameStart(this.builder.lookAhead(1))) {
            this.builder.advanceLexer();
            lexerAdvanced = true;
            isGenerator = true;
        }
        ((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).putIsGenerator(isGenerator);
        if (this.builder.getTokenType() == JSTokenTypes.ASYNC_KEYWORD && ES6StatementParser.isAttributeListPartOrMethodNameStart(this.builder.lookAhead(1))) {
            this.builder.advanceLexer();
            lexerAdvanced = true;
            this.builder.putUserData(ES6FunctionParser.HAD_ASYNC_MODIFIER_KEY, (Object)Boolean.TRUE);
        }
        attrList.done(JSStubElementTypes.ATTRIBUTE_LIST);
        IElementType nextToken = this.builder.getTokenType();
        if (nextToken == JSTokenTypes.MIXIN_KEYWORD && this.isIdentifierToken(this.builder.lookAhead(1))) {
            this.builder.advanceLexer();
            if (this.builder.getTokenType() == JSTokenTypes.IDENTIFIER) {
                ((ES6Parser)this.myJavaScriptParser).buildTokenElement(JSElementTypes.REFERENCE_EXPRESSION);
            }
            this.forceCheckForSemicolon();
            classMember.done(JSElementTypes.MIXIN_STATEMENT);
        } else if (nextToken == JSTokenTypes.VAR_KEYWORD) {
            this.parseVarStatementNoMarker(false, classMember);
        } else if (this.isNamedClassMemberStart()) {
            this.parseNamedClassMember(classMember);
        } else {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.statement", (Object[])new Object[0]));
            if (!lexerAdvanced) {
                this.builder.advanceLexer();
            }
            classMember.drop();
        }
        ((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).popIsGenerator();
        assert (this.builder.getCurrentOffset() > classMemberOffset);
    }

    protected boolean isNamedClassMemberStart() {
        IElementType nextToken = this.builder.getTokenType();
        return nextToken == JSTokenTypes.GET_KEYWORD || nextToken == JSTokenTypes.SET_KEYWORD || nextToken == JSTokenTypes.MULT && ((ES6ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).isPropertyNameStart(this.builder.lookAhead(1)) || ((ES6ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).isPropertyNameStart(nextToken);
    }

    protected void parseNamedClassMember(@NotNull PsiBuilder.Marker classMember) {
        if (classMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classMember", "com/intellij/lang/ecmascript6/parsing/ES6StatementParser", "parseNamedClassMember"));
        }
        IElementType lookahead = this.builder.lookAhead(1);
        PsiBuilder.Marker mark = this.builder.mark();
        boolean skipName = false;
        IElementType nextToken = this.builder.getTokenType();
        if (nextToken == JSTokenTypes.LBRACKET) {
            ((ES6ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).parsePropertyName();
            skipName = true;
            lookahead = this.builder.getTokenType();
        } else if ((nextToken == JSTokenTypes.GET_KEYWORD || nextToken == JSTokenTypes.SET_KEYWORD || nextToken == JSTokenTypes.MULT) && ((ES6ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).isPropertyNameStart(this.builder.lookAhead(1))) {
            boolean isGenerator = false;
            if (nextToken == JSTokenTypes.MULT) {
                this.builder.advanceLexer();
                isGenerator = true;
            }
            mark.drop();
            ((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).putIsGenerator(isGenerator);
            this.parseMemberFunction(classMember, false);
            ((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).popIsGenerator();
            return;
        }
        if (JSTokenTypes.LPAR == lookahead || JSTokenTypes.LT == lookahead) {
            mark.drop();
            ((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).putIsGenerator(false);
            this.parseMemberFunction(classMember, skipName);
            ((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).popIsGenerator();
        } else {
            this.parseMemberVariable(mark, skipName);
            this.forceCheckForSemicolon();
            classMember.done(JSStubElementTypes.VAR_STATEMENT);
            classMember.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        }
    }

    protected void parseMemberFunction(PsiBuilder.Marker classMember, boolean skipName) {
        boolean nameParsed;
        if (!skipName && !(nameParsed = ((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).parseFunctionName(true, FunctionParser.Context.PROPERTY))) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.function.name", (Object[])new Object[0]));
        }
        ES6FunctionParser functionParser = (ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser();
        functionParser.parseParameterList(false);
        ((JSPsiTypeParser)((ES6Parser)this.myJavaScriptParser).getTypeParser()).tryParseType();
        if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
            ((ES6StatementParser)((ES6Parser)this.myJavaScriptParser).getStatementParser()).parseFunctionBody();
        } else {
            this.checkMemberFunctionSuffix();
        }
        this.checkForSemicolon();
        classMember.done(functionParser.getFunctionDeclarationElementType());
        classMember.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    protected void checkMemberFunctionSuffix() {
        ES6StatementParser.checkMatches(this.builder, JSTokenTypes.SEMICOLON, "javascript.parser.message.expected.lbrace.or.semicolon");
    }

    protected void parseMemberVariable(PsiBuilder.Marker var, boolean skipName) {
        if (!skipName) {
            ((ES6ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).parsePropertyName();
        }
        ((JSPsiTypeParser)((ES6Parser)this.myJavaScriptParser).getTypeParser()).tryParseType();
        if (this.builder.getTokenType() == JSTokenTypes.EQ) {
            this.parseVariableInitializer(false);
        }
        var.done(this.getVariableElementType());
        var.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    @Override
    protected boolean parseReferenceListMember() {
        ES6ExpressionParser expressionParser = (ES6ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser();
        boolean result = expressionParser.parseLeftHandSideExpression(false);
        if (result) {
            expressionParser.tryParseTypeArgumentList(true, this.getTypeArgumentsListElementType());
        }
        return result;
    }

    protected IElementType getTypeArgumentsListElementType() {
        return ES6ElementTypes.TYPE_ARGUMENT_LIST;
    }

    public static boolean isAttributeListPartOrMethodNameStart(IElementType token) {
        return JSKeywordSets.PROPERTY_NAMES.contains(token) || token == JSTokenTypes.MULT || token == JSTokenTypes.LBRACKET;
    }

    @Override
    protected boolean hasAttributeModifiers() {
        return JSTokenTypes.AT == this.builder.getTokenType() || super.hasAttributeModifiers();
    }

    @Override
    protected boolean isModifier(IElementType token) {
        if (token == JSTokenTypes.ASYNC_KEYWORD) {
            return this.builder.lookAhead(1) == JSTokenTypes.FUNCTION_KEYWORD;
        }
        return super.isModifier(token);
    }
}

