/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.stubs.ES6FromClauseStub;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6FromClauseImpl
extends JSStubElementImpl<ES6FromClauseStub>
implements ES6FromClause,
StubBasedPsiElement<ES6FromClauseStub> {
    public ES6FromClauseImpl(ASTNode node) {
        super(node);
    }

    public ES6FromClauseImpl(ES6FromClauseStub stub) {
        super(stub, (IStubElementType)ES6ElementTypes.FROM_CLAUSE);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/ecmascript6/psi/impl/ES6FromClauseImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitES6FromClause((ES6FromClause)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = (PsiReference[])CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<PsiReference[]>(){

            @Nullable
            public CachedValueProvider.Result<PsiReference[]> compute() {
                return CachedValueProvider.Result.create((Object)ES6FromClauseImpl.this.calcReferences(), (Object[])new Object[]{ES6FromClauseImpl.this});
            }
        });
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6FromClauseImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    @NotNull
    private PsiReference[] calcReferences() {
        PsiReference[] psiReferenceArray = ES6PsiUtil.calcImportExportFromClauseReferences((PsiElement)this, null);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6FromClauseImpl", "calcReferences"));
        }
        return psiReferenceArray;
    }

    public PsiReference getReference() {
        return (PsiReference)ArrayUtil.getLastElement((Object[])this.getReferences());
    }

    @NotNull
    public Collection<PsiElement> resolveReferencedElements() {
        Collection collection = (Collection)CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<Collection<PsiElement>>(){

            @Nullable
            public CachedValueProvider.Result<Collection<PsiElement>> compute() {
                String text = ES6FromClauseImpl.this.getReferenceText();
                if (StringUtil.isEmpty((String)text)) {
                    return CachedValueProvider.Result.create((Object)ContainerUtil.emptyList(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
                }
                PsiReference[] references = ES6PsiUtil.createImportExportFromClauseReferences((PsiElement)ES6FromClauseImpl.this, 0, text, null);
                PsiElement file = null;
                for (PsiReference reference : references) {
                    if (reference == null) continue;
                    if (reference instanceof PsiPolyVariantReference) {
                        ResolveResult[] results = ((PsiPolyVariantReference)reference).multiResolve(false);
                        if (results.length <= 0) continue;
                        ArrayList elements = ContainerUtil.newArrayList();
                        for (ResolveResult result : results) {
                            PsiElement element = result.getElement();
                            if (element instanceof TypeScriptModule) {
                                elements.add(element);
                            }
                            if (file != null || !(element instanceof PsiFile)) continue;
                            file = element;
                        }
                        if (elements.size() <= 0) continue;
                        return CachedValueProvider.Result.create((Object)elements, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
                    }
                    PsiElement resolve = reference.resolve();
                    if (resolve instanceof TypeScriptModule) {
                        return CachedValueProvider.Result.create((Object)ContainerUtil.createMaybeSingletonList((Object)resolve), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
                    }
                    if (file != null || !(resolve instanceof PsiFile)) continue;
                    file = resolve;
                }
                return CachedValueProvider.Result.create((Object)ContainerUtil.createMaybeSingletonList(file), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
            }
        });
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6FromClauseImpl", "resolveReferencedElements"));
        }
        return collection;
    }

    @Nullable
    public String getReferenceText() {
        ES6FromClauseStub stub = (ES6FromClauseStub)this.getStub();
        if (stub != null) {
            return stub.getReferenceText();
        }
        Pair<String, PsiElement> unquoted = JSPsiImplUtils.getChildStringLiteralWithText((PsiElement)this);
        return unquoted == null ? null : (String)unquoted.first;
    }
}

