/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPropertyImpl;
import com.intellij.lang.javascript.psi.stubs.JSPropertyStub;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.Nullable;

public class ES6PropertyImpl
extends JSPropertyImpl
implements ES6Property {
    public ES6PropertyImpl(ASTNode node) {
        super(node);
    }

    public ES6PropertyImpl(JSPropertyStub stub) {
        super(stub, (IStubElementType)ES6ElementTypes.PROPERTY);
    }

    @Nullable
    public JSExpression tryGetComputedPropertyName() {
        return TypeScriptUtil.getComputedExpression((JSNamedElement)this);
    }

    @Nullable
    public static ASTNode tryGetComputedPropertyName(ASTNode propertyNode) {
        ASTNode lbracket = propertyNode.findChildByType(JSTokenTypes.LBRACKET);
        if (lbracket != null) {
            return propertyNode.findChildByType(JSElementTypes.EXPRESSIONS, lbracket);
        }
        return null;
    }

    @Override
    public ASTNode findNameIdentifier() {
        ASTNode refNode;
        ASTNode childNode;
        ASTNode identifier = super.findNameIdentifier();
        if (identifier != null) {
            return identifier;
        }
        ASTNode node = this.getNode();
        if (node.findChildByType(JSTokenTypes.COLON) == null && (childNode = node.getFirstChildNode()) != null && (refNode = TreeUtil.skipElements((ASTNode)childNode, (TokenSet)JSTokenTypes.COMMENTS_AND_WHITESPACES)) != null && refNode.getElementType() == JSElementTypes.REFERENCE_EXPRESSION) {
            return refNode;
        }
        return null;
    }

    public boolean isShorthanded() {
        return this.getNameIdentifier() == this.getValue();
    }

    public JSExpression getComputedPropertyName() {
        return this.tryGetComputedPropertyName();
    }
}

