/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.resolve;

import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportExportSpecifierBase;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.AccessibilityProcessingHandler;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.psi.impl.TypeScriptExternalModuleReferenceImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6PsiUtil {
    public static final TokenSet DECLARATIONS = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.EXPORT_DECLARATION});

    @NotNull
    public static Collection<PsiElement> getBindingAllPossibleExports(@NotNull PsiElement context, @NotNull Collection<PsiElement> elements) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "getBindingAllPossibleExports"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "getBindingAllPossibleExports"));
        }
        if (DialectDetector.isTypeScript(context)) {
            for (PsiElement element : elements) {
                TypeScriptExportAssignment assignment = TypeScriptPsiUtil.findExportAssignment(element);
                if (assignment == null) continue;
                ArrayList arrayList = ContainerUtil.newArrayList((Object[])new PsiElement[]{assignment});
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "getBindingAllPossibleExports"));
                }
                return arrayList;
            }
        }
        Collection<PsiElement> collection = elements;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "getBindingAllPossibleExports"));
        }
        return collection;
    }

    @Nullable
    public static JSElement findDefaultExport(@NotNull JSElement scopeElement) {
        if (scopeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeElement", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "findDefaultExport"));
        }
        Collection exportDefaultAssignments = JSStubBasedPsiTreeUtil.findDescendants((PsiElement)scopeElement, ES6ElementTypes.EXPORT_DEFAULT_ASSIGNMENT);
        if (!exportDefaultAssignments.isEmpty()) {
            return (JSElement)exportDefaultAssignments.iterator().next();
        }
        SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(new ResolveResultSink((PsiElement)scopeElement, "default"));
        processor.setLocalResolve(true);
        processor.setTypeContext(true);
        processor.getAccessibilityProcessingHandler().setAcceptOnlyExportedSymbols();
        JSResolveUtil.processDeclarationsInScope(scopeElement, processor, ResolveState.initial(), (PsiElement)scopeElement, (PsiElement)scopeElement);
        PsiElement result = processor.getResult();
        return result instanceof JSElement ? (JSElement)result : null;
    }

    public static boolean isAsyncContext(@Nullable JSFunction parent) {
        JSAttributeList attributeList;
        return parent != null && (attributeList = parent.getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.ASYNC);
    }

    public static boolean isGeneratorContext(@Nullable JSFunction parent) {
        if (parent != null) {
            return parent.isGenerator();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processExportNamespace(JSElement owner, PsiElement place, final ResolveProcessor processor) {
        PsiElement[] children;
        if (owner instanceof JSFile && !DialectDetector.isTypeScript((PsiElement)owner)) {
            GlobalSearchScope scope = GlobalSearchScope.fileScope((PsiFile)((JSFile)owner));
            Processor<JSPsiElementBase> namespaceMembersProcessor = new Processor<JSPsiElementBase>(){

                public boolean process(JSPsiElementBase base) {
                    return processor.execute((PsiElement)base, ResolveState.initial());
                }
            };
            boolean savedProcessingFromIndices = processor.isProcessingFromIndices();
            try {
                processor.setSkipImplicitDeclarations(true);
                JSClassResolver.getInstance().processNamespaceMembers("exports", scope, namespaceMembersProcessor);
                JSClassResolver.getInstance().processNamespaceMembers("module.exports", scope, namespaceMembersProcessor);
            }
            finally {
                processor.setSkipImplicitDeclarations(savedProcessingFromIndices);
            }
        }
        if ((children = JSStubBasedPsiTreeUtil.getChildrenByType(owner, DECLARATIONS)) == null) {
            return;
        }
        for (PsiElement child : children) {
            ES6FromClause clause;
            ES6ExportDeclaration declaration;
            if (!(child instanceof ES6ExportDeclaration) || !(declaration = (ES6ExportDeclaration)child).isExportAll() || (clause = declaration.getFromClause()) == null) continue;
            Collection<PsiElement> elements = ES6PsiUtil.getFromClauseResolvedReferences(clause);
            for (PsiElement element : elements) {
                if (!(element instanceof JSElement) || element.isEquivalentTo((PsiElement)owner)) continue;
                ES6PsiUtil.processExportDeclarationInScope((JSElement)element, processor, ResolveState.initial(), (PsiElement)element.getContainingFile(), place);
            }
        }
    }

    private static Collection<PsiElement> getFromClauseResolvedReferences(@NotNull ES6FromClause clause) {
        if (clause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clause", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "getFromClauseResolvedReferences"));
        }
        Collection elements = clause.resolveReferencedElements();
        ArrayList result = ContainerUtil.newArrayListWithCapacity((int)elements.size());
        for (PsiElement element : elements) {
            TypeScriptExportAssignment assignment = TypeScriptPsiUtil.findExportAssignment(element);
            if (assignment == null) {
                result.add(element);
                continue;
            }
            String name = assignment.getInitializerReference();
            if (name == null) continue;
            JSTypeResolveResult typeResolveResult = TypeScriptImportHandler.getInstance().resolveTypeName(name, (PsiElement)assignment);
            for (PsiElement psiElement : typeResolveResult.getElements()) {
                result.add(psiElement);
            }
        }
        return result;
    }

    public static void processSpecifier(@NotNull ES6ImportExportSpecifier specifier, @NotNull SinkResolveProcessor<? extends ResultSink> processor, @Nullable PsiElement defaultScope) {
        if (specifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processSpecifier"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processSpecifier"));
        }
        ES6ImportExportDeclaration declaration = specifier.getDeclaration();
        if (declaration == null) {
            return;
        }
        ES6FromClause clause = declaration.getFromClause();
        List scopes = null;
        if (clause != null) {
            scopes = ES6PsiUtil.getFromClauseResolvedReferences(clause);
        } else if (defaultScope != null && defaultScope instanceof JSElement) {
            scopes = ContainerUtil.createMaybeSingletonList((Object)defaultScope);
        }
        if (scopes == null) {
            return;
        }
        for (PsiElement scope : scopes) {
            if (!(scope instanceof JSElement)) continue;
            JSResolveUtil.processDeclarationsInScope((JSElement)scope, processor, ResolveState.initial(), (PsiElement)scope.getContainingFile(), (PsiElement)specifier);
            if (scope == defaultScope) continue;
            ES6PsiUtil.processExportNamespace((JSElement)scope, (PsiElement)specifier, processor);
        }
    }

    public static SinkResolveProcessor<? extends ResultSink> createSpecifierResolveProcessor(ES6ImportExportSpecifierBase specifier) {
        String name = specifier.getReferenceName();
        SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(new ResolveResultSink((PsiElement)specifier, name));
        processor.setLocalResolve(true);
        processor.setTypeContext(true);
        processor.setSkipImplicitDeclarations(true);
        return processor;
    }

    public static PsiReference[] calcImportExportFromClauseReferences(@NotNull PsiElement element, @Nullable PsiReferenceProvider provider) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "calcImportExportFromClauseReferences"));
        }
        Pair<String, PsiElement> pair = JSPsiImplUtils.getChildStringLiteralWithText(element);
        if (pair == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        return ES6PsiUtil.createImportExportFromClauseReferences(element, ((PsiElement)pair.second).getStartOffsetInParent() + 1, (String)pair.first, provider);
    }

    public static PsiReference[] createImportExportFromClauseReferences(@NotNull PsiElement host, int offset, @NotNull String text, @Nullable PsiReferenceProvider provider) {
        Object[] tsReferences;
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "createImportExportFromClauseReferences"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "createImportExportFromClauseReferences"));
        }
        String unquoted = StringUtil.unquoteString((String)text);
        Object[] result = PsiReference.EMPTY_ARRAY;
        for (JSModuleReferenceContributor contributor : (JSModuleReferenceContributor[])JSModuleReferenceContributor.EP_NAME.getExtensions()) {
            if (!contributor.isApplicable(host)) continue;
            Object[] references = contributor.getAllReferences(unquoted, host, offset, provider);
            result = (PsiReference[])ArrayUtil.mergeArrays((Object[])result, (Object[])references);
        }
        if (DialectDetector.isTypeScript(host) && (tsReferences = TypeScriptExternalModuleReferenceImpl.getExternalModuleReferences(host, text, offset)) != PsiReference.EMPTY_ARRAY) {
            result = (PsiReference[])ArrayUtil.mergeArrays((Object[])result, (Object[])tsReferences);
        }
        return result;
    }

    public static boolean processExportDeclarationInScope(@NotNull JSElement scope, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        PsiFile file;
        SinkResolveProcessor resolveProcessor;
        Object sink;
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportDeclarationInScope"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportDeclarationInScope"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportDeclarationInScope"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportDeclarationInScope"));
        }
        if (processor instanceof SinkResolveProcessor && ES6PsiUtil.shouldProcessES6ExportOnly(scope, place, sink = (resolveProcessor = (SinkResolveProcessor)processor).getResultSink(), file = place.getContainingFile())) {
            return ES6PsiUtil.processES6DeclarationsInScope(scope, processor, state, lastParent, place, resolveProcessor);
        }
        return JSResolveUtil.processDeclarationsInScope(scope, processor, state, lastParent, place);
    }

    public static boolean processES6DeclarationsInScope(@NotNull JSElement scope, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place, SinkResolveProcessor resolveProcessor) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processES6DeclarationsInScope"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processES6DeclarationsInScope"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processES6DeclarationsInScope"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processES6DeclarationsInScope"));
        }
        AccessibilityProcessingHandler handler = resolveProcessor.getAccessibilityProcessingHandler();
        boolean isExportOnly = handler.isAcceptOnlyExportedSymbols();
        handler.setAcceptOnlyExportedSymbols();
        boolean result = JSResolveUtil.processDeclarationsInScope(scope, processor, state, lastParent, place);
        ES6PsiUtil.processExportNamespace(scope, place, (ResolveProcessor)processor);
        handler.setAcceptOnlyExportedSymbols(isExportOnly);
        return result;
    }

    private static boolean shouldProcessES6ExportOnly(@NotNull JSElement scope, @NotNull PsiElement place, ResultSink sink, PsiFile file) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "shouldProcessES6ExportOnly"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "shouldProcessES6ExportOnly"));
        }
        if (sink.isTypeScript()) {
            return true;
        }
        return sink.isES6() && scope instanceof JSFile && !scope.isEquivalentTo((PsiElement)place.getContainingFile()) && file instanceof JSFile && ((JSFile)file).isCommonJSModule();
    }

    public static boolean isImportElement(PsiElement item) {
        return item instanceof ES6ImportedBinding || item instanceof ES6ImportSpecifierAlias || item instanceof TypeScriptImportStatement;
    }
}

