/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.JSInjectionController;
import com.intellij.lang.javascript.JSTargetedInjector;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.frameworks.jquery.JQueryCssLanguage;
import com.intellij.lang.javascript.inject.JSRegexpLanguage;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSLanguageInjector
implements MultiHostInjector,
JSTargetedInjector {
    @NonNls
    private static final String JAVASCRIPT_PREFIX = "javascript:";
    @NonNls
    public static final String JSP_URI = "http://java.sun.com/JSP/Page";
    private static final Language jsCssLanguage = JQueryCssLanguage.INSTANCE;
    private static final boolean regexpEnabled = LanguageParserDefinitions.INSTANCE.findSingle((Object)JSRegexpLanguage.INSTANCE) != null;
    private static final Pattern EXAMPLE_FILE_PATTERN = Pattern.compile("name=['\"](\\S+)['\"]");

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/lang/javascript/JSLanguageInjector", "getLanguagesToInject"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/JSLanguageInjector", "getLanguagesToInject"));
        }
        if (host instanceof XmlAttributeValue) {
            PsiElement attribute = host.getParent();
            PsiElement tag = attribute.getParent();
            if (attribute instanceof XmlAttribute && tag instanceof XmlTag) {
                if (host.getTextLength() == 0) {
                    return;
                }
                String attrName = ((XmlAttribute)attribute).getName();
                if (tag instanceof HtmlTag) {
                    attrName = attrName.toLowerCase();
                }
                if ("href".equals(attrName) && StringUtil.startsWithIgnoreCase((String)((XmlAttributeValue)host).getValue(), (String)JAVASCRIPT_PREFIX)) {
                    JSLanguageInjector.injectJSIntoAttributeValue(registrar, (XmlAttributeValue)host, true);
                }
            }
        } else if (host instanceof XmlText) {
            String name;
            XmlTag tag;
            String localName;
            PsiElement _tag = host.getParent();
            if (_tag instanceof XmlTag && "attribute".equals(localName = (tag = (XmlTag)_tag).getLocalName()) && JSP_URI.equals(tag.getNamespace()) && (name = tag.getAttributeValue("name")) != null && name.startsWith("on")) {
                JavascriptLanguage language = JavascriptLanguage.INSTANCE;
                JSLanguageInjector.injectToXmlText(registrar, host, (Language)language, null, null);
            }
        } else if (host instanceof JSLiteralExpression) {
            String text;
            int offset;
            JSLiteralExpression literalExpression = (JSLiteralExpression)host;
            if (literalExpression.isQuotedLiteral()) {
                if (JSInjectionController.willInjectJs(host)) {
                    JSInjectionController.JSQuotedLiteralInjector injector = new JSInjectionController.JSQuotedLiteralInjector((JSLiteralExpression)host);
                    registrar.startInjecting((Language)JavascriptLanguage.INSTANCE);
                    injector.addPlaces(registrar, null, null);
                    registrar.doneInjecting();
                } else if (JSInjectionController.willInjectHtml(host)) {
                    JSLanguageInjector.injectHtml(registrar, host);
                } else if (JSInjectionController.willInjectCss(host) && !JSInjectionController.hasOuterLanguage(host)) {
                    JSInjectionController.JSQuotedLiteralInjector injector = new JSInjectionController.JSQuotedLiteralInjector((JSLiteralExpression)host);
                    registrar.startInjecting(jsCssLanguage);
                    injector.addPlaces(registrar, null, "{}");
                    registrar.doneInjecting();
                }
            } else if (literalExpression.isRegExpLiteral() && regexpEnabled && (offset = (text = host.getText()).lastIndexOf(47)) > 1) {
                TextRange range = new TextRange(1, offset);
                registrar.startInjecting((Language)JSRegexpLanguage.INSTANCE).addPlace(null, null, (PsiLanguageInjectionHost)host, range).doneInjecting();
            }
        } else if (host instanceof JSDocComment) {
            int exampleStart;
            String text = host.getText();
            int exampleEnd = 0;
            do {
                exampleStart = text.indexOf("<example", exampleEnd);
                exampleEnd = text.indexOf("</example>", exampleStart);
                int i = exampleStart;
                while (i < exampleEnd && i > 0) {
                    String startLine;
                    Matcher matcher;
                    int headerLineEnd;
                    int fileEnd;
                    int fileStart = text.indexOf("<file", i);
                    int n = fileEnd = fileStart > 0 ? text.indexOf("</file>", fileStart) : -1;
                    if (fileStart > 0 && fileEnd > 0 && (headerLineEnd = text.indexOf(10, fileStart)) > 0 && headerLineEnd < fileEnd && (matcher = EXAMPLE_FILE_PATTERN.matcher(startLine = text.substring(fileStart, headerLineEnd))).find()) {
                        String filename = matcher.group(1);
                        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(filename);
                        if (fileType instanceof LanguageFileType) {
                            int lastLineEnd = text.lastIndexOf(10, fileEnd);
                            TextRange range = new TextRange(headerLineEnd + 1, lastLineEnd > headerLineEnd ? lastLineEnd + 1 : fileEnd);
                            registrar.startInjecting(((LanguageFileType)fileType).getLanguage()).addPlace("", "", (PsiLanguageInjectionHost)host, range).doneInjecting();
                        }
                    }
                    i = fileEnd;
                }
            } while (exampleStart >= 0 && exampleEnd >= 0);
        }
    }

    private static void injectHtml(final @NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/lang/javascript/JSLanguageInjector", "injectHtml"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/JSLanguageInjector", "injectHtml"));
        }
        PsiElement parent = host;
        while (parent.getParent() instanceof JSBinaryExpression || parent.getParent() instanceof JSParenthesizedExpression) {
            parent = parent.getParent();
        }
        registrar.startInjecting((Language)HTMLLanguage.INSTANCE);
        final Ref prevOffset = Ref.create();
        final int parentStart = parent.getTextRange().getStartOffset();
        final String text = parent.getText();
        parent.accept((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

            public void visitJSLiteralExpression(JSLiteralExpression node) {
                if (node.isQuotedLiteral()) {
                    Integer prev = (Integer)prevOffset.get();
                    String prefix = null;
                    TextRange range = node.getTextRange();
                    if (prev != null) {
                        prefix = text.substring(prev - parentStart, range.getStartOffset() - parentStart);
                        prefix = prefix.replaceAll("\\+\\s", "");
                    }
                    JSInjectionController.JSQuotedLiteralInjector injector = new JSInjectionController.JSQuotedLiteralInjector(node);
                    injector.addPlaces(registrar, prefix, null);
                    prevOffset.set((Object)range.getEndOffset());
                }
            }
        });
        registrar.doneInjecting();
        XmlHighlightVisitor.setSkipValidation((PsiElement)host);
    }

    public static void injectToXmlText(MultiHostRegistrar registrar, PsiElement host, Language language, String prefix, String suffix) {
        TextRange range = new TextRange(0, host.getTextLength());
        registrar.startInjecting(language).addPlace(prefix, suffix, (PsiLanguageInjectionHost)host, range).doneInjecting();
    }

    public static void injectJSIntoAttributeValue(MultiHostRegistrar registrar, XmlAttributeValue host, boolean startsWithPrefix) {
        PsiElement valueChild;
        PsiElement[] myChildren = host.getChildren();
        int valueIndex = myChildren.length - 2;
        int valueTokenNumber = 1;
        if (valueIndex < 0) {
            valueIndex = 0;
            valueTokenNumber = 0;
        }
        if ((valueChild = myChildren[valueIndex]) instanceof XmlToken && ((XmlToken)valueChild).getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
            SmartList ownTextRanges = new SmartList();
            TextRange range = new TextRange(valueTokenNumber + (startsWithPrefix ? JAVASCRIPT_PREFIX.length() : 0), host.getTextLength() - valueTokenNumber);
            if (range.getLength() < 0) {
                return;
            }
            ownTextRanges.add(range);
            if (valueIndex != valueTokenNumber) {
                int hostOffset = host.getTextRange().getStartOffset();
                for (int i = valueTokenNumber; i < valueIndex; ++i) {
                    TextRange rightRange;
                    PsiElement currentElement = myChildren[i];
                    if (!(currentElement instanceof OuterLanguageElement)) continue;
                    TextRange currentElementRange = currentElement.getTextRange().shiftRight(-hostOffset);
                    TextRange lastRange = (TextRange)ownTextRanges.remove(ownTextRanges.size() - 1);
                    TextRange leftRange = new TextRange(lastRange.getStartOffset(), currentElementRange.getStartOffset());
                    if (leftRange.getLength() > 0) {
                        ownTextRanges.add(leftRange);
                    }
                    if ((rightRange = new TextRange(currentElementRange.getEndOffset(), lastRange.getEndOffset())).getLength() <= 0) continue;
                    ownTextRanges.add(rightRange);
                }
            }
            JavascriptLanguage language = JavascriptLanguage.INSTANCE;
            registrar.startInjecting((Language)language);
            for (TextRange textRange : ownTextRanges) {
                registrar.addPlace(null, null, (PsiLanguageInjectionHost)host, textRange);
            }
            registrar.doneInjecting();
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(XmlText.class, XmlAttributeValue.class, JSLiteralExpression.class, JSDocComment.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSLanguageInjector", "elementsToInjectIn"));
        }
        return list;
    }
}

