/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSDocLexer;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript._JavaScriptLexer;
import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;

public class JavaScriptHighlightingLexer
extends LayeredLexer {
    private static final int MAX_LEVEL = 255;
    private static final String ESCAPES;

    public JavaScriptHighlightingLexer(DialectOptionHolder optionHolder, TokenSet htmlTokens, TokenSet htmlTokens2) {
        this(optionHolder, 0, htmlTokens, htmlTokens2);
    }

    private JavaScriptHighlightingLexer(DialectOptionHolder optionHolder, int level, final TokenSet htmlTokens, final TokenSet htmlTokens2) {
        super((Lexer)new JSFlexAdapter(new _JavaScriptLexer(true, optionHolder)));
        if (level < 255) {
            String escapes = !optionHolder.isECMA4 ? ESCAPES : "/";
            this.registerSelfStoppingLayer((Lexer)new StringLiteralLexer('\"', JSTokenTypes.STRING_LITERAL, true, escapes, !optionHolder.isECMA4, true), new IElementType[]{JSTokenTypes.STRING_LITERAL}, IElementType.EMPTY_ARRAY);
            this.registerSelfStoppingLayer((Lexer)new StringLiteralLexer('\uffff', JSTokenTypes.STRING_TEMPLATE_PART, true, escapes, !optionHolder.isECMA4, true), new IElementType[]{JSTokenTypes.STRING_TEMPLATE_PART}, IElementType.EMPTY_ARRAY);
            this.registerLayer((Lexer)new JavaScriptHighlightingLexer(optionHolder, level + 1, htmlTokens, htmlTokens2), new IElementType[]{JSTokenTypes.XML_JS_SCRIPT});
            this.registerSelfStoppingLayer((Lexer)new StringLiteralLexer('\'', JSTokenTypes.SINGLE_QUOTE_STRING_LITERAL, true, escapes, !optionHolder.isECMA4, true), new IElementType[]{JSTokenTypes.SINGLE_QUOTE_STRING_LITERAL}, IElementType.EMPTY_ARRAY);
            LayeredLexer docLexer = new LayeredLexer((Lexer)new JSDocLexer(true));
            Lexer lexer = JavaScriptHighlightingLexer.getHtmlHighlightingLexer();
            docLexer.registerLayer((Lexer)new DelegateLexer(lexer){
                final IElementType tagContentType;
                {
                    super(arg0);
                    this.tagContentType = JavaScriptHighlightingLexer.getTagContentTokenType();
                }

                public IElementType getTokenType() {
                    IElementType tokenType = super.getTokenType();
                    if (tokenType == this.tagContentType) {
                        return JSTokenTypes.JSDOC_TAG_DATA;
                    }
                    if (htmlTokens != null && htmlTokens.contains(tokenType)) {
                        return JSTokenTypes.JSDOC_MARKUP;
                    }
                    if (htmlTokens2 != null && htmlTokens2.contains(tokenType)) {
                        return JSTokenTypes.DOC_COMMENT;
                    }
                    return tokenType;
                }
            }, new IElementType[]{JSDocTokenTypes.DOC_COMMENT_DATA});
            this.registerSelfStoppingLayer((Lexer)docLexer, new IElementType[]{JSTokenTypes.DOC_COMMENT_TOKEN}, new IElementType[]{JSDocTokenTypes.DOC_COMMENT_END});
        }
    }

    public static IElementType getTagContentTokenType() {
        Lexer highlightingLexer = JavaScriptHighlightingLexer.getHtmlHighlightingLexer();
        highlightingLexer.start((CharSequence)"a");
        return highlightingLexer.getTokenType();
    }

    private static Lexer getHtmlHighlightingLexer() {
        return SyntaxHighlighterFactory.getSyntaxHighlighter((Language)HTMLLanguage.INSTANCE, null, null).getHighlightingLexer();
    }

    static {
        StringBuilder escapesBuilder = new StringBuilder("/");
        for (char c = '\u0001'; c < '\u00ad'; c = (char)(c + 1)) {
            if (c == 120 || c == 117 || Character.isDigit(c) || c == 10 || c == 13) continue;
            escapesBuilder.append(c);
        }
        ESCAPES = escapesBuilder.toString();
    }
}

