/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.javascript.bower.BowerCommandRun;
import com.intellij.lang.javascript.bower.BowerSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BowerCommandLineUtil {
    private static final Logger LOG = Logger.getInstance(BowerCommandLineUtil.class);

    private BowerCommandLineUtil() {
    }

    @NotNull
    public static String getBowerExecutableFilename() {
        String string = SystemInfo.isWindows ? "bower.cmd" : "bower";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerCommandLineUtil", "getBowerExecutableFilename"));
        }
        return string;
    }

    @NotNull
    public static ProcessOutput runBowerCommand(@NotNull BowerSettings settings, String ... commands) throws ExecutionException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/bower/BowerCommandLineUtil", "runBowerCommand"));
        }
        BowerCommandRun bowerCommandRun = BowerCommandLineUtil.startBowerCommand(settings, commands);
        ProcessOutput processOutput = bowerCommandRun.captureOutput(TimeUnit.MINUTES.toMillis(10L));
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerCommandLineUtil", "runBowerCommand"));
        }
        return processOutput;
    }

    @NotNull
    public static BowerCommandRun startBowerCommand(@NotNull BowerSettings settings, String ... commands) throws ExecutionException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/bower/BowerCommandLineUtil", "startBowerCommand"));
        }
        GeneralCommandLine commandLine = BowerCommandLineUtil.createCommandLine(settings);
        if (commandLine == null) {
            throw new ExecutionException("Bad parameters");
        }
        commandLine.addParameters(commands);
        LOG.info("Running bower command: " + commandLine.getCommandLineString());
        BowerCommandRun bowerCommandRun = new BowerCommandRun((OSProcessHandler)new KillableColoredProcessHandler(commandLine));
        if (bowerCommandRun == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerCommandLineUtil", "startBowerCommand"));
        }
        return bowerCommandRun;
    }

    @Nullable
    public static GeneralCommandLine createCommandLine(@NotNull BowerSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/bower/BowerCommandLineUtil", "createCommandLine"));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setCharset(CharsetToolkit.UTF8_CHARSET);
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        File bowerConfigFile = new File(settings.getBowerJsonPath());
        if (!bowerConfigFile.isFile()) {
            return null;
        }
        commandLine.setWorkDirectory(bowerConfigFile.getParentFile());
        if (SystemInfo.isWindows) {
            commandLine.setExePath(settings.getBowerExecutablePath());
        } else {
            commandLine.setExePath(settings.getNodeInterpreterPath());
            commandLine.addParameter(settings.getBowerExecutablePath());
        }
        return commandLine;
    }
}

