/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import org.jetbrains.annotations.NotNull;

public class BowerSettings {
    private final String myNodeInterpreterPath;
    private final String myBowerExecutablePath;
    private final String myBowerJsonPath;

    private BowerSettings(@NotNull String nodeInterpreterPath, @NotNull String bowerExecutablePath, @NotNull String bowerJsonPath) {
        if (nodeInterpreterPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeInterpreterPath", "com/intellij/lang/javascript/bower/BowerSettings", "<init>"));
        }
        if (bowerExecutablePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bowerExecutablePath", "com/intellij/lang/javascript/bower/BowerSettings", "<init>"));
        }
        if (bowerJsonPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bowerJsonPath", "com/intellij/lang/javascript/bower/BowerSettings", "<init>"));
        }
        this.myNodeInterpreterPath = nodeInterpreterPath;
        this.myBowerExecutablePath = bowerExecutablePath;
        this.myBowerJsonPath = bowerJsonPath;
    }

    @NotNull
    public String getNodeInterpreterPath() {
        String string = this.myNodeInterpreterPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerSettings", "getNodeInterpreterPath"));
        }
        return string;
    }

    @NotNull
    public String getBowerExecutablePath() {
        String string = this.myBowerExecutablePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerSettings", "getBowerExecutablePath"));
        }
        return string;
    }

    @NotNull
    public String getBowerJsonPath() {
        String string = this.myBowerJsonPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerSettings", "getBowerJsonPath"));
        }
        return string;
    }

    @NotNull
    public Builder createBuilder() {
        Builder builder = new Builder();
        builder.setNodeInterpreterPath(this.myNodeInterpreterPath);
        builder.setBowerExecutablePath(this.myBowerExecutablePath);
        builder.setBowerJsonPath(this.myBowerJsonPath);
        Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerSettings", "createBuilder"));
        }
        return builder2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BowerSettings settings = (BowerSettings)o;
        if (!this.myBowerJsonPath.equals(settings.myBowerJsonPath)) {
            return false;
        }
        if (!this.myBowerExecutablePath.equals(settings.myBowerExecutablePath)) {
            return false;
        }
        return this.myNodeInterpreterPath.equals(settings.myNodeInterpreterPath);
    }

    public int hashCode() {
        int result = this.myNodeInterpreterPath.hashCode();
        result = 31 * result + this.myBowerExecutablePath.hashCode();
        result = 31 * result + this.myBowerJsonPath.hashCode();
        return result;
    }

    public String toString() {
        return "nodeInterpreter='" + this.myNodeInterpreterPath + '\'' + ", bowerExecutable='" + this.myBowerExecutablePath + '\'' + ", bower.json='" + this.myBowerJsonPath + '\'';
    }

    public static class Builder {
        private String myNodeInterpreterPath = "";
        private String myBowerExecutablePath = "";
        private String myBowerJsonPath = "";

        @NotNull
        public Builder setNodeInterpreterPath(@NotNull String nodeInterpreterPath) {
            if (nodeInterpreterPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeInterpreterPath", "com/intellij/lang/javascript/bower/BowerSettings$Builder", "setNodeInterpreterPath"));
            }
            this.myNodeInterpreterPath = nodeInterpreterPath;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerSettings$Builder", "setNodeInterpreterPath"));
            }
            return builder;
        }

        @NotNull
        public Builder setBowerExecutablePath(@NotNull String bowerExecutablePath) {
            if (bowerExecutablePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bowerExecutablePath", "com/intellij/lang/javascript/bower/BowerSettings$Builder", "setBowerExecutablePath"));
            }
            this.myBowerExecutablePath = bowerExecutablePath;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerSettings$Builder", "setBowerExecutablePath"));
            }
            return builder;
        }

        @NotNull
        public Builder setBowerJsonPath(@NotNull String bowerJsonPath) {
            if (bowerJsonPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bowerJsonPath", "com/intellij/lang/javascript/bower/BowerSettings$Builder", "setBowerJsonPath"));
            }
            this.myBowerJsonPath = bowerJsonPath;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerSettings$Builder", "setBowerJsonPath"));
            }
            return builder;
        }

        public BowerSettings build() {
            return new BowerSettings(this.myNodeInterpreterPath, this.myBowerExecutablePath, this.myBowerJsonPath);
        }
    }
}

