/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools;

import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptConsoleHyperlinkInfo {
    private static final String PREFIX = ">> ";
    private final String myPath;
    private final int myDocumentLine;
    private final int myDocumentColumn;
    private final TextRange myHyperlinkRange;

    public TypeScriptConsoleHyperlinkInfo(@NotNull String path, int documentLine, int documentColumn, @NotNull TextRange hyperlinkRange) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/buildTools/TypeScriptConsoleHyperlinkInfo", "<init>"));
        }
        if (hyperlinkRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hyperlinkRange", "com/intellij/lang/javascript/buildTools/TypeScriptConsoleHyperlinkInfo", "<init>"));
        }
        this.myPath = path;
        this.myDocumentLine = documentLine;
        this.myDocumentColumn = documentColumn;
        this.myHyperlinkRange = hyperlinkRange;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/TypeScriptConsoleHyperlinkInfo", "getPath"));
        }
        return string;
    }

    public int getDocumentLine() {
        return this.myDocumentLine;
    }

    public int getDocumentColumn() {
        return this.myDocumentColumn;
    }

    @NotNull
    public TextRange getHyperlinkRange() {
        TextRange textRange = this.myHyperlinkRange;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/TypeScriptConsoleHyperlinkInfo", "getHyperlinkRange"));
        }
        return textRange;
    }

    @Nullable
    public static TypeScriptConsoleHyperlinkInfo parse(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/buildTools/TypeScriptConsoleHyperlinkInfo", "parse"));
        }
        TypeScriptConsoleHyperlinkInfo hyperlinkInfo = TypeScriptConsoleHyperlinkInfo.parse(line, '(', ')');
        if (hyperlinkInfo == null) {
            hyperlinkInfo = TypeScriptConsoleHyperlinkInfo.parse(line, '[', ']');
        }
        return hyperlinkInfo;
    }

    @Nullable
    public static TypeScriptConsoleHyperlinkInfo parse(@NotNull String line, char openBracketChar, char closeBracketChar) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/buildTools/TypeScriptConsoleHyperlinkInfo", "parse"));
        }
        int startInd = 0;
        int length = line.length();
        while (startInd < length) {
            int lineStartInd;
            int ind;
            int openParenthesesInd = line.indexOf(openBracketChar, startInd);
            if (openParenthesesInd == -1) {
                return null;
            }
            startInd = openParenthesesInd + 1;
            for (ind = lineStartInd = openParenthesesInd + 1; ind < length && Character.isDigit(line.charAt(ind)); ++ind) {
            }
            int lineEndInd = ind;
            if (lineStartInd == lineEndInd || lineEndInd < length && line.charAt(lineEndInd) != ',') continue;
            for (ind = lineEndInd + 1; ind < length && Character.isWhitespace(line.charAt(ind)); ++ind) {
            }
            int columnStartInd = ind;
            while (ind < length && Character.isDigit(line.charAt(ind))) {
                ++ind;
            }
            int columnEndInd = ind;
            if (columnStartInd == columnEndInd || columnEndInd + 1 >= length || line.charAt(columnEndInd) != closeBracketChar || line.charAt(columnEndInd + 1) != ':') continue;
            return TypeScriptConsoleHyperlinkInfo.create(line, lineStartInd, lineEndInd, columnStartInd, columnEndInd);
        }
        return null;
    }

    @Nullable
    private static TypeScriptConsoleHyperlinkInfo create(@NotNull String line, int lineStartInd, int lineEndInd, int columnStartInd, int columnEndInd) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/buildTools/TypeScriptConsoleHyperlinkInfo", "create"));
        }
        int pathStartOffset = 0;
        if (line.startsWith(PREFIX)) {
            pathStartOffset = PREFIX.length();
        }
        if (lineStartInd <= pathStartOffset) {
            return null;
        }
        String path = line.substring(pathStartOffset, lineStartInd - 1);
        try {
            int lineNumber = Integer.parseInt(line.substring(lineStartInd, lineEndInd));
            int columnNumber = Integer.parseInt(line.substring(columnStartInd, columnEndInd));
            return new TypeScriptConsoleHyperlinkInfo(path, lineNumber - 1, columnNumber - 1, TextRange.create((int)pathStartOffset, (int)(columnEndInd + 1)));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

