/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.buildTools.TreeCellHyperlink;
import com.intellij.lang.javascript.buildTools.TreeCellHyperlinkSupport;
import com.intellij.lang.javascript.buildTools.base.JsbtExecutor;
import com.intellij.lang.javascript.buildTools.base.JsbtFileListener;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtPersistentPath;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskListFetchFail;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskListingFailUtil;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.lang.javascript.buildTools.base.JsbtTree;
import com.intellij.lang.javascript.buildTools.base.JsbtTreeLayout;
import com.intellij.lang.javascript.buildTools.base.JsbtTreeLayoutManager;
import com.intellij.lang.javascript.buildTools.base.JsbtTreeUiState;
import com.intellij.lang.javascript.buildTools.base.actions.JsbtAddBuildfileAction;
import com.intellij.lang.javascript.buildTools.base.actions.JsbtRemoveBuildfileAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JsbtTaskTreeView
implements Disposable {
    private static final Logger LOG = Logger.getInstance(JsbtTaskTreeView.class);
    private static final String ROOT = "<root>";
    private final Project myProject;
    private final JsbtService myService;
    private final String myLayoutPlace;
    private final JsbtFileManager myBuildfileManager;
    private final DefaultMutableTreeNode myTreeRoot;
    private final DefaultTreeModel myTreeModel;
    private final Tree myTree;
    private final MyJsbtFileListener myListener;
    private int myActiveTaskReloadCount;
    private final CopyOnWriteArrayList<Runnable> myActionCallbacks;

    public JsbtTaskTreeView(@NotNull JsbtService service, @NotNull Project project, @Nullable String layoutPlace) {
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "<init>"));
        }
        this.myActiveTaskReloadCount = 0;
        this.myActionCallbacks = ContainerUtil.createEmptyCOWList();
        this.myProject = project;
        this.myService = service;
        this.myLayoutPlace = layoutPlace;
        this.myBuildfileManager = this.myService.getFileManager(project);
        this.myTreeRoot = new DefaultMutableTreeNode(ROOT, true);
        this.myTreeModel = new DefaultTreeModel(this.myTreeRoot, false);
        this.myTree = new JsbtTree(this.myTreeModel);
        this.myListener = new MyJsbtFileListener();
    }

    public void init() {
        this.myTree.setExpandsSelectedPaths(true);
        this.myTree.getEmptyText().setText(this.getEmptyText());
        this.myTree.setToggleClickCount(0);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new JsbtTreeCellRenderer()));
        this.myTree.setRootVisible(false);
        TreeUtil.expandAll((JTree)this.myTree);
        this.installSpeedSearch(this.myTree);
        TreeUtil.installActions((JTree)this.myTree);
        this.installPopupActions();
        this.myTree.setShowsRootHandles(true);
        this.myTree.putClientProperty((Object)"JTree.lineStyle", (Object)"None");
        this.myBuildfileManager.addListener(this.myListener, null);
        for (VirtualFile buildfile : this.myBuildfileManager.getBuildfiles()) {
            this.addBuildfile(buildfile);
        }
        this.restoreLayout();
        new UiNotifyConnector((Component)this.myTree, new Activatable(){
            private boolean myShowing = false;
            private boolean mySkipCached = false;

            public void showNotify() {
                if (!this.myShowing) {
                    JsbtTaskTreeView.this.reloadTasksForAllBuildfiles(true, this.mySkipCached);
                    this.myShowing = true;
                }
                this.mySkipCached = true;
            }

            public void hideNotify() {
                this.myShowing = false;
            }
        });
    }

    @NotNull
    private String getEmptyText() {
        Shortcut shortcut = JsbtAddBuildfileAction.getKeyboardShortcut();
        if (shortcut != null) {
            String string = "Add " + this.myService.getBuildfileCommonName() + " with " + KeymapUtil.getShortcutText((Shortcut)shortcut);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "getEmptyText"));
            }
            return string;
        }
        if ("No files added" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "getEmptyText"));
        }
        return "No files added";
    }

    protected abstract void addBuildfileChildren(@NotNull DefaultMutableTreeNode var1, @NotNull JsbtFileStructure var2);

    protected abstract boolean hasTaskNodes(@NotNull DefaultMutableTreeNode var1);

    protected abstract void customizeCell(@NotNull Project var1, @NotNull ColoredTreeCellRenderer var2, @NotNull DefaultMutableTreeNode var3);

    @Nullable
    protected abstract String getPersistentId(@NotNull DefaultMutableTreeNode var1);

    protected abstract String stringifyForSpeedSearch(@NotNull DefaultMutableTreeNode var1);

    @Nullable
    protected abstract JsbtTaskSet createTaskSetFromSelectedNodes();

    @Nullable
    protected abstract OpenFileDescriptor createJumpToSourceDescriptor(@NotNull Project var1, @NotNull DefaultMutableTreeNode var2);

    protected boolean isDebugAvailable() {
        return true;
    }

    @NotNull
    protected DefaultMutableTreeNode getRoot() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.myTreeRoot;
        if (defaultMutableTreeNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "getRoot"));
        }
        return defaultMutableTreeNode;
    }

    private void restoreLayout() {
        if (this.myLayoutPlace == null) {
            return;
        }
        JsbtTreeLayout layout = JsbtTreeLayoutManager.getInstance(this.myProject).getLayout(this.myLayoutPlace);
        if (layout == null) {
            return;
        }
        final Point viewPosition = layout.getScrollPaneViewPosition();
        if (viewPosition != null) {
            UiNotifyConnector.doWhenFirstShown((JComponent)this.myTree, (Runnable)new Runnable(){

                @Override
                public void run() {
                    JScrollPane scrollPane = (JScrollPane)UIUtil.getParentOfType(JScrollPane.class, (Component)JsbtTaskTreeView.this.myTree);
                    if (scrollPane != null) {
                        scrollPane.getViewport().setViewPosition(viewPosition);
                    }
                }
            });
        }
        for (JsbtPersistentPath path : layout.getSelectedPaths()) {
            TreeNode nodeToSelect = this.findNodeByPath(path);
            if (nodeToSelect == null) continue;
            this.myTree.addSelectionPath(TreeUtil.getPathFromRoot((TreeNode)nodeToSelect));
        }
    }

    private void saveLayout() {
        if (this.myLayoutPlace == null) {
            return;
        }
        Point scrollPaneViewPosition = null;
        JScrollPane scrollPane = (JScrollPane)UIUtil.getParentOfType(JScrollPane.class, (Component)this.myTree);
        if (scrollPane != null) {
            scrollPaneViewPosition = scrollPane.getViewport().getViewPosition();
        }
        List<DefaultMutableTreeNode> selectedNodes = this.getSelectedNodes();
        ArrayList selectedPaths = ContainerUtil.newArrayList();
        for (DefaultMutableTreeNode node : selectedNodes) {
            JsbtPersistentPath path = this.toPersistentPath(node);
            if (path == null) continue;
            selectedPaths.add(path);
        }
        JsbtTreeLayout layout = new JsbtTreeLayout(this.myLayoutPlace, scrollPaneViewPosition, selectedPaths);
        JsbtTreeLayoutManager.getInstance(this.myProject).add(layout);
    }

    @Nullable
    private JsbtPersistentPath toPersistentPath(@NotNull DefaultMutableTreeNode node) {
        TreeNode n;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "toPersistentPath"));
        }
        ArrayList ids = ContainerUtil.newArrayList();
        for (n = node; n != this.myTreeRoot && n instanceof DefaultMutableTreeNode; n = n.getParent()) {
            String id = this.getPersistentId((DefaultMutableTreeNode)n);
            if (id == null) {
                return null;
            }
            ids.add(id);
        }
        Collections.reverse(ids);
        return n == this.myTreeRoot ? new JsbtPersistentPath(ids) : null;
    }

    public void dispose() {
        this.saveLayout();
        this.myBuildfileManager.removeListener(this.myListener);
        this.myActionCallbacks.clear();
    }

    private void selectBuildfile(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfile", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "selectBuildfile"));
        }
        DefaultMutableTreeNode node = this.findBuildfileNode(buildfile);
        if (node != null) {
            DefaultMutableTreeNode child;
            TreePath path = TreeUtil.getPathFromRoot((TreeNode)node);
            this.myTree.setSelectionPath(path);
            TreePath scrollPath = path;
            if (this.myTree.isExpanded(path) && node.getChildCount() > 0 && (child = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)node.getChildAt(0), DefaultMutableTreeNode.class)) != null) {
                scrollPath = TreeUtil.getPathFromRoot((TreeNode)child);
            }
            this.myTree.scrollPathToVisible(scrollPath);
        }
    }

    public void addActionCallback(@NotNull Runnable callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "addActionCallback"));
        }
        this.myActionCallbacks.add(callback);
    }

    public void fireAction() {
        for (Runnable callback : this.myActionCallbacks) {
            callback.run();
        }
    }

    private void installSpeedSearch(@NotNull Tree tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "installSpeedSearch"));
        }
        new TreeSpeedSearch(tree, (Convertor)new Convertor<TreePath, String>(){

            public String convert(TreePath path) {
                DefaultMutableTreeNode node = JsbtTree.toNode(path);
                JsbtFileStructure structure = JsbtTree.getUserObject(node, JsbtFileStructure.class);
                if (structure != null) {
                    return structure.getBuildfile().getName();
                }
                if (node != null) {
                    return StringUtil.notNullize((String)JsbtTaskTreeView.this.stringifyForSpeedSearch(node));
                }
                return "";
            }
        }, true);
    }

    private void installPopupActions() {
        ArrayList actionList = ContainerUtil.newArrayList((Object[])new AnAction[]{new RunAction(), new DebugAction(), new EditRunSettingsAction(), new Separator(), new ShowTaskListSetting(), new JumpToSourceAction(), new ReloadTasks()});
        AnAction copyPathsAction = ActionManager.getInstance().getAction("CopyPaths");
        if (copyPathsAction != null) {
            actionList.add(copyPathsAction);
        }
        actionList.add(new JsbtRemoveBuildfileAction(this.myService, this));
        DefaultActionGroup actionGroup = new DefaultActionGroup((List)actionList);
        for (AnAction action : actionList) {
            ShortcutSet shortcutSet = action.getShortcutSet();
            if (shortcutSet == null) continue;
            action.registerCustomShortcutSet(shortcutSet, (JComponent)this.myTree);
        }
        PopupHandler.installPopupHandler((JComponent)this.myTree, (ActionGroup)actionGroup, (String)"JavaScriptBuildTool", (ActionManager)ActionManager.getInstance());
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                JsbtTaskSet taskSet;
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$4", "onClick"));
                }
                if (event.getButton() == 1 && clickCount == 2 && (taskSet = JsbtTaskTreeView.this.createTaskSetFromSelectedNodes()) != null) {
                    new JsbtExecutor(JsbtTaskTreeView.this.myProject, JsbtTaskTreeView.this.myService, taskSet).run();
                    JsbtTaskTreeView.this.fireAction();
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myTree);
    }

    @Nullable
    private DefaultMutableTreeNode findBuildfileNode(final @NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfile", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "findBuildfileNode"));
        }
        final Ref buildfileNodeRef = Ref.create(null);
        this.iterateBuildfileNodes(new Processor<DefaultMutableTreeNode>(){

            public boolean process(DefaultMutableTreeNode buildfileTreeNode) {
                JsbtFileStructure structure = JsbtTree.getUserObject(buildfileTreeNode, JsbtFileStructure.class);
                if (structure != null && structure.getBuildfile().equals(buildfile)) {
                    buildfileNodeRef.set((Object)buildfileTreeNode);
                    return false;
                }
                return true;
            }
        });
        return (DefaultMutableTreeNode)buildfileNodeRef.get();
    }

    public void reloadTasksForAllBuildfiles(final boolean silently, final boolean reloadFailedOnly) {
        this.iterateBuildfileNodes(new Processor<DefaultMutableTreeNode>(){

            public boolean process(DefaultMutableTreeNode buildfileTreeNode) {
                if (!reloadFailedOnly || JsbtTaskTreeView.getErrorInfo(buildfileTreeNode) != null) {
                    JsbtTaskTreeView.this.reloadTasksFor(buildfileTreeNode, silently);
                }
                return true;
            }
        });
    }

    private void iterateBuildfileNodes(@NotNull Processor<DefaultMutableTreeNode> processor) {
        DefaultMutableTreeNode buildfileTreeNode;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "iterateBuildfileNodes"));
        }
        int childCount = this.myTreeRoot.getChildCount();
        for (int i = 0; i < childCount && ((buildfileTreeNode = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)this.myTreeRoot.getChildAt(i), DefaultMutableTreeNode.class)) == null || processor.process((Object)buildfileTreeNode)); ++i) {
        }
    }

    private void addBuildfile(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfile", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "addBuildfile"));
        }
        if (!buildfile.isValid() || buildfile.isDirectory()) {
            return;
        }
        JsbtFileStructure structure = this.myBuildfileManager.getCachedStructure(buildfile);
        if (structure == null) {
            structure = this.myService.createEmptyFileStructure(buildfile);
        }
        DefaultMutableTreeNode buildfileTreeNode = new DefaultMutableTreeNode(structure, true);
        this.myTreeModel.insertNodeInto(buildfileTreeNode, this.myTreeRoot, this.myTreeRoot.getChildCount());
        this.setBuildfileChildren(buildfileTreeNode, structure, null);
        if (this.myTree.isShowing()) {
            this.reloadTasksFor(buildfileTreeNode, true);
        }
    }

    private void reloadTasksFor(final @NotNull DefaultMutableTreeNode buildfileTreeNode, boolean silently) {
        StructureFetchErrorInfo errorInfo;
        if (buildfileTreeNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfileTreeNode", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "reloadTasksFor"));
        }
        JsbtFileStructure structure = JsbtTree.getUserObject(buildfileTreeNode, JsbtFileStructure.class);
        if (structure == null) {
            LOG.warn("reloadTasksFor called on wrong tree node");
            return;
        }
        this.structureFetchStarted();
        boolean showLoadingNode = true;
        if (silently) {
            boolean bl = showLoadingNode = !this.hasTaskNodes(buildfileTreeNode);
        }
        if ((errorInfo = JsbtTaskTreeView.getErrorInfo(buildfileTreeNode)) != null) {
            JsbtTaskListingFailUtil.hideError(this.myProject, errorInfo.getException());
        }
        if (showLoadingNode) {
            boolean expand = buildfileTreeNode.getChildCount() == 0;
            buildfileTreeNode.removeAllChildren();
            buildfileTreeNode.add((MutableTreeNode)new LoadingNode());
            this.myTreeModel.nodeStructureChanged(buildfileTreeNode);
            if (expand) {
                this.expandNode(buildfileTreeNode);
            }
        }
        this.myBuildfileManager.fetchStructure(structure.getBuildfile(), new CatchingConsumer<JsbtFileStructure, JsbtTaskFetchException>(){

            public void consume(JsbtFileStructure structure) {
                JsbtTaskTreeView.this.setBuildfileChildren(buildfileTreeNode, structure, null);
                JsbtTaskTreeView.this.structureFetchDone();
            }

            public void consume(JsbtTaskFetchException e) {
                JsbtTaskTreeView.this.setBuildfileChildren(buildfileTreeNode, null, e);
                JsbtTaskTreeView.this.structureFetchDone();
            }
        });
    }

    @Nullable
    private static StructureFetchErrorInfo getErrorInfo(@NotNull DefaultMutableTreeNode buildfileTreeNode) {
        if (buildfileTreeNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfileTreeNode", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "getErrorInfo"));
        }
        int childCount = buildfileTreeNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)buildfileTreeNode.getChildAt(i), DefaultMutableTreeNode.class);
            StructureFetchErrorInfo errorInfo = StructureFetchErrorInfo.getUserObject(childNode);
            if (errorInfo == null) continue;
            return errorInfo;
        }
        return null;
    }

    private void structureFetchStarted() {
        if (this.myActiveTaskReloadCount == 0) {
            this.myTree.setPaintBusy(true);
        }
        ++this.myActiveTaskReloadCount;
    }

    private void structureFetchDone() {
        --this.myActiveTaskReloadCount;
        if (this.myActiveTaskReloadCount == 0) {
            this.myTree.setPaintBusy(false);
        }
    }

    private void setBuildfileChildren(@NotNull DefaultMutableTreeNode buildfileTreeNode, @Nullable JsbtFileStructure structure, @Nullable JsbtTaskFetchException e) {
        if (buildfileTreeNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfileTreeNode", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "setBuildfileChildren"));
        }
        if (structure == null && e == null) {
            LOG.error("Undefined structure and exception");
            return;
        }
        JsbtTreeUiState uiState = buildfileTreeNode.getChildCount() > 0 ? this.getUiState(buildfileTreeNode) : null;
        buildfileTreeNode.removeAllChildren();
        if (structure != null) {
            buildfileTreeNode.setUserObject(structure);
            this.addBuildfileChildren(buildfileTreeNode, structure);
        } else {
            buildfileTreeNode.setUserObject(this.myService.createEmptyFileStructure(e.getBuildfile()));
            buildfileTreeNode.add(new DefaultMutableTreeNode(new StructureFetchErrorInfo(this.myProject, e, this), false));
        }
        this.myTreeModel.nodeStructureChanged(buildfileTreeNode);
        if (uiState != null) {
            this.restoreUiState(uiState, buildfileTreeNode);
        } else {
            this.expandNode(buildfileTreeNode);
        }
    }

    @NotNull
    private JsbtTreeUiState getUiState(@NotNull DefaultMutableTreeNode root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "getUiState"));
        }
        JsbtTreeUiState state = new JsbtTreeUiState();
        this.addUiState(state, root, new JsbtPersistentPath(Collections.<String>emptyList()));
        JsbtTreeUiState jsbtTreeUiState = state;
        if (jsbtTreeUiState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "getUiState"));
        }
        return jsbtTreeUiState;
    }

    private void addUiState(@NotNull JsbtTreeUiState state, @NotNull TreeNode node, @NotNull JsbtPersistentPath path) {
        boolean expanded;
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "addUiState"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "addUiState"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "addUiState"));
        }
        if (node instanceof LoadingNode) {
            return;
        }
        TreePath treePath = TreeUtil.getPathFromRoot((TreeNode)node);
        if (this.myTree.isPathSelected(treePath)) {
            state.addSelectedPath(path);
        }
        if (!(expanded = this.myTree.isExpanded(treePath))) {
            state.addCollapsedPath(path);
        }
        if (expanded) {
            int childCount = node.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                String childId;
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)node.getChildAt(i), DefaultMutableTreeNode.class);
                String string = childId = child != null ? this.getPersistentId(child) : null;
                if (childId == null) continue;
                this.addUiState(state, child, path.createChildPath(childId));
            }
        }
    }

    private void restoreUiState(@NotNull JsbtTreeUiState state, @NotNull DefaultMutableTreeNode root) {
        TreeNode node;
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "restoreUiState"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "restoreUiState"));
        }
        for (JsbtPersistentPath path : state.getSelectedPaths()) {
            node = this.findNodeByPath(path, root);
            if (node == null) continue;
            this.myTree.addSelectionPath(TreeUtil.getPathFromRoot((TreeNode)node));
        }
        for (JsbtPersistentPath path : state.getCollapsedPaths()) {
            node = this.findNodeByPath(path, root);
            if (node == null) continue;
            this.myTree.collapsePath(TreeUtil.getPathFromRoot((TreeNode)node));
        }
    }

    @Nullable
    private TreeNode findNodeByPath(@NotNull JsbtPersistentPath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "findNodeByPath"));
        }
        return this.findNodeByPath(path, this.myTreeRoot);
    }

    @Nullable
    private TreeNode findNodeByPath(@NotNull JsbtPersistentPath path, @NotNull TreeNode root) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "findNodeByPath"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "findNodeByPath"));
        }
        TreeNode parent = root;
        for (String id : path.getIds()) {
            DefaultMutableTreeNode newParent = null;
            int childCount = parent.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                String childId;
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)parent.getChildAt(i), DefaultMutableTreeNode.class);
                String string = childId = child != null ? this.getPersistentId(child) : null;
                if (childId == null || !childId.equals(id)) continue;
                newParent = child;
                break;
            }
            if (newParent == null) {
                return null;
            }
            parent = newParent;
        }
        return parent;
    }

    private void expandNode(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "expandNode"));
        }
        this.myTree.expandPath(TreeUtil.getPathFromRoot((TreeNode)node));
    }

    public boolean isReloading() {
        return this.myActiveTaskReloadCount > 0;
    }

    @NotNull
    public JsbtService getService() {
        JsbtService jsbtService = this.myService;
        if (jsbtService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "getService"));
        }
        return jsbtService;
    }

    @NotNull
    public Tree getComponent() {
        Tree tree = this.myTree;
        if (tree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "getComponent"));
        }
        return tree;
    }

    @NotNull
    public List<DefaultMutableTreeNode> getSelectedNodes() {
        List<DefaultMutableTreeNode> list = JsbtTree.getSelectedNodes((JTree)this.myTree);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "getSelectedNodes"));
        }
        return list;
    }

    public void showError(@NotNull Project project, @NotNull JsbtTaskFetchException e) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "showError"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView", "showError"));
        }
        if (e.hasInvalidSettings()) {
            boolean ok = this.myService.showTaskListingSettingsDialog(project, e.getBuildfile());
            if (ok) {
                this.reloadTasksForAllBuildfiles(true, false);
            }
        } else {
            JsbtTaskListFetchFail fetchFail = e.getFetchFail();
            if (fetchFail != null) {
                JsbtTaskListingFailUtil.showError(project, fetchFail);
            } else {
                VirtualFile buildfile = e.getBuildfile();
                if (buildfile.isValid()) {
                    new OpenFileDescriptor(this.myProject, buildfile).navigate(true);
                } else {
                    PopupUtil.showBalloonForComponent((Component)this.myTree, (String)"No such file", (MessageType)MessageType.WARNING, (boolean)true, null);
                }
            }
        }
    }

    @Nullable
    private JsbtFileStructure getSelectedBuildfileStructure() {
        List<DefaultMutableTreeNode> nodes = this.getSelectedNodes();
        if (nodes.size() == 1) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)ContainerUtil.getFirstItem(nodes);
            return JsbtTree.getUserObject(node, JsbtFileStructure.class);
        }
        return null;
    }

    private class MyJsbtFileListener
    implements JsbtFileListener {
        private MyJsbtFileListener() {
        }

        @Override
        public void onBuildfileAdded(@NotNull VirtualFile buildfile) {
            if (buildfile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfile", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$MyJsbtFileListener", "onBuildfileAdded"));
            }
            JsbtTaskTreeView.this.addBuildfile(buildfile);
            JsbtTaskTreeView.this.selectBuildfile(buildfile);
        }

        @Override
        public void onBuildfileSelected(@NotNull VirtualFile buildfile) {
            if (buildfile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfile", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$MyJsbtFileListener", "onBuildfileSelected"));
            }
            JsbtTaskTreeView.this.selectBuildfile(buildfile);
        }

        @Override
        public void onBuildfileRemoved(@NotNull VirtualFile buildfile) {
            if (buildfile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfile", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$MyJsbtFileListener", "onBuildfileRemoved"));
            }
            DefaultMutableTreeNode buildfileNode = JsbtTaskTreeView.this.findBuildfileNode(buildfile);
            if (buildfileNode != null) {
                DefaultMutableTreeNode nodeToSelect = null;
                if (JsbtTaskTreeView.this.myTree.isPathSelected(TreeUtil.getPathFromRoot((TreeNode)buildfileNode)) && (nodeToSelect = buildfileNode.getNextSibling()) == null) {
                    nodeToSelect = buildfileNode.getPreviousSibling();
                }
                JsbtTaskTreeView.this.myTreeModel.removeNodeFromParent(buildfileNode);
                if (nodeToSelect != null) {
                    JsbtTaskTreeView.this.myTree.setSelectionPath(TreeUtil.getPathFromRoot((TreeNode)nodeToSelect));
                }
            }
        }
    }

    private class JsbtTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final TreeCellHyperlinkSupport myCellHyperlinkSupport;

        private JsbtTreeCellRenderer() {
            this.myCellHyperlinkSupport = TreeCellHyperlinkSupport.installOn((JTree)JsbtTaskTreeView.this.myTree);
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$JsbtTreeCellRenderer", "customizeCellRenderer"));
            }
            if (value instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                if (node instanceof LoadingNode) {
                    String text = (String)ObjectUtils.tryCast((Object)node.getUserObject(), String.class);
                    text = StringUtil.notNullize((String)text, (String)LoadingNode.getText());
                    this.append(text, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    return;
                }
                StructureFetchErrorInfo errorInfo = StructureFetchErrorInfo.getUserObject(node);
                if (errorInfo != null) {
                    this.setIcon(AllIcons.General.ExclMark);
                    this.setIconOnTheRight(false);
                    this.append("Failed to list tasks", SimpleTextAttributes.ERROR_ATTRIBUTES);
                    this.append("  ");
                    int style = 0;
                    if (this.myCellHyperlinkSupport.isMouseInsideHyperlink()) {
                        style |= 0x10;
                    }
                    boolean hyperlinkBoundsUndefined = errorInfo.getHyperlinkBounds() == null;
                    Dimension dimensionBefore = null;
                    if (hyperlinkBoundsUndefined) {
                        dimensionBefore = this.computePreferredSize(false);
                    }
                    this.append("details", new SimpleTextAttributes(null, PlatformColors.BLUE, null, style));
                    if (hyperlinkBoundsUndefined) {
                        Dimension dimensionAfter = this.computePreferredSize(false);
                        Rectangle b = new Rectangle(dimensionBefore.width, 0, dimensionAfter.width - dimensionBefore.width, dimensionAfter.height);
                        errorInfo.setHyperlinkBounds(b);
                    }
                } else {
                    JsbtTaskTreeView.this.customizeCell(JsbtTaskTreeView.this.myProject, this, node);
                }
            }
        }
    }

    private class ReloadTasks
    extends AnAction
    implements DumbAware {
        private ReloadTasks() {
            super(JsbtTaskTreeView.this.myService.getReloadTasksActionName(), null, AllIcons.Actions.Refresh);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$ReloadTasks", "update"));
            }
            JsbtFileStructure structure = JsbtTaskTreeView.this.getSelectedBuildfileStructure();
            e.getPresentation().setEnabledAndVisible(structure != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DefaultMutableTreeNode node;
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$ReloadTasks", "actionPerformed"));
            }
            List<DefaultMutableTreeNode> nodes = JsbtTaskTreeView.this.getSelectedNodes();
            if (nodes.size() == 1 && (node = (DefaultMutableTreeNode)ContainerUtil.getFirstItem(nodes)) != null) {
                JsbtTaskTreeView.this.reloadTasksFor(node, false);
            }
        }
    }

    private class JumpToSourceAction
    extends AnAction
    implements DumbAware {
        private static final String JUMP_TO_SOURCE = "Jump to Source";

        private JumpToSourceAction() {
            super(JUMP_TO_SOURCE, null, null);
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(115, 0)));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$JumpToSourceAction", "update"));
            }
            List<DefaultMutableTreeNode> nodes = JsbtTaskTreeView.this.getSelectedNodes();
            boolean enabled = false;
            if (nodes.size() == 1) {
                DefaultMutableTreeNode node = nodes.get(0);
                StructureFetchErrorInfo errorInfo = StructureFetchErrorInfo.getUserObject(node);
                if (errorInfo != null) {
                    e.getPresentation().setText("Show error details");
                    enabled = true;
                } else {
                    e.getPresentation().setText(JUMP_TO_SOURCE);
                    OpenFileDescriptor descriptor = this.createDescriptor(node);
                    if (descriptor != null) {
                        enabled = true;
                    }
                }
            }
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(enabled);
        }

        @Nullable
        private OpenFileDescriptor createDescriptor(@NotNull DefaultMutableTreeNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$JumpToSourceAction", "createDescriptor"));
            }
            JsbtFileStructure structure = JsbtTree.getUserObject(node, JsbtFileStructure.class);
            if (structure != null) {
                VirtualFile buildfile = structure.getBuildfile();
                return buildfile.isValid() ? new OpenFileDescriptor(JsbtTaskTreeView.this.myProject, buildfile) : null;
            }
            return JsbtTaskTreeView.this.createJumpToSourceDescriptor(JsbtTaskTreeView.this.myProject, node);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$JumpToSourceAction", "actionPerformed"));
            }
            List<DefaultMutableTreeNode> nodes = JsbtTaskTreeView.this.getSelectedNodes();
            if (nodes.size() == 1) {
                DefaultMutableTreeNode node = nodes.get(0);
                StructureFetchErrorInfo errorInfo = StructureFetchErrorInfo.getUserObject(node);
                if (errorInfo != null) {
                    JsbtTaskTreeView.this.showError(JsbtTaskTreeView.this.myProject, errorInfo.getException());
                } else {
                    OpenFileDescriptor descriptor = this.createDescriptor(node);
                    if (descriptor != null) {
                        descriptor.navigate(true);
                        JsbtTaskTreeView.this.fireAction();
                    }
                }
            }
        }
    }

    private class ShowTaskListSetting
    extends AnAction
    implements DumbAware {
        private ShowTaskListSetting() {
            super(JsbtTaskTreeView.this.myService.getName() + " Settings...", null, AllIcons.General.GearPlain);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$ShowTaskListSetting", "update"));
            }
            JsbtFileStructure structure = JsbtTaskTreeView.this.getSelectedBuildfileStructure();
            Presentation presentation = e.getPresentation();
            presentation.setEnabledAndVisible(structure != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$ShowTaskListSetting", "actionPerformed"));
            }
            JsbtFileStructure structure = JsbtTaskTreeView.this.getSelectedBuildfileStructure();
            if (structure != null) {
                JsbtTaskTreeView.this.myService.showTaskListingSettingsDialog(JsbtTaskTreeView.this.myProject, structure.getBuildfile());
            }
        }
    }

    private class EditRunSettingsAction
    extends AnAction
    implements DumbAware {
        private EditRunSettingsAction() {
            super("Edit", null, AllIcons.Actions.EditSource);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$EditRunSettingsAction", "update"));
            }
            JsbtTaskSet taskSet = JsbtTaskTreeView.this.createTaskSetFromSelectedNodes();
            Presentation presentation = e.getPresentation();
            presentation.setEnabledAndVisible(taskSet != null);
            if (taskSet != null) {
                presentation.setText("Edit '" + taskSet.getName() + "' settings...");
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$EditRunSettingsAction", "actionPerformed"));
            }
            JsbtTaskSet taskSet = JsbtTaskTreeView.this.createTaskSetFromSelectedNodes();
            if (taskSet != null) {
                JsbtExecutor executor = new JsbtExecutor(JsbtTaskTreeView.this.myProject, JsbtTaskTreeView.this.myService, taskSet);
                executor.editSettings();
            }
        }
    }

    private class DebugAction
    extends AnAction
    implements DumbAware {
        private DebugAction() {
            super("Debug", null, AllIcons.Actions.StartDebugger);
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(120, 3)));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$DebugAction", "update"));
            }
            if (!JsbtTaskTreeView.this.isDebugAvailable()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            JsbtTaskSet taskSet = JsbtTaskTreeView.this.createTaskSetFromSelectedNodes();
            e.getPresentation().setEnabledAndVisible(taskSet != null);
            if (taskSet != null) {
                e.getPresentation().setText("Debug '" + taskSet.getName() + "'");
                JsbtExecutor executor = new JsbtExecutor(JsbtTaskTreeView.this.myProject, JsbtTaskTreeView.this.myService, taskSet);
                e.getPresentation().setEnabled(executor.canDebug());
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$DebugAction", "actionPerformed"));
            }
            JsbtTaskSet taskSet = JsbtTaskTreeView.this.createTaskSetFromSelectedNodes();
            if (taskSet != null) {
                JsbtExecutor executor = new JsbtExecutor(JsbtTaskTreeView.this.myProject, JsbtTaskTreeView.this.myService, taskSet);
                executor.debug();
                JsbtTaskTreeView.this.fireAction();
            }
        }
    }

    private class RunAction
    extends AnAction
    implements DumbAware {
        private RunAction() {
            super("Run", null, AllIcons.Actions.Execute);
            this.setShortcutSet(CommonShortcuts.ENTER);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$RunAction", "update"));
            }
            JsbtTaskSet taskSet = JsbtTaskTreeView.this.createTaskSetFromSelectedNodes();
            e.getPresentation().setEnabledAndVisible(taskSet != null);
            if (taskSet != null) {
                e.getPresentation().setText("Run '" + taskSet.getName() + "'");
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$RunAction", "actionPerformed"));
            }
            JsbtTaskSet taskSet = JsbtTaskTreeView.this.createTaskSetFromSelectedNodes();
            if (taskSet != null) {
                new JsbtExecutor(JsbtTaskTreeView.this.myProject, JsbtTaskTreeView.this.myService, taskSet).run();
                JsbtTaskTreeView.this.fireAction();
            }
        }
    }

    public static class StructureFetchErrorInfo
    implements TreeCellHyperlink {
        private final Project myProject;
        private final JsbtTaskFetchException myException;
        private final JsbtTaskTreeView myTreeView;
        private Rectangle myHyperlinkBounds;

        public StructureFetchErrorInfo(@NotNull Project project, @NotNull JsbtTaskFetchException e, @NotNull JsbtTaskTreeView treeView) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$StructureFetchErrorInfo", "<init>"));
            }
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$StructureFetchErrorInfo", "<init>"));
            }
            if (treeView == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeView", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$StructureFetchErrorInfo", "<init>"));
            }
            this.myProject = project;
            this.myException = e;
            this.myTreeView = treeView;
        }

        @NotNull
        public JsbtTaskFetchException getException() {
            JsbtTaskFetchException jsbtTaskFetchException = this.myException;
            if (jsbtTaskFetchException == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$StructureFetchErrorInfo", "getException"));
            }
            return jsbtTaskFetchException;
        }

        @Override
        @NotNull
        public Runnable getClickHandler() {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    StructureFetchErrorInfo.this.myTreeView.showError(StructureFetchErrorInfo.this.myProject, StructureFetchErrorInfo.this.myException);
                }
            };
            if (runnable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtTaskTreeView$StructureFetchErrorInfo", "getClickHandler"));
            }
            return runnable;
        }

        @Override
        @Nullable
        public Rectangle getHyperlinkBounds() {
            return this.myHyperlinkBounds;
        }

        @Override
        @Nullable
        public String getToolTipText() {
            return "Click to show error details";
        }

        public void setHyperlinkBounds(Rectangle hyperlinkBounds) {
            this.myHyperlinkBounds = hyperlinkBounds;
        }

        @Nullable
        public static StructureFetchErrorInfo getUserObject(@Nullable DefaultMutableTreeNode node) {
            if (node == null) {
                return null;
            }
            return (StructureFetchErrorInfo)ObjectUtils.tryCast((Object)node.getUserObject(), StructureFetchErrorInfo.class);
        }
    }
}

