/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskTreeView;
import com.intellij.lang.javascript.buildTools.base.JsbtToolWindowPanel;
import com.intellij.lang.javascript.buildTools.base.actions.JsbtAddBuildfileAction;
import com.intellij.lang.javascript.buildTools.base.actions.JsbtReloadTasksAction;
import com.intellij.lang.javascript.buildTools.base.actions.JsbtRemoveBuildfileAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class JsbtToolWindowManager {
    private final Project myProject;
    private final String myToolWindowId;
    private final Icon myToolWindowIcon;
    private final String myHelpId;
    private final JsbtService myService;
    private ToolWindow myToolWindow;

    public JsbtToolWindowManager(@NotNull Project project, @NotNull String toolWindowId, @NotNull Icon toolWindowIcon, @NotNull String helpId, @NotNull JsbtService service) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtToolWindowManager", "<init>"));
        }
        if (toolWindowId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowId", "com/intellij/lang/javascript/buildTools/base/JsbtToolWindowManager", "<init>"));
        }
        if (toolWindowIcon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowIcon", "com/intellij/lang/javascript/buildTools/base/JsbtToolWindowManager", "<init>"));
        }
        if (helpId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helpId", "com/intellij/lang/javascript/buildTools/base/JsbtToolWindowManager", "<init>"));
        }
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/javascript/buildTools/base/JsbtToolWindowManager", "<init>"));
        }
        this.myProject = project;
        this.myToolWindowId = toolWindowId;
        this.myToolWindowIcon = toolWindowIcon;
        this.myHelpId = helpId;
        this.myService = service;
    }

    public void setAvailable() {
        AnAction[] titleActions;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myToolWindow != null) {
            return;
        }
        this.myToolWindow = JsbtToolWindowManager.createToolWindow(this.myProject, this.myToolWindowId, this.myToolWindowIcon);
        ContentManager contentManager = this.myToolWindow.getContentManager();
        JsbtTaskTreeView taskTreeView = this.myService.createTaskTreeView(this.myProject, null);
        taskTreeView.init();
        JsbtToolWindowPanel panel = new JsbtToolWindowPanel(this.myProject, taskTreeView, this.myHelpId);
        for (AnAction action : titleActions = new AnAction[]{new JsbtAddBuildfileAction(this.myService, false), new JsbtRemoveBuildfileAction(this.myService, taskTreeView), new JsbtReloadTasksAction(taskTreeView)}) {
            ShortcutSet shortcutSet = action.getShortcutSet();
            if (shortcutSet == null) continue;
            action.registerCustomShortcutSet(shortcutSet, (JComponent)taskTreeView.getComponent());
        }
        ToolWindowEx toolWindowEx = (ToolWindowEx)this.myToolWindow;
        toolWindowEx.setTitleActions(titleActions);
        toolWindowEx.setAdditionalGearActions((ActionGroup)new DefaultActionGroup(new AnAction[]{new ShowSettingsAction()}));
        Content content = contentManager.getFactory().createContent((JComponent)((Object)panel), "", true);
        content.setCloseable(false);
        content.setPreferredFocusableComponent(panel.getPreferredFocusedComponent());
        contentManager.addContent(content);
        contentManager.setSelectedContent(content);
        this.myToolWindow.setAvailable(true, null);
    }

    @NotNull
    private static ToolWindow createToolWindow(@NotNull Project project, @NotNull String id, @NotNull Icon icon) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtToolWindowManager", "createToolWindow"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/lang/javascript/buildTools/base/JsbtToolWindowManager", "createToolWindow"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/lang/javascript/buildTools/base/JsbtToolWindowManager", "createToolWindow"));
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).registerToolWindow(id, true, ToolWindowAnchor.LEFT, (Disposable)project, true, true);
        toolWindow.setToHideOnEmptyContent(true);
        toolWindow.setIcon(icon);
        ToolWindow toolWindow2 = toolWindow;
        if (toolWindow2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/JsbtToolWindowManager", "createToolWindow"));
        }
        return toolWindow2;
    }

    public void show(boolean alsoActivate) {
        this.setAvailable();
        this.myToolWindow.show(null);
        if (alsoActivate && !this.myToolWindow.isActive()) {
            this.myToolWindow.activate(null);
        }
    }

    private class ShowSettingsAction
    extends AnAction {
        public ShowSettingsAction() {
            super(JsbtToolWindowManager.this.myService.getName() + " Settings...", null, JsbtToolWindowManager.this.myService.getIcon());
        }

        public void actionPerformed(AnActionEvent e) {
            JsbtToolWindowManager.this.myService.showTaskListingSettingsDialog(JsbtToolWindowManager.this.myProject, null);
        }
    }
}

