/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt;

import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.grunt.GruntAliasTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntCoreTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntService;
import com.intellij.lang.javascript.buildTools.grunt.GruntTargetTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileStructure;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JsBuildToolGruntFileManager", storages={@Storage(file="$WORKSPACE_FILE$")})
public class GruntfileManager
extends JsbtFileManager
implements PersistentStateComponent<Element> {
    private static final String GRUNTFILE_TAG = "gruntfile";
    private static final String DETECTION_DONE_ATTR = "detection-done";
    private static final String PATH_ATTR = "path";
    private static final String ALIAS_TASK_TAG = "alias-task";
    private static final String TASK_NAME_ATTR = "name";
    private static final String TASK_INFO_ATTR = "info";
    private static final String TASK_FILE_PATH_ATTR = "file-path";
    private static final String MULTI_ATTR = "multi";
    private static final String ALIAS_TASK_DEPENDENCY_TAG = "dependency";
    private static final String CORE_TASK_TAG = "core-task";
    private static final String CORE_TASK_TARGET_TAG = "target";

    public GruntfileManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/GruntfileManager", "<init>"));
        }
        super(project, GruntService.getInstance());
    }

    public static GruntfileManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/GruntfileManager", "getInstance"));
        }
        return (GruntfileManager)ServiceManager.getService((Project)project, GruntfileManager.class);
    }

    @Override
    @Nullable
    public GruntfileStructure getCachedStructure(@NotNull VirtualFile gruntfile) {
        if (gruntfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", GRUNTFILE_TAG, "com/intellij/lang/javascript/buildTools/grunt/GruntfileManager", "getCachedStructure"));
        }
        return (GruntfileStructure)super.getCachedStructure(gruntfile);
    }

    public void fetchGruntStructure(@NotNull VirtualFile gruntfile, final @NotNull CatchingConsumer<GruntfileStructure, JsbtTaskFetchException> consumer) {
        if (gruntfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", GRUNTFILE_TAG, "com/intellij/lang/javascript/buildTools/grunt/GruntfileManager", "fetchGruntStructure"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/buildTools/grunt/GruntfileManager", "fetchGruntStructure"));
        }
        super.fetchStructure(gruntfile, new CatchingConsumer<JsbtFileStructure, JsbtTaskFetchException>(){

            public void consume(JsbtTaskFetchException e) {
                consumer.consume((Throwable)e);
            }

            public void consume(JsbtFileStructure structure) {
                consumer.consume((Object)((GruntfileStructure)structure));
            }
        });
    }

    @Nullable
    public Element getState() {
        Element parent = new Element("gruntfiles");
        if (this.isDetectionDone()) {
            parent.setAttribute(DETECTION_DONE_ATTR, Boolean.TRUE.toString());
        }
        for (VirtualFile buildfile : this.getBuildfiles()) {
            GruntfileStructure structure = (GruntfileStructure)ObjectUtils.tryCast((Object)this.getCachedStructure(buildfile), GruntfileStructure.class);
            Element gruntfileElement = new Element(GRUNTFILE_TAG);
            gruntfileElement.setAttribute(PATH_ATTR, buildfile.getPath());
            parent.addContent(gruntfileElement);
            if (structure == null) continue;
            for (GruntAliasTask gruntAliasTask : structure.getAliasTasks()) {
                gruntfileElement.addContent(GruntfileManager.aliasTaskToXml(gruntAliasTask));
            }
            for (GruntCoreTask gruntCoreTask : structure.getCoreTasks()) {
                gruntfileElement.addContent(GruntfileManager.coreTaskToXml(gruntCoreTask));
            }
        }
        return parent;
    }

    @NotNull
    private static Element aliasTaskToXml(@NotNull GruntAliasTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/lang/javascript/buildTools/grunt/GruntfileManager", "aliasTaskToXml"));
        }
        Element element = new Element(ALIAS_TASK_TAG);
        element.setAttribute(TASK_NAME_ATTR, task.getName());
        if (task.getInfo() != null) {
            element.setAttribute(TASK_INFO_ATTR, task.getInfo());
        }
        if (task.getFilePath() != null) {
            element.setAttribute(TASK_FILE_PATH_ATTR, task.getFilePath());
        }
        JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)element, (String)ALIAS_TASK_DEPENDENCY_TAG, task.getDependencies());
        Element element2 = element;
        if (element2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntfileManager", "aliasTaskToXml"));
        }
        return element2;
    }

    @NotNull
    private static Element coreTaskToXml(@NotNull GruntCoreTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/lang/javascript/buildTools/grunt/GruntfileManager", "coreTaskToXml"));
        }
        Element element = new Element(CORE_TASK_TAG);
        element.setAttribute(TASK_NAME_ATTR, task.getName());
        if (task.getInfo() != null) {
            element.setAttribute(TASK_INFO_ATTR, task.getInfo());
        }
        if (task.getFilePath() != null) {
            element.setAttribute(TASK_FILE_PATH_ATTR, task.getFilePath());
        }
        element.setAttribute(MULTI_ATTR, Boolean.toString(task.isMulti()));
        List targets = ContainerUtil.map(task.getTargetTasks(), (Function)new Function<GruntTargetTask, String>(){

            public String fun(GruntTargetTask task) {
                return task.getTargetName();
            }
        });
        JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)element, (String)CORE_TASK_TARGET_TAG, (List)targets);
        Element element2 = element;
        if (element2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntfileManager", "coreTaskToXml"));
        }
        return element2;
    }

    public void loadState(Element state) {
        if (state == null) {
            return;
        }
        this.clearAllBuildfiles();
        if (Boolean.parseBoolean(state.getAttributeValue(DETECTION_DONE_ATTR))) {
            this.setDetectionDone();
        }
        List elements = state.getChildren(GRUNTFILE_TAG);
        for (Element element : elements) {
            VirtualFile file;
            String path = element.getAttributeValue(PATH_ATTR);
            if (!StringUtil.isNotEmpty((String)path) || (file = LocalFileSystem.getInstance().findFileByPath(path)) == null || !file.isValid() || file.isDirectory()) continue;
            GruntfileStructure structure = new GruntfileStructure(file);
            ArrayList aliasTasks = ContainerUtil.newArrayList();
            for (Element aliasTaskElement : element.getChildren(ALIAS_TASK_TAG)) {
                GruntAliasTask aliasTask = GruntfileManager.createAliasTask(structure, aliasTaskElement);
                if (aliasTask == null) continue;
                aliasTasks.add(aliasTask);
            }
            ArrayList coreTasks = ContainerUtil.newArrayList();
            for (Element coreTaskElement : element.getChildren(CORE_TASK_TAG)) {
                GruntCoreTask coreTask = GruntfileManager.createCoreTask(structure, coreTaskElement);
                if (coreTask == null) continue;
                coreTasks.add(coreTask);
            }
            structure.setTasks(aliasTasks, coreTasks);
            this.addBuildfileStructure(structure);
        }
    }

    @Nullable
    private static GruntAliasTask createAliasTask(@NotNull GruntfileStructure structure, @NotNull Element aliasTaskElement) {
        if (structure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structure", "com/intellij/lang/javascript/buildTools/grunt/GruntfileManager", "createAliasTask"));
        }
        if (aliasTaskElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliasTaskElement", "com/intellij/lang/javascript/buildTools/grunt/GruntfileManager", "createAliasTask"));
        }
        String name = aliasTaskElement.getAttributeValue(TASK_NAME_ATTR);
        if (name != null) {
            String info = aliasTaskElement.getAttributeValue(TASK_INFO_ATTR);
            String filePath = aliasTaskElement.getAttributeValue(TASK_FILE_PATH_ATTR);
            boolean multi = Boolean.parseBoolean(aliasTaskElement.getAttributeValue(MULTI_ATTR));
            List dependencies = JDOMExternalizerUtil.getChildrenValueAttributes((Element)aliasTaskElement, (String)ALIAS_TASK_DEPENDENCY_TAG);
            return new GruntAliasTask(structure, name, info, filePath, multi, dependencies);
        }
        return null;
    }

    @Nullable
    private static GruntCoreTask createCoreTask(@NotNull GruntfileStructure structure, @NotNull Element coreTaskElement) {
        if (structure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structure", "com/intellij/lang/javascript/buildTools/grunt/GruntfileManager", "createCoreTask"));
        }
        if (coreTaskElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coreTaskElement", "com/intellij/lang/javascript/buildTools/grunt/GruntfileManager", "createCoreTask"));
        }
        String name = coreTaskElement.getAttributeValue(TASK_NAME_ATTR);
        if (name != null) {
            String info = coreTaskElement.getAttributeValue(TASK_INFO_ATTR);
            String filePath = coreTaskElement.getAttributeValue(TASK_FILE_PATH_ATTR);
            boolean multi = Boolean.parseBoolean(coreTaskElement.getAttributeValue(MULTI_ATTR));
            List targets = JDOMExternalizerUtil.getChildrenValueAttributes((Element)coreTaskElement, (String)CORE_TASK_TARGET_TAG);
            return new GruntCoreTask(structure, name, info, filePath, multi, targets);
        }
        return null;
    }
}

