/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt.rc;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeDetectionUtil;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntNonSharedSettings;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GruntNonSharedSettingsManager {
    private static final String STORAGE_NODE_INTERPRETER_PATH = "js.buildTools.grunt.node_interpreter";
    private static final String STORAGE_GRUNT_CLI_PACKAGE_DIR_PATH = "js.buildTools.grunt.grunt-cli.package";
    private final Project myProject;
    private volatile GruntNonSharedSettings myNonSharedSettings;

    public GruntNonSharedSettingsManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntNonSharedSettingsManager", "<init>"));
        }
        this.myNonSharedSettings = new GruntNonSharedSettings("", "");
        this.myProject = project;
    }

    @NotNull
    public GruntNonSharedSettings get(@Nullable VirtualFile contextGruntfile) {
        String gruntCliPackageDirPath;
        GruntNonSharedSettings settings = this.myNonSharedSettings;
        if (!StringUtil.isEmptyOrSpaces((String)settings.getNodeInterpreterPath()) && !StringUtil.isEmptyOrSpaces((String)settings.getGruntCliPackageDirPath())) {
            GruntNonSharedSettings gruntNonSharedSettings = settings;
            if (gruntNonSharedSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntNonSharedSettingsManager", "get"));
            }
            return gruntNonSharedSettings;
        }
        String nodeInterpreterPath = settings.getNodeInterpreterPath();
        if (StringUtil.isEmptyOrSpaces((String)nodeInterpreterPath)) {
            nodeInterpreterPath = StringUtil.notNullize((String)this.detectNodeInterpreter());
        }
        if (StringUtil.isEmptyOrSpaces((String)(gruntCliPackageDirPath = settings.getGruntCliPackageDirPath()))) {
            gruntCliPackageDirPath = StringUtil.notNullize((String)this.detectGruntCliPackageDirPath(nodeInterpreterPath, contextGruntfile));
        }
        this.myNonSharedSettings = settings = new GruntNonSharedSettings(nodeInterpreterPath, gruntCliPackageDirPath);
        GruntNonSharedSettings gruntNonSharedSettings = settings;
        if (gruntNonSharedSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntNonSharedSettingsManager", "get"));
        }
        return gruntNonSharedSettings;
    }

    @Nullable
    private String detectNodeInterpreter() {
        File nodeInterpreterFile;
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        String nodeInterpreterPath = propertiesComponent.getValue(STORAGE_NODE_INTERPRETER_PATH);
        if (StringUtil.isEmptyOrSpaces((String)nodeInterpreterPath) && (nodeInterpreterFile = NodeDetectionUtil.findInterpreterInPath()) != null) {
            nodeInterpreterPath = nodeInterpreterFile.getAbsolutePath();
        }
        return nodeInterpreterPath;
    }

    @Nullable
    private String detectGruntCliPackageDirPath(@NotNull String nodeInterpreterPath, @Nullable VirtualFile contextGruntfile) {
        if (nodeInterpreterPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeInterpreterPath", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntNonSharedSettingsManager", "detectGruntCliPackageDirPath"));
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        String gruntCliPackageDirPath = propertiesComponent.getValue(STORAGE_GRUNT_CLI_PACKAGE_DIR_PATH);
        if (StringUtil.isEmptyOrSpaces((String)gruntCliPackageDirPath)) {
            List<String> paths = this.detectAllGruntCliPackageDirPaths(nodeInterpreterPath, contextGruntfile);
            gruntCliPackageDirPath = (String)ContainerUtil.getFirstItem(paths);
        }
        return gruntCliPackageDirPath;
    }

    public void set(@NotNull String nodeInterpreterPath, @NotNull String gruntCliPackageDirPath) {
        if (nodeInterpreterPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeInterpreterPath", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntNonSharedSettingsManager", "set"));
        }
        if (gruntCliPackageDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gruntCliPackageDirPath", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntNonSharedSettingsManager", "set"));
        }
        this.myNonSharedSettings = new GruntNonSharedSettings(nodeInterpreterPath, gruntCliPackageDirPath);
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        propertiesComponent.setValue(STORAGE_NODE_INTERPRETER_PATH, nodeInterpreterPath);
        propertiesComponent.setValue(STORAGE_GRUNT_CLI_PACKAGE_DIR_PATH, gruntCliPackageDirPath);
    }

    @Nullable
    private NodeSettings getNodeSettings() {
        String nodeInterpreterPath = PropertiesComponent.getInstance((Project)this.myProject).getValue(STORAGE_NODE_INTERPRETER_PATH);
        if (!StringUtil.isEmptyOrSpaces((String)nodeInterpreterPath)) {
            return new NodeSettings(nodeInterpreterPath);
        }
        File nodeInterpreterFile = NodeDetectionUtil.findInterpreterInPath();
        if (nodeInterpreterFile != null) {
            return new NodeSettings(nodeInterpreterFile.getAbsolutePath());
        }
        return null;
    }

    @NotNull
    public List<String> detectAllGruntCliPackageDirPaths(@NotNull String nodeInterpreter, @Nullable VirtualFile contextGruntfile) {
        File nodeInterpreterFile;
        if (nodeInterpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeInterpreter", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntNonSharedSettingsManager", "detectAllGruntCliPackageDirPaths"));
        }
        ArrayList paths = ContainerUtil.newArrayList();
        NodeSettings nodeSettings = this.getNodeSettings();
        if ((nodeSettings == null || !nodeInterpreter.equals(nodeSettings.getInterpreterPath())) && (nodeInterpreterFile = new File(nodeInterpreter)).isFile() && nodeInterpreterFile.isAbsolute()) {
            nodeSettings = new NodeSettings(nodeInterpreter);
        }
        VirtualFile requester = contextGruntfile != null ? contextGruntfile : this.myProject.getBaseDir();
        ArrayList modules = ContainerUtil.newArrayList();
        NodeModuleSearchUtil.findModulesWithName(modules, "grunt-cli", requester, nodeSettings, true);
        for (CompletionModuleInfo module : modules) {
            VirtualFile dir = module.getVirtualFile();
            if (dir == null || !dir.isDirectory()) continue;
            paths.add(FileUtil.toSystemDependentName((String)dir.getPath()));
        }
        ArrayList arrayList = paths;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntNonSharedSettingsManager", "detectAllGruntCliPackageDirPaths"));
        }
        return arrayList;
    }

    @NotNull
    public static GruntNonSharedSettingsManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntNonSharedSettingsManager", "getInstance"));
        }
        GruntNonSharedSettingsManager gruntNonSharedSettingsManager = (GruntNonSharedSettingsManager)ServiceManager.getService((Project)project, GruntNonSharedSettingsManager.class);
        if (gruntNonSharedSettingsManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntNonSharedSettingsManager", "getInstance"));
        }
        return gruntNonSharedSettingsManager;
    }
}

