/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt.rc;

import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.javascript.nodejs.NodeUIUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.base.ComponentWithEmptyBrowseButton;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.grunt.GruntService;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileManager;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileStructure;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntNonSharedSettings;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntNonSharedSettingsManager;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunConfiguration;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.NotNullProducer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GruntRunConfigurationEditor
extends SettingsEditor<GruntRunConfiguration> {
    private static final Logger LOG = Logger.getInstance(GruntRunConfigurationEditor.class);
    private final Project myProject;
    private final TextFieldWithHistoryWithBrowseButton myGruntfileTextFieldWithBrowseButton;
    private final TextFieldWithHistory myTasksField;
    private final JCheckBox myForceCheckbox;
    private final JCheckBox myVerboseCheckbox;
    private final TextFieldWithHistoryWithBrowseButton myNodeInterpreterTextFieldWithBrowseButton;
    private final RawCommandLineEditor myNodeOptionsEditor;
    private final TextFieldWithHistoryWithBrowseButton myGruntCliPackageDirTextFieldWithBrowseButton;
    private final EnvironmentVariablesTextFieldWithBrowseButton myEnvVarsComponent;
    private final JPanel myPanel;

    public GruntRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfigurationEditor", "<init>"));
        }
        this.myProject = project;
        this.myGruntfileTextFieldWithBrowseButton = GruntRunConfigurationEditor.createGruntfileFieldWithBrowseButton(project);
        this.myTasksField = this.createTasksField();
        this.myForceCheckbox = new JCheckBox("Force execution (--force)");
        this.myVerboseCheckbox = new JCheckBox("Verbose mode (--verbose)");
        this.myNodeInterpreterTextFieldWithBrowseButton = NodeUIUtil.createNodeInterpreterTextField(project);
        this.myNodeOptionsEditor = GruntRunConfigurationEditor.createNodeOptionsEditor();
        this.myGruntCliPackageDirTextFieldWithBrowseButton = GruntRunConfigurationEditor.createGruntPackageDirTextFieldWithBrowseButton(project, ((TextFieldWithHistory)this.myNodeInterpreterTextFieldWithBrowseButton.getChildComponent()).getTextEditor(), null);
        this.myEnvVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.myPanel = FormBuilder.createFormBuilder().setAlignLabelOnRight(false).setHorizontalGap(10).setVerticalGap(4).addLabeledComponent(JSBundle.message((String)"grunt.rc.gruntfile.label", (Object[])new Object[0]), (JComponent)this.myGruntfileTextFieldWithBrowseButton).addLabeledComponent(JSBundle.message((String)"grunt.rc.tasks.label", (Object[])new Object[0]), ComponentWithEmptyBrowseButton.wrap(this.myTasksField)).addLabeledComponent("", GruntRunConfigurationEditor.createCheckboxPanel(this.myForceCheckbox, this.myVerboseCheckbox)).addComponent((JComponent)new JSeparator(), 8).addLabeledComponent(JSBundle.message((String)"grunt.rc.nodeInterpreter.label", (Object[])new Object[0]), (JComponent)this.myNodeInterpreterTextFieldWithBrowseButton, 8).addLabeledComponent(JSBundle.message((String)"grunt.rc.nodeOptions.label", (Object[])new Object[0]), (JComponent)this.myNodeOptionsEditor).addLabeledComponent(JSBundle.message((String)"grunt.rc.gruntCliPackage.label", (Object[])new Object[0]), (JComponent)this.myGruntCliPackageDirTextFieldWithBrowseButton).addLabeledComponent(JSBundle.message((String)"grunt.rc.environmentVariables.label", (Object[])new Object[0]), (JComponent)this.myEnvVarsComponent).getPanel();
    }

    @NotNull
    private static JComponent createCheckboxPanel(@NotNull JCheckBox left, @NotNull JCheckBox right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfigurationEditor", "createCheckboxPanel"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfigurationEditor", "createCheckboxPanel"));
        }
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        panel.add(left);
        panel.add(Box.createHorizontalStrut(20));
        panel.add(right);
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfigurationEditor", "createCheckboxPanel"));
        }
        return jPanel;
    }

    @NotNull
    public static TextFieldWithHistoryWithBrowseButton createGruntPackageDirTextFieldWithBrowseButton(final @NotNull Project project, final @NotNull JTextField nodeInterpreterField, final @Nullable VirtualFile contextGruntfile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfigurationEditor", "createGruntPackageDirTextFieldWithBrowseButton"));
        }
        if (nodeInterpreterField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeInterpreterField", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfigurationEditor", "createGruntPackageDirTextFieldWithBrowseButton"));
        }
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)JSBundle.message((String)"grunt.rc.gruntCliPackage.browseDialogTitle", (Object[])new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor(), (NotNullProducer)new NotNullProducer<List<String>>(){

            @NotNull
            public List<String> produce() {
                List<String> dirs = GruntNonSharedSettingsManager.getInstance(project).detectAllGruntCliPackageDirPaths(nodeInterpreterField.getText(), contextGruntfile);
                Collections.sort(dirs);
                List<String> list = dirs;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfigurationEditor$1", "produce"));
                }
                return list;
            }
        });
        if (textFieldWithHistoryWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfigurationEditor", "createGruntPackageDirTextFieldWithBrowseButton"));
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    @NotNull
    public static RawCommandLineEditor createNodeOptionsEditor() {
        RawCommandLineEditor editor = new RawCommandLineEditor();
        editor.setDialogCaption("Node Options");
        RawCommandLineEditor rawCommandLineEditor = editor;
        if (rawCommandLineEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfigurationEditor", "createNodeOptionsEditor"));
        }
        return rawCommandLineEditor;
    }

    @NotNull
    private static TextFieldWithHistoryWithBrowseButton createGruntfileFieldWithBrowseButton(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfigurationEditor", "createGruntfileFieldWithBrowseButton"));
        }
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)JSBundle.message((String)"grunt.rc.gruntfile.browseDialogTitle", (Object[])new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleLocalFileDescriptor(), (NotNullProducer)new NotNullProducer<List<String>>(){

            @NotNull
            public List<String> produce() {
                LinkedHashSet files = ContainerUtil.newLinkedHashSet();
                files.addAll(GruntService.getInstance().detectAllBuildfiles(project));
                files.addAll(GruntfileManager.getInstance(project).getBuildfiles());
                ArrayList filePaths = ContainerUtil.newArrayListWithCapacity((int)files.size());
                for (VirtualFile file : files) {
                    filePaths.add(FileUtil.toSystemDependentName((String)file.getPath()));
                }
                Collections.sort(filePaths);
                ArrayList arrayList = filePaths;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfigurationEditor$2", "produce"));
                }
                return arrayList;
            }
        });
        if (textFieldWithHistoryWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfigurationEditor", "createGruntfileFieldWithBrowseButton"));
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    @NotNull
    private TextFieldWithHistory createTasksField() {
        final TextFieldWithHistory field = new TextFieldWithHistory();
        field.setMinimumAndPreferredWidth(0);
        field.setHistorySize(-1);
        final Ref lastGruntfileRef = Ref.create();
        field.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                final VirtualFile gruntfile = LocalFileSystem.getInstance().findFileByPath(((TextFieldWithHistory)GruntRunConfigurationEditor.this.myGruntfileTextFieldWithBrowseButton.getChildComponent()).getText());
                if (gruntfile == null || !gruntfile.isValid() || gruntfile.isDirectory()) {
                    SwingHelper.setHistory((TextFieldWithHistory)field, Collections.emptyList(), (boolean)false);
                    lastGruntfileRef.set(null);
                    return;
                }
                if (gruntfile.equals(lastGruntfileRef.get())) {
                    return;
                }
                lastGruntfileRef.set((Object)gruntfile);
                GruntfileManager gruntfileManager = GruntfileManager.getInstance(GruntRunConfigurationEditor.this.myProject);
                GruntfileStructure structure = gruntfileManager.getCachedStructure(gruntfile);
                if (structure != null) {
                    SwingHelper.setHistory((TextFieldWithHistory)field, JsbtUtil.encodeNames(structure.getTaskNames()), (boolean)false);
                } else {
                    gruntfileManager.fetchGruntStructure(gruntfile, new CatchingConsumer<GruntfileStructure, JsbtTaskFetchException>(){

                        public void consume(GruntfileStructure structure) {
                            List<String> taskNames = structure.getTaskNames();
                            field.setHistory(JsbtUtil.encodeNames(taskNames));
                        }

                        public void consume(JsbtTaskFetchException e) {
                            SwingHelper.setHistory((TextFieldWithHistory)field, Collections.emptyList(), (boolean)false);
                            LOG.warn("Cannot load grunt tasks for " + gruntfile.getPath(), (Throwable)e);
                        }
                    });
                }
            }
        });
        TextFieldWithHistory textFieldWithHistory = field;
        if (textFieldWithHistory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfigurationEditor", "createTasksField"));
        }
        return textFieldWithHistory;
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }

    protected void resetEditorFrom(GruntRunConfiguration gruntRc) {
        GruntRunSettings runSettings = gruntRc.getRunSettings();
        GruntNonSharedSettings nonSharedSettings = GruntNonSharedSettingsManager.getInstance(this.myProject).get(gruntRc.getGruntfile());
        this.myNodeInterpreterTextFieldWithBrowseButton.setText(nonSharedSettings.getNodeInterpreterPath());
        this.myNodeOptionsEditor.setText(runSettings.getNodeOptions());
        this.myGruntCliPackageDirTextFieldWithBrowseButton.setTextAndAddToHistory(nonSharedSettings.getGruntCliPackageDirPath());
        this.myGruntfileTextFieldWithBrowseButton.setTextAndAddToHistory(runSettings.getGruntfilePath());
        this.myTasksField.setTextAndAddToHistory(ParametersListUtil.join(runSettings.getTasks()));
        this.myForceCheckbox.setSelected(runSettings.isForceExecution());
        this.myVerboseCheckbox.setSelected(runSettings.isVerboseMode());
        this.myEnvVarsComponent.setData(runSettings.getEnvData());
        SwingHelper.resizeDialogToFitTextFor((JComponent[])new JComponent[]{this.myGruntfileTextFieldWithBrowseButton, this.myNodeInterpreterTextFieldWithBrowseButton, this.myGruntCliPackageDirTextFieldWithBrowseButton});
    }

    protected void applyEditorTo(GruntRunConfiguration gruntRc) throws ConfigurationException {
        GruntNonSharedSettingsManager.getInstance(this.myProject).set(((TextFieldWithHistory)this.myNodeInterpreterTextFieldWithBrowseButton.getChildComponent()).getText(), ((TextFieldWithHistory)this.myGruntCliPackageDirTextFieldWithBrowseButton.getChildComponent()).getText());
        GruntRunSettings.Builder builder = new GruntRunSettings.Builder();
        builder.setNodeOptions(this.myNodeOptionsEditor.getText());
        builder.setGruntfilePath(((TextFieldWithHistory)this.myGruntfileTextFieldWithBrowseButton.getChildComponent()).getText());
        List tasks = Collections.emptyList();
        String tasksText = this.myTasksField.getText();
        if (!StringUtil.isEmptyOrSpaces((String)tasksText)) {
            tasks = ParametersListUtil.parse((String)tasksText);
        }
        builder.setTasks(tasks);
        builder.setForceExecution(this.myForceCheckbox.isSelected());
        builder.setVerboseMode(this.myVerboseCheckbox.isSelected());
        builder.setEnvData(this.myEnvVarsComponent.getData());
        gruntRc.setRunSettings(builder.build());
    }
}

