/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp;

import com.google.common.collect.ImmutableList;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.gulp.GulpTask;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpfileStructure
extends JsbtFileStructure {
    private final VirtualFile myGulpfile;
    private volatile ImmutableList<GulpTask> myTasks;

    public GulpfileStructure(@NotNull VirtualFile gulpfile) {
        if (gulpfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gulpfile", "com/intellij/lang/javascript/buildTools/gulp/GulpfileStructure", "<init>"));
        }
        super(gulpfile);
        this.myTasks = ImmutableList.of();
        this.myGulpfile = gulpfile;
    }

    public void setTasks(@NotNull List<GulpTask> tasks) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/intellij/lang/javascript/buildTools/gulp/GulpfileStructure", "setTasks"));
        }
        this.myTasks = ImmutableList.copyOf(tasks);
    }

    @NotNull
    public VirtualFile getGulpfile() {
        VirtualFile virtualFile = this.myGulpfile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpfileStructure", "getGulpfile"));
        }
        return virtualFile;
    }

    @NotNull
    public List<GulpTask> getTasks() {
        ImmutableList<GulpTask> immutableList = this.myTasks;
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpfileStructure", "getTasks"));
        }
        return immutableList;
    }

    @Override
    @NotNull
    public List<String> getTaskNames() {
        List list = ContainerUtil.map(this.myTasks, (Function)new Function<GulpTask, String>(){

            public String fun(GulpTask task) {
                return task.getName();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpfileStructure", "getTaskNames"));
        }
        return list;
    }

    @Nullable
    public static GulpfileStructure getUserObject(@Nullable DefaultMutableTreeNode node) {
        if (node == null) {
            return null;
        }
        return (GulpfileStructure)ObjectUtils.tryCast((Object)node.getUserObject(), GulpfileStructure.class);
    }
}

