/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp.codeInsight;

import com.google.common.collect.ImmutableMap;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.buildTools.JSPsiUtil;
import com.intellij.lang.javascript.buildTools.gulp.codeInsight.NodeRequireDirCall;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpfilePsiStructure {
    private static final Key<CachedValue<GulpfilePsiStructure>> KEY = Key.create((String)GulpfilePsiStructure.class.getName());
    private final Map<String, JSCallExpression> myPsiByNameMap;

    public GulpfilePsiStructure(@NotNull Map<String, JSCallExpression> psiByNameMap) {
        if (psiByNameMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiByNameMap", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "<init>"));
        }
        this.myPsiByNameMap = ImmutableMap.copyOf(psiByNameMap);
    }

    @Nullable
    public JSCallExpression getPsiByName(@NotNull String taskName) {
        if (taskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "getPsiByName"));
        }
        return this.myPsiByNameMap.get(taskName);
    }

    @NotNull
    public Collection<String> getTasks() {
        Set<String> set = this.myPsiByNameMap.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "getTasks"));
        }
        return set;
    }

    @NotNull
    private static GulpfilePsiStructure build(@NotNull JSFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "build"));
        }
        HashMap taskNameToPsiMap = ContainerUtil.newHashMap();
        List statements = JsPsiUtils.listStatementsInExecutionOrder((JSFile)file);
        HashSet requireDirVarNames = ContainerUtil.newHashSet();
        GulpfilePsiStructure.collectImports(file, requireDirVarNames);
        for (JSStatement statement : statements) {
            JSCallExpression callExpression = JSPsiUtil.getCallExpression((PsiElement)statement);
            if (callExpression != null) {
                String taskName = GulpfilePsiStructure.getGulpTaskName(callExpression);
                if (taskName != null) {
                    taskNameToPsiMap.put(taskName, callExpression);
                    continue;
                }
                GulpfilePsiStructure.processRequireDirCall(file, callExpression, requireDirVarNames, taskNameToPsiMap);
                GulpfilePsiStructure.processFileRequireCall(file, callExpression, taskNameToPsiMap);
                GulpfilePsiStructure.processFileRequireCall2(file, callExpression, taskNameToPsiMap);
                continue;
            }
            if (!(statement instanceof JSVarStatement)) continue;
            JSVarStatement varStatement = (JSVarStatement)statement;
            for (JSVariable variable : varStatement.getVariables()) {
                GulpfilePsiStructure.processVariable(file, variable, requireDirVarNames, taskNameToPsiMap);
            }
        }
        GulpfilePsiStructure gulpfilePsiStructure = new GulpfilePsiStructure(taskNameToPsiMap);
        if (gulpfilePsiStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "build"));
        }
        return gulpfilePsiStructure;
    }

    private static void collectImports(@NotNull JSFile file, @NotNull Set<String> requireDirVarNames) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "collectImports"));
        }
        if (requireDirVarNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requireDirVarNames", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "collectImports"));
        }
        DialectOptionHolder holder = DialectDetector.dialectOfFile((PsiFile)file);
        if (holder != null && holder.isECMA6) {
            PsiElement[] children;
            for (PsiElement child : children = file.getChildren()) {
                String name;
                ES6ImportDeclaration decl;
                ES6FromClause fromClause;
                if (!(child instanceof ES6ImportDeclaration) || (fromClause = (decl = (ES6ImportDeclaration)child).getFromClause()) == null || (name = fromClause.getReferenceText()) == null || !NodeRequireDirCall.isRequireDirLiteralValue(name)) continue;
                for (ES6ImportedBinding binding : decl.getImportedBindings()) {
                    String varName = binding.getName();
                    if (!StringUtil.isNotEmpty((String)varName)) continue;
                    requireDirVarNames.add(varName);
                }
            }
        }
    }

    private static void processVariable(@NotNull JSFile file, @Nullable JSVariable variable, @NotNull Set<String> requireDirVarNames, @NotNull Map<String, JSCallExpression> taskNameToPsiMap) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "processVariable"));
        }
        if (requireDirVarNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requireDirVarNames", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "processVariable"));
        }
        if (taskNameToPsiMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskNameToPsiMap", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "processVariable"));
        }
        if (variable == null) {
            return;
        }
        JSCallExpression callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)variable.getInitializerOrStub(), JSCallExpression.class);
        if (callExpression != null) {
            if (NodeRequireDirCall.isRequireDirRequireCall(callExpression)) {
                String name = variable.getQualifiedName();
                if (StringUtil.isNotEmpty((String)name)) {
                    requireDirVarNames.add(name);
                }
            } else {
                GulpfilePsiStructure.processRequireDirCall(file, callExpression, requireDirVarNames, taskNameToPsiMap);
            }
        }
    }

    private static void processRequireDirCall(@NotNull JSFile callerFile, @NotNull JSCallExpression callExpr, @NotNull Set<String> requireDirVarNames, @NotNull Map<String, JSCallExpression> taskToPsiMap) {
        VirtualFile requiredDir;
        if (callerFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callerFile", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "processRequireDirCall"));
        }
        if (callExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpr", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "processRequireDirCall"));
        }
        if (requireDirVarNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requireDirVarNames", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "processRequireDirCall"));
        }
        if (taskToPsiMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskToPsiMap", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "processRequireDirCall"));
        }
        NodeRequireDirCall requireDirCall = NodeRequireDirCall.build(callExpr, requireDirVarNames);
        if (requireDirCall != null && (requiredDir = requireDirCall.resolveRequiredDir(callerFile.getViewProvider().getVirtualFile())) != null) {
            for (VirtualFile child : requiredDir.getChildren()) {
                GulpfilePsiStructure.addTasksFromFile(callerFile.getManager(), child, taskToPsiMap);
            }
        }
    }

    private static void processFileRequireCall(@NotNull JSFile callerFile, @NotNull JSCallExpression callExpr, @NotNull Map<String, JSCallExpression> taskNameToPsiMap) {
        String value;
        JSLiteralExpression literal;
        if (callerFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callerFile", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "processFileRequireCall"));
        }
        if (callExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpr", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "processFileRequireCall"));
        }
        if (taskNameToPsiMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskNameToPsiMap", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "processFileRequireCall"));
        }
        if (callExpr.isRequireCall() && (literal = JSPsiUtil.getFirstArgumentAsStringLiteral(callExpr.getArgumentList())) != null && ((value = JSPsiUtil.getStringLiteralValue(literal)).startsWith("./") || value.startsWith("../"))) {
            for (PsiReference reference : literal.getReferences()) {
                VirtualFile child;
                PsiElement element = reference.resolve();
                if (element == null || (child = PsiUtilBase.asVirtualFile((PsiElement)element)) == null) continue;
                GulpfilePsiStructure.addTasksFromFile(callerFile.getManager(), child, taskNameToPsiMap);
            }
        }
    }

    private static void processFileRequireCall2(@NotNull JSFile callerFile, @NotNull JSCallExpression callExpr, @NotNull Map<String, JSCallExpression> taskNameToPsiMap) {
        if (callerFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callerFile", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "processFileRequireCall2"));
        }
        if (callExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpr", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "processFileRequireCall2"));
        }
        if (taskNameToPsiMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskNameToPsiMap", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "processFileRequireCall2"));
        }
        JSCallExpression requireCallExpr = (JSCallExpression)ObjectUtils.tryCast((Object)callExpr.getMethodExpression(), JSCallExpression.class);
        if (requireCallExpr != null) {
            GulpfilePsiStructure.processFileRequireCall(callerFile, requireCallExpr, taskNameToPsiMap);
        }
    }

    private static void addTasksFromFile(@NotNull PsiManager psiManager, @NotNull VirtualFile file, @NotNull Map<String, JSCallExpression> taskToPsiMap) {
        PsiFile psiFile;
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "addTasksFromFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "addTasksFromFile"));
        }
        if (taskToPsiMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskToPsiMap", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "addTasksFromFile"));
        }
        if (!file.isDirectory() && (psiFile = psiManager.findFile(file)) instanceof JSFile) {
            GulpfilePsiStructure structure = GulpfilePsiStructure.get((JSFile)psiFile);
            taskToPsiMap.putAll(structure.myPsiByNameMap);
        }
    }

    @Nullable
    private static String getGulpTaskName(@Nullable JSCallExpression callExpression) {
        String taskName;
        JSExpression[] arguments;
        if (callExpression == null) {
            return null;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)callExpression.getMethodExpression(), JSReferenceExpression.class);
        if (referenceExpression != null && GulpfilePsiStructure.isGulpTaskFunctionReference(referenceExpression) && (arguments = callExpression.getArguments()).length >= 2 && (taskName = JSPsiUtil.getStringLiteralValue(arguments[0])) != null) {
            return taskName;
        }
        return null;
    }

    private static boolean isGulpTaskFunctionReference(@NotNull JSReferenceExpression gulpTaskFunction) {
        if (gulpTaskFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gulpTaskFunction", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "isGulpTaskFunctionReference"));
        }
        if ("task".equals(gulpTaskFunction.getReferenceName())) {
            JSReferenceExpression qualifier = (JSReferenceExpression)ObjectUtils.tryCast((Object)gulpTaskFunction.getQualifier(), JSReferenceExpression.class);
            return qualifier != null && qualifier.getQualifier() == null && "gulp".equals(qualifier.getReferenceName());
        }
        return false;
    }

    public static boolean isDependency(@NotNull JSLiteralExpression dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "isDependency"));
        }
        JSArrayLiteralExpression arrayLiteral = (JSArrayLiteralExpression)ObjectUtils.tryCast((Object)dependency.getParent(), JSArrayLiteralExpression.class);
        if (arrayLiteral == null) {
            return false;
        }
        JSArgumentList argumentList = (JSArgumentList)ObjectUtils.tryCast((Object)arrayLiteral.getParent(), JSArgumentList.class);
        if (argumentList == null) {
            return false;
        }
        JSCallExpression callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)argumentList.getParent(), JSCallExpression.class);
        if (callExpression == null) {
            return false;
        }
        return GulpfilePsiStructure.getGulpTaskName(callExpression) != null;
    }

    @NotNull
    public static GulpfilePsiStructure get(final @NotNull JSFile jsFile) {
        if (jsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsFile", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "get"));
        }
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)jsFile.getProject());
        GulpfilePsiStructure gulpfilePsiStructure = (GulpfilePsiStructure)cachedValuesManager.getCachedValue((UserDataHolder)jsFile, KEY, (CachedValueProvider)new CachedValueProvider<GulpfilePsiStructure>(){

            public CachedValueProvider.Result<GulpfilePsiStructure> compute() {
                GulpfilePsiStructure structure = GulpfilePsiStructure.build(jsFile);
                return CachedValueProvider.Result.create((Object)structure, (Object[])new Object[]{jsFile});
            }
        }, false);
        if (gulpfilePsiStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "get"));
        }
        return gulpfilePsiStructure;
    }

    @Nullable
    public static Pair<String, JSCallExpression> findEnclosingTask(@NotNull PsiElement element, final @NotNull JSFile psiGulpfile) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "findEnclosingTask"));
        }
        if (psiGulpfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiGulpfile", "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure", "findEnclosingTask"));
        }
        PsiElement statement = PsiTreeUtil.findFirstParent((PsiElement)element, (boolean)false, (Condition)new Condition<PsiElement>(){

            public boolean value(PsiElement element) {
                if (element == psiGulpfile) {
                    return true;
                }
                JSCallExpression callExpression = JSPsiUtil.getCallExpression(element);
                return GulpfilePsiStructure.getGulpTaskName(callExpression) != null;
            }
        });
        JSCallExpression callExpression = JSPsiUtil.getCallExpression(statement);
        String taskName = GulpfilePsiStructure.getGulpTaskName(callExpression);
        if (callExpression != null && taskName != null) {
            return Pair.create((Object)taskName, (Object)callExpression);
        }
        return null;
    }
}

