/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp.rc;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeBase;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunConfiguration;
import com.intellij.openapi.project.Project;
import icons.JavaScriptLanguageIcons;
import org.jetbrains.annotations.NotNull;

public class GulpConfigurationType
extends ConfigurationTypeBase {
    private static final String ID = "js.build_tools.gulp";
    private static final String NAME = "Gulp.js";

    public GulpConfigurationType() {
        super(ID, NAME, NAME, JavaScriptLanguageIcons.BuildTools.Gulp16);
        this.addFactory(new ConfigurationFactory((ConfigurationType)this){

            public RunConfiguration createTemplateConfiguration(Project project) {
                return new GulpRunConfiguration(project, this, GulpConfigurationType.NAME);
            }

            public boolean isConfigurationSingletonByDefault() {
                return true;
            }

            public boolean canConfigurationBeSingleton() {
                return false;
            }
        });
    }

    @NotNull
    public static GulpConfigurationType getInstance() {
        GulpConfigurationType gulpConfigurationType = (GulpConfigurationType)ConfigurationTypeUtil.findConfigurationType(GulpConfigurationType.class);
        if (gulpConfigurationType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpConfigurationType", "getInstance"));
        }
        return gulpConfigurationType;
    }

    @NotNull
    public static ConfigurationFactory getFactory() {
        GulpConfigurationType type = GulpConfigurationType.getInstance();
        ConfigurationFactory configurationFactory = type.getConfigurationFactories()[0];
        if (configurationFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/rc/GulpConfigurationType", "getFactory"));
        }
        return configurationFactory;
    }
}

